/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.MirrorNotification;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;

public class ShaderHelper {
    private static final Minecraft MC = Minecraft.getInstance();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static float FOV_REDUCTION = 1.0f;
    private static float WATER_EFFECT;
    private static boolean WAS_IN_WATER;
    private static float PUMPKIN_EFFECT;
    private static float PORTAL_EFFECT;
    private static float RED;
    private static float BLACK;
    private static float BLUE;
    private static float TIME;

    public static void renderFullscreenQuad(@NotNull ShaderProgram instance, @NotNull RenderTarget source) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        CompiledShaderProgram program = Objects.requireNonNull(RenderSystem.setShader((ShaderProgram)instance), "required shader not loaded");
        program.bindSampler("Sampler0", source.getColorTextureId());
        program.apply();
        ShaderHelper.drawFullscreenQuad(instance.vertexFormat());
        program.clear();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private static void drawFullscreenQuad(VertexFormat format) {
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, format);
        if (format == DefaultVertexFormat.POSITION_TEX) {
            builder.addVertex(-1.0f, -1.0f, 0.0f).setUv(0.0f, 0.0f);
            builder.addVertex(1.0f, -1.0f, 0.0f).setUv(1.0f, 0.0f);
            builder.addVertex(1.0f, 1.0f, 0.0f).setUv(1.0f, 1.0f);
            builder.addVertex(-1.0f, 1.0f, 0.0f).setUv(0.0f, 1.0f);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            builder.addVertex(-1.0f, -1.0f, 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255);
            builder.addVertex(1.0f, -1.0f, 0.0f).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255);
            builder.addVertex(1.0f, 1.0f, 0.0f).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255);
            builder.addVertex(-1.0f, 1.0f, 0.0f).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255);
        } else {
            throw new IllegalStateException("Unexpected vertex format " + String.valueOf(format));
        }
        BufferUploader.draw((MeshData)builder.buildOrThrow());
    }

    public static void doVrPostProcess(RenderPass eye, RenderTarget source, float partialTick) {
        if (eye == RenderPass.LEFT) {
            RED = 0.0f;
            BLACK = 0.0f;
            BLUE = 0.0f;
            TIME = (float)Util.getMillis() / 1000.0f;
            PUMPKIN_EFFECT = 0.0f;
            PORTAL_EFFECT = 0.0f;
            if (ShaderHelper.MC.player != null && ShaderHelper.MC.level != null) {
                boolean isInWater = ((GameRendererExtension)ShaderHelper.MC.gameRenderer).vivecraft$isInWater();
                if (ShaderHelper.DATA_HOLDER.vrSettings.waterEffect && WAS_IN_WATER != isInWater) {
                    WATER_EFFECT = 2.3f;
                } else {
                    WATER_EFFECT = isInWater ? (WATER_EFFECT -= 0.008333334f) : (WATER_EFFECT -= 0.016666668f);
                    if (WATER_EFFECT < 0.0f) {
                        WATER_EFFECT = 0.0f;
                    }
                }
                WAS_IN_WATER = isInWater;
                if (IrisHelper.isLoaded() && !IrisHelper.hasWaterEffect()) {
                    WATER_EFFECT = 0.0f;
                }
                float portalTime = Mth.lerp((float)partialTick, (float)ShaderHelper.MC.player.oSpinningEffectIntensity, (float)ShaderHelper.MC.player.spinningEffectIntensity);
                PORTAL_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.portalEffect && portalTime > 0.0f && !ShaderHelper.MC.player.hasEffect(MobEffects.CONFUSION) ? portalTime : 0.0f;
                ItemStack itemstack = ShaderHelper.MC.player.getItemBySlot(EquipmentSlot.HEAD);
                PUMPKIN_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.pumpkinEffect && itemstack.getItem() == Blocks.CARVED_PUMPKIN.asItem() && !itemstack.has(DataComponents.CUSTOM_MODEL_DATA) ? 1.0f : 0.0f;
                float hurtTimer = (float)ShaderHelper.MC.player.hurtTime - partialTick;
                float healthPercent = 1.0f - ShaderHelper.MC.player.getHealth() / ShaderHelper.MC.player.getMaxHealth();
                healthPercent = (healthPercent - 0.5f) * 0.75f;
                if (ShaderHelper.DATA_HOLDER.vrSettings.hitIndicator && hurtTimer > 0.0f) {
                    hurtTimer /= (float)ShaderHelper.MC.player.hurtDuration;
                    RED = hurtTimer = healthPercent + Mth.sin((float)(hurtTimer * hurtTimer * hurtTimer * hurtTimer * (float)Math.PI)) * 0.5f;
                } else if (ShaderHelper.DATA_HOLDER.vrSettings.lowHealthIndicator) {
                    RED = healthPercent * Mth.abs((float)Mth.sin((float)(2.5f * TIME / (1.0f - healthPercent + 0.1f))));
                    if (ShaderHelper.MC.player.isCreative()) {
                        RED = 0.0f;
                    }
                }
                float freeze = ShaderHelper.MC.player.getPercentFrozen();
                if (ShaderHelper.DATA_HOLDER.vrSettings.freezeEffect && freeze > 0.0f) {
                    BLUE = RED;
                    BLUE = Math.max(freeze / 2.0f, BLUE);
                    RED = 0.0f;
                }
                if (ShaderHelper.MC.player.isSleeping()) {
                    BLACK = 0.5f + 0.3f * (float)ShaderHelper.MC.player.getSleepTimer() * 0.01f;
                }
                if (ShaderHelper.DATA_HOLDER.vr.isWalkingAbout && BLACK < 0.8f) {
                    BLACK = 0.5f;
                }
                if (ShaderHelper.DATA_HOLDER.vrSettings.useFOVReduction && ShaderHelper.DATA_HOLDER.vrPlayer.getFreeMove()) {
                    FOV_REDUCTION = Math.abs(ShaderHelper.MC.player.zza) > 0.0f || Math.abs(ShaderHelper.MC.player.xxa) > 0.0f ? (FOV_REDUCTION -= 0.05f) : (FOV_REDUCTION += 0.01f);
                    FOV_REDUCTION = Mth.clamp((float)FOV_REDUCTION, (float)ShaderHelper.DATA_HOLDER.vrSettings.fovReductionMin, (float)0.8f);
                } else {
                    FOV_REDUCTION = 1.0f;
                }
            } else {
                WATER_EFFECT = 0.0f;
                FOV_REDUCTION = 1.0f;
            }
            if (PUMPKIN_EFFECT > 0.0f) {
                VRShaders.POST_PROCESSING_FOV_REDUCTION_RADIUS_UNIFORM.set(0.3f);
                VRShaders.POST_PROCESSING_FOV_REDUCTION_BORDER_UNIFORM.set(0.0f);
            } else {
                VRShaders.POST_PROCESSING_FOV_REDUCTION_RADIUS_UNIFORM.set(FOV_REDUCTION);
                VRShaders.POST_PROCESSING_FOV_REDUCTION_BORDER_UNIFORM.set(0.06f);
            }
            VRShaders.POST_PROCESSING_FOV_REDUCTION_OFFSET_UNIFORM.set(ShaderHelper.DATA_HOLDER.vrSettings.fovRedutioncOffset);
            VRShaders.POST_PROCESSING_OVERLAY_HEALTH_ALPHA_UNiFORM.set(RED);
            VRShaders.POST_PROCESSING_OVERLAY_FREEZE_ALPHA_UNiFORM.set(BLUE);
            VRShaders.POST_PROCESSING_OVERLAY_BLACK_ALPHA_UNIFORM.set(BLACK);
            VRShaders.POST_PROCESSING_OVERLAY_TIME_UNIFORM.set(TIME);
            VRShaders.POST_PROCESSING_OVERLAY_WATER_AMPLITUDE_UNIFORM.set(WATER_EFFECT);
            VRShaders.POST_PROCESSING_OVERLAY_PORTAL_AMPLITUDE_UNIFORM.set(PORTAL_EFFECT);
            VRShaders.POST_PROCESSING_OVERLAY_PUMPKIN_AMPLITUDE_UNIFORM.set(PUMPKIN_EFFECT);
        }
        VRShaders.POST_PROCESSING_OVERLAY_EYE_UNIFORM.set(eye == RenderPass.LEFT ? 1 : -1);
        ShaderHelper.renderFullscreenQuad(VRShaders.POST_PROCESSING_SHADER, source);
    }

    public static void drawMirror() {
        if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF && ShaderHelper.DATA_HOLDER.vr.isHMDTracking()) {
            if (ShaderHelper.DATA_HOLDER.vrSettings.showMirrorOffText) {
                MirrorNotification.notify(I18n.get((String)"vivecraft.messages.mirroroff", (Object[])new Object[0]), true, 1000);
            } else {
                RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.clear((int)16384);
            }
        } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            if (MC.getShaderManager().getProgram(VRShaders.MIXED_REALITY_SHADER) != null) {
                ShaderHelper.doMixedRealityMirror();
            } else {
                MirrorNotification.notify("Mixed Reality Shader compile failed, see log for info", true, 10000);
            }
        } else if (!(ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.DUAL || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible())) {
            RenderTarget leftEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            RenderTarget rightEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
            int screenWidth = ShaderHelper.MC.mainRenderTarget.width / 2;
            int screenHeight = ShaderHelper.MC.mainRenderTarget.height;
            if (leftEye != null) {
                ShaderHelper.blitToScreen(leftEye, 0, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
            if (rightEye != null) {
                ShaderHelper.blitToScreen(rightEye, screenWidth, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
        } else {
            float xCrop = 0.0f;
            float yCrop = 0.0f;
            boolean keepAspect = false;
            RenderTarget source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                keepAspect = true;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.GUI) {
                source = GuiHandler.GUI_FRAMEBUFFER;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.SINGLE || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.CROPPED) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
                xCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                yCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                keepAspect = true;
            }
            if (source != null) {
                ShaderHelper.blitToScreen(source, 0, ShaderHelper.MC.mainRenderTarget.width, ShaderHelper.MC.mainRenderTarget.height, 0, xCrop, yCrop, keepAspect);
            }
        }
        MirrorNotification.render();
    }

    public static void doMixedRealityMirror() {
        RenderSystem.viewport((int)0, (int)0, (int)ShaderHelper.MC.mainRenderTarget.width, (int)ShaderHelper.MC.mainRenderTarget.height);
        Vector3f camPlayer = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getHeadPivotF().sub((Vector3fc)ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getPositionF());
        Matrix4f viewMatrix = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getMatrix().transpose();
        Vector3f cameraLook = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getDirection();
        cameraLook.set(-cameraLook.x, 0.0f, -cameraLook.z);
        boolean alphaMask = ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike && ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityAlphaMask;
        VRShaders.MIXED_REALITY_PROJECTION_MATRIX_UNIFORM.set(((GameRendererExtension)ShaderHelper.MC.gameRenderer).vivecraft$getThirdPassProjectionMatrix());
        VRShaders.MIXED_REALITY_VIEW_MATRIX_UNIFORM.set(viewMatrix);
        VRShaders.MIXED_REALITY_HMD_VIEW_POSITION_UNIFORM.set(camPlayer.x, camPlayer.y, camPlayer.z);
        VRShaders.MIXED_REALITY_HMD_PLANE_NORMAL_UNIFORM.set(cameraLook.x, cameraLook.y, cameraLook.z);
        if (!alphaMask) {
            VRShaders.MIXED_REALITY_KEY_COLOR_UNIFORM.set((float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getRed() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getGreen() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getBlue() / 255.0f);
        } else {
            VRShaders.MIXED_REALITY_KEY_COLOR_UNIFORM.set(0.0f, 0.0f, 0.0f);
        }
        VRShaders.MIXED_REALITY_ALPHA_MODE_UNIFORM.set(alphaMask ? 1 : 0);
        VRShaders.MIXED_REALITY_FIRST_PERSON_PASS_UNIFORM.set(ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike ? 1 : 0);
        CompiledShaderProgram mixedRealityShader = Objects.requireNonNull(RenderSystem.setShader((ShaderProgram)VRShaders.MIXED_REALITY_SHADER), "mixed reality shader not loaded");
        mixedRealityShader.bindSampler("thirdPersonColor", ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.getColorTextureId());
        mixedRealityShader.bindSampler("thirdPersonDepth", ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.getDepthTextureId());
        if (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike) {
            RenderTarget source = ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible() ? ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer : (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUndistorted ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted : (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0 : ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1));
            mixedRealityShader.bindSampler("firstPersonColor", source.getColorTextureId());
        }
        mixedRealityShader.apply();
        ShaderHelper.drawFullscreenQuad(VRShaders.MIXED_REALITY_SHADER.vertexFormat());
        mixedRealityShader.clear();
    }

    public static void doFSAA(RenderTarget source, RenderTarget firstPass, RenderTarget secondPass) {
        if (firstPass == null) {
            ShaderHelper.DATA_HOLDER.vrRenderer.reinitFrameBuffers("FSAA Setting Changed");
        } else {
            RenderSystem.disableBlend();
            RenderSystem.depthFunc((int)519);
            CompiledShaderProgram lanczosShader = Objects.requireNonNull(RenderSystem.setShader((ShaderProgram)VRShaders.LANCZOS_SHADER), "lanczos shader not loaded");
            firstPass.bindWrite(true);
            lanczosShader.bindSampler("Sampler0", source.getColorTextureId());
            lanczosShader.bindSampler("Sampler1", source.getDepthTextureId());
            VRShaders.LANCZOS_TEXEL_WIDTH_OFFSET_UNIFORM.set(1.0f / (3.0f * (float)firstPass.viewWidth));
            VRShaders.LANCZOS_TEXEL_HEIGHT_OFFSET_UNIFORM.set(0.0f);
            lanczosShader.apply();
            ShaderHelper.drawFullscreenQuad(VRShaders.LANCZOS_SHADER.vertexFormat());
            secondPass.bindWrite(true);
            lanczosShader.bindSampler("Sampler0", firstPass.getColorTextureId());
            lanczosShader.bindSampler("Sampler1", firstPass.getDepthTextureId());
            VRShaders.LANCZOS_TEXEL_WIDTH_OFFSET_UNIFORM.set(0.0f);
            VRShaders.LANCZOS_TEXEL_HEIGHT_OFFSET_UNIFORM.set(1.0f / (3.0f * (float)secondPass.viewHeight));
            lanczosShader.apply();
            ShaderHelper.drawFullscreenQuad(VRShaders.LANCZOS_SHADER.vertexFormat());
            lanczosShader.clear();
            secondPass.unbindWrite();
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableBlend();
        }
    }

    public static void blitToScreen(RenderTarget source, int left, int width, int height, int top, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        float drawAspect = (float)width / (float)height;
        float bufferAspect = (float)source.viewWidth / (float)source.viewHeight;
        float xMin = xCropFactor;
        float yMin = yCropFactor;
        float xMax = 1.0f - xCropFactor;
        float yMax = 1.0f - yCropFactor;
        if (keepAspect) {
            if (drawAspect > bufferAspect) {
                float heightAspect = bufferAspect / drawAspect * (0.5f - yCropFactor);
                yMin = 0.5f - heightAspect;
                yMax = 0.5f + heightAspect;
            } else {
                float widthAspect = drawAspect / bufferAspect * (0.5f - xCropFactor);
                xMin = 0.5f - widthAspect;
                xMax = 0.5f + widthAspect;
            }
        }
        CompiledShaderProgram blitShader = Objects.requireNonNull(RenderSystem.setShader((ShaderProgram)VRShaders.BLIT_VR_SHADER), "Vivecraft blit shader not loaded");
        blitShader.bindSampler("DiffuseSampler", source.getColorTextureId());
        blitShader.apply();
        BufferBuilder bufferBuilder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, VRShaders.BLIT_VR_SHADER.vertexFormat());
        float xMinPos = (float)left / (float)ShaderHelper.MC.getMainRenderTarget().viewWidth * 2.0f - 1.0f;
        float yMinPos = (float)top / (float)ShaderHelper.MC.getMainRenderTarget().viewHeight * 2.0f - 1.0f;
        float xMaxPos = xMinPos + (float)width / (float)ShaderHelper.MC.getMainRenderTarget().viewWidth * 2.0f;
        float yMaxPos = yMinPos + (float)height / (float)ShaderHelper.MC.getMainRenderTarget().viewHeight * 2.0f;
        bufferBuilder.addVertex(xMinPos, yMinPos, 0.0f).setUv(xMin, yMin);
        bufferBuilder.addVertex(xMaxPos, yMinPos, 0.0f).setUv(xMax, yMin);
        bufferBuilder.addVertex(xMaxPos, yMaxPos, 0.0f).setUv(xMax, yMax);
        bufferBuilder.addVertex(xMinPos, yMaxPos, 0.0f).setUv(xMin, yMax);
        BufferUploader.draw((MeshData)bufferBuilder.buildOrThrow());
        blitShader.clear();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

