/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.renderer.entity.layers;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.common.utils.MathUtils;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin
extends RenderLayer<PlayerRenderState, PlayerModel> {
    @Unique
    private final Vector3f vivecraft$tempV = new Vector3f();
    @Unique
    private final Matrix3f vivecraft$bodyRot = new Matrix3f();

    public CapeLayerMixin(RenderLayerParent<PlayerRenderState, PlayerModel> renderer) {
        super(renderer);
    }

    @ModifyExpressionValue(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/CapeLayer;hasLayer(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/equipment/EquipmentModel$LayerType;)Z", ordinal=1)})
    private boolean vivecraft$modifyTransform(boolean hasArmor, @Local(argsOnly=true) PlayerRenderState renderState, @Local(argsOnly=true) PoseStack poseStack) {
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)renderState).vivecraft$getRotInfo();
        if (rotInfo != null) {
            this.vivecraft$bodyRot.rotationZYX(((PlayerModel)this.getParentModel()).body.zRot, -((PlayerModel)this.getParentModel()).body.yRot, -((PlayerModel)this.getParentModel()).body.xRot);
            this.vivecraft$bodyRot.transform(MathUtils.UP, this.vivecraft$tempV);
            float xRot = (float)Math.atan2(this.vivecraft$tempV.y, this.vivecraft$tempV.z) - 1.5707964f;
            xRot = xRot < (float)(-Math.PI) ? xRot + (float)Math.PI * 2 : xRot;
            this.vivecraft$bodyRot.transform(MathUtils.LEFT, this.vivecraft$tempV);
            float yRot = (float)(-Math.atan2(this.vivecraft$tempV.x, this.vivecraft$tempV.y)) + 1.5707964f;
            this.vivecraft$tempV.set(0.0f, 0.0f, 5.5f - 0.5f * (((PlayerModel)this.getParentModel()).body.xRot / 1.5707964f));
            if (hasArmor) {
                this.vivecraft$tempV.add(0.0f, -0.85f, 1.1f);
            }
            this.vivecraft$tempV.rotateX(xRot);
            this.vivecraft$tempV.rotateZ(yRot);
            this.vivecraft$tempV.add(((PlayerModel)this.getParentModel()).body.x, ((PlayerModel)this.getParentModel()).body.y + 24.0f, ((PlayerModel)this.getParentModel()).body.z);
            ModelUtils.modelToWorld((HumanoidRenderState)renderState, (Vector3fc)this.vivecraft$tempV, rotInfo, 0.0f, false, false, this.vivecraft$tempV);
            poseStack.translate(this.vivecraft$tempV.x, -this.vivecraft$tempV.y, -this.vivecraft$tempV.z);
            float min = (renderState.isFallFlying ? 1.0f : renderState.swimAmount) * -1.5707964f;
            float flap = renderState.capeFlap + 57.295776f * Math.max(min, xRot);
            float lean = xRot / 1.5707964f;
            lean = lean >= 0.0f ? renderState.capeLean * (1.0f - Mth.clamp((float)lean, (float)0.0f, (float)1.0f)) : 0.0f;
            poseStack.mulPose(new Quaternionf().rotateX((6.0f + lean / 2.0f + flap) * ((float)Math.PI / 180)).rotateZ(renderState.capeLean2 / 2.0f * ((float)Math.PI / 180)).rotateY((180.0f - renderState.capeLean2 / 2.0f) * ((float)Math.PI / 180) + yRot));
            return false;
        }
        return hasArmor;
    }
}

