/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.world.entity.projectile;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;

@Mixin(value={FireworkRocketEntity.class})
public class FireworkRocketEntityVRMixin {
    @Shadow
    @Nullable
    private LivingEntity attachedToEntity;

    @ModifyArg(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), index=1)
    private double vivecraft$modifyX(double x, @Share(value="handPos") LocalRef<Vec3> handPos) {
        LivingEntity livingEntity = this.attachedToEntity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ClientVRPlayers.getInstance().isVRPlayer((Entity)player)) {
                boolean fireworkInMainHand;
                boolean bl = fireworkInMainHand = player.getMainHandItem().is(Items.FIREWORK_ROCKET) || !player.getOffhandItem().is(Items.FIREWORK_ROCKET);
                if (VRState.VR_RUNNING && this.attachedToEntity == Minecraft.getInstance().player) {
                    VRData.VRDevicePose controller = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getHand(fireworkInMainHand ? 0 : 1);
                    Vector3f offset = controller.getDirection().mul(0.25f);
                    handPos.set((Object)controller.getPosition().add((double)offset.x, (double)offset.y, (double)offset.z));
                } else {
                    ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.getUUID());
                    Vector3fc pos = fireworkInMainHand ? rotInfo.mainHandPos : rotInfo.offHandPos;
                    handPos.set((Object)player.position().add((double)pos.x(), (double)pos.y(), (double)pos.z()));
                }
                return ((Vec3)handPos.get()).x;
            }
        }
        return x;
    }

    @ModifyArg(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), index=2)
    private double vivecraft$modifyY(double y, @Share(value="handPos") LocalRef<Vec3> handPos) {
        return handPos.get() != null ? ((Vec3)handPos.get()).y : y;
    }

    @ModifyArg(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), index=3)
    private double vivecraft$modifyZ(double z, @Share(value="handPos") LocalRef<Vec3> handPos) {
        return handPos.get() != null ? ((Vec3)handPos.get()).z : z;
    }
}

