/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.vivecraft.Xloader;
import org.vivecraft.client_vr.settings.VRSettings;

public class FileUtils {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 20000;

    public static void unpackAsset(String sourcePath, String targetFile, boolean required) {
        block14: {
            try {
                Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("vivecraft", sourcePath));
                if (resource.isPresent()) {
                    try (InputStream is = ((Resource)resource.get()).m_215507_();
                         FileOutputStream os = new FileOutputStream(targetFile);){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        break block14;
                    }
                }
                FileUtils.unpackFile("assets/vivecraft/" + sourcePath, targetFile, required);
            }
            catch (Exception exception) {
                FileUtils.handleAssetException(exception, sourcePath, required);
            }
        }
    }

    public static String loadAssetToString(String sourcePath, boolean required) {
        block8: {
            String string;
            block9: {
                Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("vivecraft", sourcePath));
                if (!resource.isPresent()) break block8;
                InputStream is = ((Resource)resource.get()).m_215507_();
                try {
                    string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        FileUtils.handleAssetException(exception, sourcePath, required);
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    public static void unpackAssetToFolder(String sourcePath, String targetFolder, boolean required) {
        FileUtils.unpackAsset(sourcePath, targetFolder + "/" + sourcePath, required);
    }

    private static void handleAssetException(Throwable e, String name, boolean required) {
        VRSettings.LOGGER.error("Vivecraft: Failed to unpack '{}' from jar:", (Object)name, (Object)e);
        if (required) {
            throw new RuntimeException("Vivecraft: Failed to unpack '" + name + "' from jar: " + e.getMessage(), e);
        }
    }

    private static boolean unpackFile(Path sourcePath, File targetFile, boolean required) {
        try {
            VRSettings.LOGGER.info("Vivecraft: Unpacking file '{}' ...", (Object)sourcePath);
            targetFile.getParentFile().mkdirs();
            Files.copy(sourcePath, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception exception) {
            FileUtils.handleAssetException(exception, sourcePath.toString(), required);
            return false;
        }
    }

    public static boolean unpackFile(String sourceFile, String targetFile, boolean required) {
        return FileUtils.unpackFile(Xloader.getJarPath().resolve(sourceFile), new File(targetFile), required);
    }

    public static boolean unpackFolder(String source, String target) {
        VRSettings.LOGGER.info("Vivecraft: Unpacking files of '{}' ...", (Object)source);
        new File(target).mkdirs();
        boolean didExtractSomething = false;
        try (Stream<Path> natives = Files.list(Xloader.getJarPath().resolve(source));){
            for (Path file : natives.collect(Collectors.toCollection(ArrayList::new))) {
                didExtractSomething |= FileUtils.unpackFile(file, new File(target + "/" + String.valueOf(file.getFileName())), false);
            }
        }
        catch (IOException e) {
            FileUtils.handleAssetException(e, source, false);
            return false;
        }
        if (!didExtractSomething) {
            VRSettings.LOGGER.warn("Vivecraft: Failed to unpack files from jar, no files");
        }
        return didExtractSomething;
    }

    public static String httpReadLine(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(20000);
        conn.setUseCaches(false);
        conn.setDoInput(true);
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = br.readLine();
        br.close();
        conn.disconnect();
        return line;
    }

    public static List<String> httpReadAllLines(String url) throws IOException, UncheckedIOException {
        try (InputStream is = new URL(url).openStream();){
            List list = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return list;
        }
    }

    public static void httpReadToFile(String url, File file) throws IOException {
        IOUtils.copy((URL)new URL(url), (File)file);
    }

    public static String getFileChecksum(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        byte[] bytes;
        try (FileInputStream is = new FileInputStream(file);){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(bytes);
        try (Formatter formatter = new Formatter();){
            for (byte b : messageDigest.digest()) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }
}

