/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.function.Consumer;
import java.util.function.Function;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_xr.render_pass.RenderPassType;

public class MultiPassRenderTarget
extends RenderTarget {
    private final RenderTarget mainTarget;
    private final Function<RenderPass, RenderTarget> vrTargets;

    public MultiPassRenderTarget(RenderTarget mainTarget, Function<RenderPass, RenderTarget> vrTargets) {
        super(mainTarget.f_83919_);
        this.mainTarget = mainTarget;
        this.vrTargets = vrTargets;
        this.f_83915_ = mainTarget.f_83915_;
        this.f_83916_ = mainTarget.f_83916_;
        this.f_83917_ = mainTarget.f_83917_;
        this.f_83918_ = mainTarget.f_83918_;
        this.f_83920_ = mainTarget.f_83920_;
        this.f_83922_ = mainTarget.f_83922_;
    }

    public void m_83941_(int width, int height, boolean clearError) {
        this.callOnTarget(r -> r.m_83941_(width, height, clearError));
    }

    public void m_83930_() {
        this.callOnAllTargets(RenderTarget::m_83930_);
    }

    public void m_83945_(RenderTarget otherTarget) {
        this.callOnTarget(r -> r.m_83945_(otherTarget));
    }

    public void m_83950_(int width, int height, boolean clearError) {
        this.callOnTarget(r -> r.m_83950_(width, height, clearError));
    }

    public void m_83936_(int filterMode) {
        this.callOnTarget(r -> r.m_83936_(filterMode));
    }

    public void m_83949_() {
        this.callOnTarget(RenderTarget::m_83949_);
    }

    public void m_83956_() {
        this.callOnTarget(RenderTarget::m_83956_);
    }

    public void m_83963_() {
        this.callOnTarget(RenderTarget::m_83963_);
    }

    public void m_83947_(boolean setViewport) {
        this.callOnTarget(r -> r.m_83947_(setViewport));
    }

    public void m_83970_() {
        this.callOnTarget(RenderTarget::m_83970_);
    }

    public void m_83931_(float red, float green, float blue, float alpha) {
        this.callOnTarget(r -> r.m_83931_(red, green, blue, alpha));
    }

    public void m_83938_(int width, int height) {
        this.callOnTarget(r -> r.m_83938_(width, height));
    }

    public void m_83957_(int width, int height, boolean disableBlend) {
        this.callOnTarget(r -> r.m_83957_(width, height, disableBlend));
    }

    public void m_83954_(boolean clearError) {
        this.callOnTarget(r -> r.m_83954_(clearError));
    }

    public int m_83975_() {
        return this.callOnTargetRet(RenderTarget::m_83975_);
    }

    public int m_83980_() {
        return this.callOnTargetRet(RenderTarget::m_83980_);
    }

    private void callOnTarget(Consumer<RenderTarget> consumer) {
        consumer.accept(this.getCurrent());
    }

    private <T> T callOnTargetRet(Function<RenderTarget, T> function) {
        return function.apply(this.getCurrent());
    }

    private void callOnAllTargets(Consumer<RenderTarget> consumer) {
        consumer.accept(this.mainTarget);
        for (RenderPass pass : RenderPass.values()) {
            RenderTarget target = this.vrTargets.apply(pass);
            if (target == null) continue;
            consumer.accept(target);
        }
    }

    private RenderTarget getCurrent() {
        if (RenderPassType.isVanilla()) {
            return this.mainTarget;
        }
        RenderTarget target = this.vrTargets.apply(ClientDataHolderVR.getInstance().currentPass);
        return target != null ? target : this.mainTarget;
    }
}

