/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.client.HeldInteractModule;
import org.vivecraft.api.client.InteractModule;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.interact_modules.DebugRenderModule;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;

public class InteractTracker
implements DebugRenderTracker {
    private final List<InteractModule> modules = new ArrayList<InteractModule>();
    private final InteractModule[] activeModules = new InteractModule[2];
    private final boolean[] pressed = new boolean[2];
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public InteractTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    public void registerModules(InteractModule ... modules) {
        for (InteractModule module : modules) {
            if (this.modules.stream().anyMatch(m -> m.equals(module) || m.getId().equals((Object)module.getId()))) {
                throw new IllegalArgumentException("InteractModule '" + String.valueOf(module.getId()) + "' is already added and should not be added again!");
            }
            this.modules.add(module);
        }
        this.modules.sort((a, b) -> a.getPriority() == b.getPriority() ? a.getId().compareTo(b.getId()) : Integer.compare(a.getPriority(), b.getPriority()));
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (this.mc.f_91080_ instanceof FBTCalibrationScreen) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        return !player.m_21254_() || this.dh.hotbarModule.hotbar >= 0;
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        if (this.mc.f_91080_ instanceof FBTCalibrationScreen) {
            return;
        }
        for (int c = 0; c < 2; ++c) {
            this.reset(player, c);
        }
    }

    private void reset(LocalPlayer player, int c) {
        InteractModule interactModule;
        if (this.pressed[c] && (interactModule = this.activeModules[c]) instanceof HeldInteractModule) {
            HeldInteractModule heldModule = (HeldInteractModule)interactModule;
            heldModule.onRelease(player, InteractionHand.values()[c]);
        }
        this.pressed[c] = false;
        this.activeModules[c] = null;
        this.modules.forEach(module -> module.reset(player, InteractionHand.values()[c]));
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[c], false);
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        for (int c = 0; c < 2; ++c) {
            HeldInteractModule heldModule;
            InteractModule interactModule;
            if (VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.values()[c]) && (interactModule = this.activeModules[c]) instanceof HeldInteractModule && (heldModule = (HeldInteractModule)interactModule).onHoldTick(player, InteractionHand.values()[c])) continue;
            boolean wasActive = this.activeModules[c] != null;
            this.reset(player, c);
            Vec3 handPos = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition();
            for (InteractModule module : this.modules) {
                if (!module.isActive(player, InteractionHand.values()[c], handPos)) continue;
                this.activeModules[c] = module;
                break;
            }
            if (!wasActive && this.activeModules[c] != null) {
                this.dh.vr.triggerHapticPulse(c, 250);
            }
            this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[c], this.activeModules[c] != null);
        }
    }

    public boolean isActiveModule(InteractModule module) {
        return this.isActiveModule(module, 0) || this.isActiveModule(module, 1);
    }

    public boolean isActiveModule(InteractModule module, int controller) {
        return this.activeModules[controller] == module;
    }

    public void processBindings() {
        for (int c = 0; c < 2; ++c) {
            if (!VivecraftVRMod.INSTANCE.keyVRInteract.consumeClick(ControllerType.values()[c]) || this.activeModules[c] == null) continue;
            this.pressed[c] = true;
            InteractionHand hand = InteractionHand.values()[c];
            if (!this.activeModules[c].onPress(this.mc.f_91074_, hand)) continue;
            if (this.activeModules[c].swingsArm()) {
                this.dh.swingType = VRFirstPersonArmSwing.INTERACT;
                this.mc.f_91074_.m_6674_(hand);
            }
            this.dh.vr.triggerHapticPulse(c, 750);
        }
    }

    @Override
    public void renderDebug(PoseStack poseStack) {
        for (InteractModule module : this.modules) {
            if (!(module instanceof DebugRenderModule)) continue;
            DebugRenderModule debugModule = (DebugRenderModule)module;
            debugModule.renderDebug(poseStack, this.isActiveModule(module));
        }
    }
}

