/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.Xplat;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.Vector3fHistory;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.data.ViveBlockTags;
import org.vivecraft.data.ViveItemTags;
import org.vivecraft.mod_compat_vr.bettercombat.BetterCombatHelper;
import org.vivecraft.mod_compat_vr.epicfight.EpicFightHelper;

public class SwingTracker
implements DebugRenderTracker {
    private static final int[] CONTROLLER_AND_FEET = new int[]{0, 1, 4, 5};
    private static final VRBodyPart[] BODYPARTS = new VRBodyPart[]{VRBodyPart.MAIN_HAND, VRBodyPart.OFF_HAND, VRBodyPart.RIGHT_FOOT, VRBodyPart.LEFT_FOOT};
    private static final float SPEED_THRESH = 3.0f;
    public int disableSwing = 3;
    private final Quaternionf[] lastHandRot = new Quaternionf[4];
    private final Vec3[] lastHandPos = new Vec3[4];
    private final List<Vec3>[] miningPoints = new List[4];
    private final boolean[] lastWeaponSolid = new boolean[4];
    private final List<Entity>[] lastHitEntities = new List[]{Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()};
    private final Vec3[] miningPoint = new Vec3[4];
    private final Vec3[] attackingPoint = new Vec3[4];
    private final Vec3[] weaponTip = new Vec3[4];
    private final Vector3fHistory[] tipHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory()};
    private final boolean[] canAct = new boolean[4];
    private final AABB[] lastAttackAABB = new AABB[4];
    private final Vec3[] lastBlockHit = new Vec3[4];
    private final int[] lastMiningPointHit = new int[4];
    private final LinkedList<Pair<Vec3, Vector3fc>>[] previousMiningPoints = new LinkedList[]{new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList()};
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public SwingTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.disableSwing > 0) {
            --this.disableSwing;
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        if (this.mc.f_91080_ != null) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.OFF) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.AUTO && player.m_7500_()) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (this.dh.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.RUN_IN_PLACE && player.f_20902_ > 0.0f) {
            return false;
        }
        if (player.m_21254_() && !ClientNetworking.SERVER_ALLOWS_ATTACKING_WHILE_BLOCKING) {
            return false;
        }
        return !this.dh.jumpTracker.isjumping();
    }

    public static boolean isTool(ItemStack itemStack) {
        return SwingTracker.isToolItem(itemStack.m_41720_()) || itemStack.m_204117_(ViveItemTags.VIVECRAFT_TOOLS) || itemStack.m_204117_(ItemTags.f_271360_) || itemStack.m_204117_(ItemTags.f_271207_) || itemStack.m_204117_(ItemTags.f_271138_) || itemStack.m_204117_(ItemTags.f_271298_);
    }

    private static boolean isToolItem(Item item) {
        return item instanceof DiggerItem || item instanceof ArrowItem || item instanceof FishingRodItem || item instanceof FoodOnAStickItem || item instanceof ShearsItem || item == Items.f_42500_ || item == Items.f_42585_ || item == Items.f_41911_ || item == Items.f_42000_ || item == Items.f_41978_ || item == Items.f_42398_ || item == Items.f_42751_ || item instanceof FlintAndSteelItem || item instanceof BrushItem;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        for (int i = 0; i < 4; ++i) {
            this.lastHandPos[i] = null;
            this.attackingPoint[i] = null;
            this.weaponTip[i] = null;
            this.miningPoints[i] = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void activeProcess(LocalPlayer player) {
        float speedTreshhold = 3.0f;
        if (player.m_7500_()) {
            speedTreshhold *= 1.5f;
        }
        this.mc.m_91307_().m_6180_("updateSwingAttack");
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        for (int i = 0; i < trackers; ++i) {
            BlockHitResult blockhitresult;
            boolean isHand;
            int c = CONTROLLER_AND_FEET[i];
            boolean bl = isHand = i < 2;
            if (isHand && this.dh.climbTracker.isGrabbingLadder(c)) continue;
            Vec3 handPos = this.dh.vrPlayer.vrdata_world_pre.getDevice(c).getPosition();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(MathUtils.BACK);
            ItemStack itemstack = player.m_21120_(c == 1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            Item item = itemstack.m_41720_();
            boolean isTool = false;
            boolean isSword = false;
            if (this.dh.vrSettings.onlySwordCollision && !(item instanceof SwordItem) && !itemstack.m_204117_(ViveItemTags.VIVECRAFT_SWORDS)) continue;
            if (!(item instanceof SwordItem || itemstack.m_204117_(ViveItemTags.VIVECRAFT_SWORDS) || item instanceof TridentItem || itemstack.m_204117_(ViveItemTags.VIVECRAFT_SPEARS))) {
                if (SwingTracker.isTool(itemstack)) {
                    isTool = true;
                }
            } else {
                isSword = true;
                isTool = true;
            }
            float weaponLength = 0.0f;
            float entityReachAdd = 0.3f;
            if (isHand) {
                double playerEntityReach = Xplat.getItemEntityReach(3.0, itemstack, c == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                if (BetterCombatHelper.isLoaded()) {
                    playerEntityReach = BetterCombatHelper.getItemRange(playerEntityReach, itemstack);
                }
                playerEntityReach = Math.min(playerEntityReach, 6.0) - 0.5;
                if (isSword) {
                    weaponLength = 0.6f;
                    entityReachAdd = (float)playerEntityReach - weaponLength;
                } else if (isTool) {
                    weaponLength = 0.35f;
                    entityReachAdd = (float)playerEntityReach * 0.62f - weaponLength;
                } else if (!itemstack.m_41619_()) {
                    weaponLength = 0.1f;
                    entityReachAdd = (float)playerEntityReach * 0.16f - weaponLength;
                }
            }
            Vec3 prevMiningPoint = this.miningPoint[i];
            Vector3f weaponEnd = handDirection.mul(weaponLength *= this.dh.vrPlayer.vrdata_world_pre.worldScale, new Vector3f());
            this.miningPoint[i] = handPos.m_82520_((double)weaponEnd.x, (double)weaponEnd.y, (double)weaponEnd.z);
            Vector3f tip = this.dh.vrPlayer.vrdata_room_pre.getDevice(c).getPositionF().add((Vector3fc)this.dh.vrPlayer.vrdata_room_pre.getHand(c).getCustomVector(MathUtils.BACK).mul(0.3f));
            this.tipHistory[i].add((Vector3fc)tip);
            float speed = this.tipHistory[i].averageSpeed(0.33);
            boolean inAnEntity = false;
            this.canAct[i] = speed > speedTreshhold && !this.lastWeaponSolid[i];
            boolean entityAct = this.canAct[i];
            if (entityAct && (blockhitresult = this.mc.f_91073_.m_45547_(new ClipContext(this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition(), handPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_))).m_6662_() != HitResult.Type.MISS) {
                entityAct = false;
            }
            Vec3 lastAttackPoint = this.attackingPoint[i];
            Vec3 lastWeaponTip = this.weaponTip[i];
            this.attackingPoint[i] = this.constrain(handPos, this.miningPoint[i]);
            Vector3f weaponEntityEnd = handDirection.mul(weaponLength + entityReachAdd, new Vector3f());
            this.weaponTip[i] = handPos.m_82520_((double)weaponEntityEnd.x, (double)weaponEntityEnd.y, (double)weaponEntityEnd.z);
            this.weaponTip[i] = this.constrain(handPos, this.weaponTip[i]);
            AABB weaponBB = new AABB(handPos, this.attackingPoint[i]);
            AABB weaponTipBB = new AABB(handPos, this.weaponTip[i]);
            if (lastAttackPoint != null) {
                weaponBB = Utils.includePoint(weaponBB, lastAttackPoint);
            }
            if (lastWeaponTip != null) {
                weaponTipBB = Utils.includePoint(weaponTipBB, lastWeaponTip);
            }
            this.lastAttackAABB[i] = weaponTipBB;
            List<Object> mobs = this.mc.f_91073_.m_45933_((Entity)this.mc.f_91074_, weaponTipBB);
            if (this.dh.vrSettings.reducedPlayerReach) {
                mobs.removeIf(e -> e instanceof Player);
                List players = this.mc.f_91073_.m_45933_((Entity)this.mc.f_91074_, weaponBB);
                players.removeIf(e -> !(e instanceof Player));
                mobs.addAll(players);
            }
            for (Entity entity : mobs) {
                if (!entity.m_6087_() || entity == this.mc.m_91288_().m_20202_() || this.lastHitEntities[i].contains(entity)) continue;
                if (entityAct) {
                    if (!EpicFightHelper.isLoaded() || !EpicFightHelper.attack()) {
                        ClientNetworking.sendActiveBodyPart(BODYPARTS[i], true);
                        this.mc.f_91072_.m_105223_((Player)player, entity);
                    } else {
                        entityAct = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 1000);
                    this.lastWeaponSolid[i] = true;
                }
                inAnEntity = true;
            }
            this.lastHitEntities[i] = speed > speedTreshhold ? mobs : Collections.emptyList();
            int n = i;
            this.canAct[n] = this.canAct[n] & !inAnEntity;
            if (isHand && this.dh.climbTracker.isClimbeyClimb() && (!isTool || c == 0 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) || c == 1 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT))) {
                this.lastHandPos[i] = null;
                this.lastHandRot[i] = null;
                continue;
            }
            BlockHitResult blockHit = null;
            Object var28_31 = null;
            this.lastMiningPointHit[i] = 0;
            Quaternionf weaponRotation = new Quaternionf().setFromNormalized((Matrix4fc)this.dh.vrPlayer.vrdata_world_pre.getHand(c).getMatrix());
            if (this.canAct[i]) {
                this.miningPoints[i] = new ArrayList<Vec3>();
                if (this.lastHandPos[i] != null && prevMiningPoint != null) {
                    float dot = Math.abs(weaponRotation.dot(this.lastHandRot[i]));
                    float angle = 2.0f * (float)Math.acos(dot);
                    float subdivisions = Mth.m_14143_((float)(angle / (float)Math.PI * 8.0f));
                    Quaternionf temp = new Quaternionf();
                    Vector3f lerpHandDir = new Vector3f();
                    this.miningPoints[i].add(prevMiningPoint);
                    int s = 1;
                    while ((float)s < subdivisions) {
                        float lerp = (float)s / subdivisions;
                        this.lastHandRot[i].slerp((Quaternionfc)weaponRotation, lerp, temp);
                        Vec3 lerpHand = MathUtils.vecDLerp(this.lastHandPos[i], handPos, lerp);
                        temp.transform(0.0f, 0.0f, -weaponLength, lerpHandDir);
                        this.miningPoints[i].add(lerpHand.m_82520_((double)lerpHandDir.x, (double)lerpHandDir.y, (double)lerpHandDir.z));
                        ++s;
                    }
                } else {
                    this.miningPoints[i].add(this.miningPoint[i]);
                }
                this.miningPoints[i].add(this.miningPoint[i]);
                for (int p = 1; p < this.miningPoints[i].size(); ++p) {
                    Vec3 endPos;
                    Vec3 startPos = this.miningPoints[i].get(p - 1);
                    if (startPos.m_82546_(endPos = this.miningPoints[i].get(p)).m_82556_() < 1.0E-7) {
                        endPos = endPos.m_82520_(0.001, 0.001, 0.001);
                    }
                    blockHit = this.mc.f_91073_.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                    BlockState blockState = this.mc.f_91073_.m_8055_(blockHit.m_82425_());
                    ClientNetworking.BODY_PART_CLIENT_OVERRIDE = BODYPARTS[i];
                    boolean mineableByItem = this.dh.vrSettings.swordBlockCollision && (itemstack.m_41735_(blockState) || blockState.m_60625_((Player)player, (BlockGetter)player.m_9236_(), blockHit.m_82425_()) == 1.0f);
                    ClientNetworking.BODY_PART_CLIENT_OVERRIDE = null;
                    boolean protectedBlock = this.dh.vrSettings.realisticClimbEnabled && (blockState.m_60734_() instanceof LadderBlock || blockState.m_60734_() instanceof VineBlock || blockState.m_204336_(ViveBlockTags.VIVECRAFT_CLIMBABLE));
                    this.lastMiningPointHit[i] = p;
                    if (isSword && !mineableByItem || protectedBlock) {
                        blockHit = null;
                        Object var28_34 = null;
                        continue;
                    }
                    if (blockHit.m_6662_() == HitResult.Type.BLOCK) break;
                }
            }
            this.lastHandPos[i] = handPos;
            this.lastHandRot[i] = weaponRotation;
            if (blockHit != null && blockHit.m_6662_() == HitResult.Type.BLOCK && !blockHit.m_82436_() && this.canAct[i]) {
                void var28_32;
                this.lastWeaponSolid[i] = true;
                this.lastBlockHit[i] = blockHit.m_82450_();
                int totalHits = 3;
                if (!this.dh.vrSettings.doorHitting || !this.isOpenable((BlockState)var28_32, blockHit.m_82434_()) || this.mc.f_91072_.m_233732_(player, c == 1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, blockHit) == InteractionResult.PASS) {
                    if (isHand && (item instanceof HoeItem || itemstack.m_204117_(ViveItemTags.VIVECRAFT_HOES) || itemstack.m_204117_(ViveItemTags.VIVECRAFT_SCYTHES)) && (var28_32.m_60734_() instanceof CropBlock || var28_32.m_60734_() instanceof StemBlock || var28_32.m_60734_() instanceof AttachedStemBlock || var28_32.m_204336_(ViveBlockTags.VIVECRAFT_CROPS) || item.m_6225_(new UseOnContext((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit)).m_19080_())) {
                        boolean useSuccessful = this.mc.f_91072_.m_233732_(player, i == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit).m_19080_();
                        if (itemstack.m_204117_(ViveItemTags.VIVECRAFT_SCYTHES) && !useSuccessful) {
                            this.mc.f_91072_.m_233721_((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                        }
                    } else if (isHand && item instanceof BrushItem) {
                        ((BrushItem)item).m_278154_(player.m_9236_(), blockHit, (BlockState)var28_32, player.m_20252_(0.0f), c == 0 ? player.m_5737_() : player.m_5737_().m_20828_());
                        player.m_9236_().m_247517_((Player)player, blockHit.m_82425_(), var28_32.m_60734_() instanceof BrushableBlock ? ((BrushableBlock)var28_32.m_60734_()).m_276856_() : SoundEvents.f_276624_, SoundSource.BLOCKS);
                        this.mc.f_91072_.m_233732_(player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit);
                    } else if (var28_32.m_60734_() instanceof NoteBlock || var28_32.m_204336_(ViveBlockTags.VIVECRAFT_MUSIC_BLOCKS)) {
                        this.mc.f_91072_.m_105283_(blockHit.m_82425_(), blockHit.m_82434_());
                    } else {
                        totalHits = (int)((float)totalHits + Math.min(speed - speedTreshhold, 4.0f));
                        ClientNetworking.sendActiveBodyPart(BODYPARTS[i], true);
                        this.mc.f_91072_.m_105269_(blockHit.m_82425_(), blockHit.m_82434_());
                        if (this.getIsHittingBlock()) {
                            for (int hit = 0; hit < totalHits; ++hit) {
                                if (this.mc.f_91072_.m_105283_(blockHit.m_82425_(), blockHit.m_82434_())) {
                                    this.mc.f_91061_.m_107367_(blockHit.m_82425_(), blockHit.m_82434_());
                                }
                                this.clearBlockHitDelay();
                                if (!this.getIsHittingBlock()) break;
                            }
                            this.mc.f_91072_.f_105195_ = 0;
                        }
                        this.dh.vrPlayer.blockDust(blockHit.m_82450_().f_82479_, blockHit.m_82450_().f_82480_, blockHit.m_82450_().f_82481_, 3 * totalHits, blockHit.m_82425_(), (BlockState)var28_32, 0.6f, 1.0f);
                    }
                }
                this.dh.vr.triggerHapticPulse(c, 250 * totalHits);
                continue;
            }
            this.lastWeaponSolid[i] = false;
        }
        ClientNetworking.resetActiveBodyPart();
        this.mc.m_91307_().m_7238_();
    }

    private boolean getIsHittingBlock() {
        return this.mc.f_91072_.m_105296_();
    }

    private void clearBlockHitDelay() {
    }

    private Vec3 constrain(Vec3 start, Vec3 end) {
        BlockHitResult blockhitresult = this.mc.f_91073_.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_));
        return blockhitresult.m_6662_() == HitResult.Type.BLOCK ? blockhitresult.m_82450_() : end;
    }

    private boolean isOpenable(BlockState state, Direction direction) {
        if (state.m_204336_(BlockTags.f_13103_) || state.m_60734_() instanceof DoorBlock) {
            Direction facing = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            if (!open) {
                return facing == direction.m_122424_();
            }
            return switch (direction) {
                case Direction.SOUTH -> {
                    if (facing == Direction.WEST && hinge == DoorHingeSide.LEFT || facing == Direction.EAST && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (facing == Direction.EAST && hinge == DoorHingeSide.LEFT || facing == Direction.WEST && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> {
                    if (facing == Direction.SOUTH && hinge == DoorHingeSide.LEFT || facing == Direction.NORTH && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.WEST -> {
                    if (facing == Direction.NORTH && hinge == DoorHingeSide.LEFT || facing == Direction.SOUTH && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        if (state.m_204336_(BlockTags.f_13036_) || state.m_60734_() instanceof TrapDoorBlock) {
            Direction facing = (Direction)state.m_61143_((Property)TrapDoorBlock.f_54117_);
            boolean open = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            return !open && direction == Direction.DOWN || open && direction.m_122424_() == facing;
        }
        if (state.m_204336_(BlockTags.f_13055_) || state.m_60734_() instanceof FenceGateBlock) {
            Direction facing = (Direction)state.m_61143_((Property)FenceGateBlock.f_54117_);
            boolean open = (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_);
            return !open && direction.m_122434_() == facing.m_122434_();
        }
        return false;
    }

    public static float getItemFade(LocalPlayer player, ItemStack itemStack) {
        float fade = player.m_36403_(0.0f) * 0.75f + 0.25f;
        if (player.m_6144_()) {
            fade = 0.75f;
        }
        if (ClientDataHolderVR.getInstance().swingTracker.lastWeaponSolid[ClientDataHolderVR.getInstance().isMainHand ? 0 : 1]) {
            fade -= 0.25f;
        }
        if (itemStack != ItemStack.f_41583_) {
            if (player.m_21254_() && player.m_21211_() != itemStack) {
                fade -= 0.25f;
            }
            if (itemStack.m_41720_() == Items.f_42740_ && !player.m_21254_()) {
                fade -= 0.25f;
            }
        }
        if ((double)fade < 0.1) {
            fade = 0.1f;
        }
        if (fade > 1.0f) {
            fade = 1.0f;
        }
        return fade;
    }

    @Override
    public void renderDebug(PoseStack poseStack) {
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        VRData world = this.dh.vrPlayer.getVRDataWorld();
        Vec3 camWorld = world.getEye(this.dh.currentPass).getPosition();
        Vec3 cam = camWorld.m_82549_(this.dh.vrPlayer.vrdata_world_pre.origin).m_82546_(world.origin);
        for (int i = 0; i < trackers; ++i) {
            Vector3fc failColor;
            Vector3fc vector3fc = failColor = this.tipHistory[i].averageSpeed(0.33) > 3.0f * (this.mc.f_91074_.m_7500_() ? 1.5f : 1.0f) ? MathUtils.ORANGE : MathUtils.RED;
            if (this.miningPoints[i] != null || this.miningPoint[i] != null) {
                Object color;
                if (this.previousMiningPoints[i].isEmpty() || !((Vec3)this.previousMiningPoints[i].getLast().getLeft()).equals((Object)this.miningPoint[i])) {
                    if (this.miningPoints[i] != null && this.canAct[i]) {
                        for (int p = 1; p < this.miningPoints[i].size(); ++p) {
                            Object object = color = p <= this.lastMiningPointHit[i] ? MathUtils.GREEN : MathUtils.LIGHT_GRAY;
                            if (p < this.miningPoints[i].size() - 1) {
                                color = color.mul(0.5f, new Vector3f());
                            }
                            this.previousMiningPoints[i].addLast((Pair<Vec3, Vector3fc>)Pair.of((Object)this.miningPoints[i].get(p), (Object)color));
                        }
                    } else {
                        this.previousMiningPoints[i].addLast((Pair<Vec3, Vector3fc>)Pair.of((Object)this.miningPoint[i], (Object)(this.canAct[i] ? MathUtils.GREEN : failColor)));
                    }
                    while (this.previousMiningPoints[i].size() > 20) {
                        this.previousMiningPoints[i].removeFirst();
                    }
                }
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.miningPoint[i], cam), 0.025f, this.canAct[i] ? MathUtils.GREEN : failColor);
                if (!this.previousMiningPoints[i].isEmpty()) {
                    Pair prev = null;
                    color = this.previousMiningPoints[i].iterator();
                    while (color.hasNext()) {
                        Pair p = (Pair)color.next();
                        DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f((Vec3)p.getLeft(), cam), 0.0125f, (Vector3fc)p.getRight());
                        if (prev != null) {
                            DebugRenderHelper.renderLine(poseStack, (Vector3fc)p.getRight(), new Vector3fc[]{MathUtils.subtractToVector3f((Vec3)prev.getLeft(), cam), MathUtils.subtractToVector3f((Vec3)p.getLeft(), cam)});
                        }
                        prev = p;
                    }
                }
            }
            if (this.lastBlockHit[i] != null) {
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.lastBlockHit[i], camWorld), 0.025f, MathUtils.GREEN);
            }
            if (this.lastAttackAABB[i] != null) {
                DebugRenderHelper.renderAABB(poseStack, this.lastAttackAABB[i].m_82386_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_), this.lastHitEntities[i].isEmpty() ? failColor : MathUtils.GREEN);
            }
            if (this.weaponTip[i] != null) {
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.weaponTip[i], cam), 0.025f, this.lastHitEntities[i].isEmpty() ? failColor : MathUtils.GREEN);
            }
            for (Entity entity : this.lastHitEntities[i]) {
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(entity.m_20191_().m_82399_(), camWorld), (float)entity.m_20191_().m_82309_() / 2.0f, MathUtils.GREEN);
            }
        }
    }
}

