/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider.openvr_lwjgl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.openvr.HiddenAreaMesh;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VRSystem;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.MCOpenVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRUtil;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;

public class OpenVRStereoRenderer
extends VRRenderer {
    private final HiddenAreaMesh[] hiddenMeshes = new HiddenAreaMesh[2];
    private final MCOpenVR openvr;

    public OpenVRStereoRenderer(MCVR vr) {
        super(vr);
        this.openvr = (MCOpenVR)vr;
        this.hiddenMeshes[0] = HiddenAreaMesh.calloc();
        this.hiddenMeshes[1] = HiddenAreaMesh.calloc();
    }

    @Override
    public Tuple<Integer, Integer> getRenderTextureSizes() {
        if (this.resolution == null) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer renderSizeX = stack.callocInt(1);
                IntBuffer renderSizeY = stack.callocInt(1);
                VRSystem.VRSystem_GetRecommendedRenderTargetSize(renderSizeX, renderSizeY);
                this.resolution = new Tuple((Object)renderSizeX.get(0), (Object)renderSizeY.get(0));
                VRSettings.LOGGER.info("Vivecraft: OpenVR Render Res {}x{}", this.resolution.m_14418_(), this.resolution.m_14419_());
                this.ss = this.openvr.getSuperSampling();
                VRSettings.LOGGER.info("Vivecraft: OpenVR Supersampling: {}", (Object)Float.valueOf(this.ss));
            }
            for (int eye = 0; eye < 2; ++eye) {
                VRSystem.VRSystem_GetHiddenAreaMesh(eye, 0, this.hiddenMeshes[eye]);
                int count = this.hiddenMeshes[eye].unTriangleCount();
                if (count <= 0) {
                    VRSettings.LOGGER.info("Vivecraft: No stencil mesh found for eye '{}'", (Object)eye);
                    continue;
                }
                this.hiddenMeshVertices[eye] = new float[count * 3 * 2];
                MemoryUtil.memFloatBuffer((long)MemoryUtil.memAddress((CustomBuffer)this.hiddenMeshes[eye].pVertexData()), (int)this.hiddenMeshVertices[eye].length).get(this.hiddenMeshVertices[eye]);
                for (int vertex = 0; vertex < this.hiddenMeshVertices[eye].length; vertex += 2) {
                    float[] fArray = this.hiddenMeshVertices[eye];
                    int n = vertex;
                    fArray[n] = fArray[n] * (float)((Integer)this.resolution.m_14418_()).intValue();
                    float[] fArray2 = this.hiddenMeshVertices[eye];
                    int n2 = vertex + 1;
                    fArray2[n2] = fArray2[n2] * (float)((Integer)this.resolution.m_14419_()).intValue();
                }
                VRSettings.LOGGER.info("Vivecraft: Stencil mesh loaded for eye '{}'", (Object)eye);
            }
        }
        return this.resolution;
    }

    @Override
    protected Matrix4f getProjectionMatrix(int eyeType, float nearClip, float farClip) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (eyeType == 0) {
                Matrix4f matrix4f = OpenVRUtil.Matrix4fFromOpenVR(VRSystem.VRSystem_GetProjectionMatrix(0, nearClip, farClip, HmdMatrix44.calloc(stack)));
                return matrix4f;
            }
            Matrix4f matrix4f = OpenVRUtil.Matrix4fFromOpenVR(VRSystem.VRSystem_GetProjectionMatrix(1, nearClip, farClip, HmdMatrix44.calloc(stack)));
            return matrix4f;
        }
    }

    @Override
    public void createRenderTexture(int width, int height) {
        int boundTextureId = GlStateManager._getInteger((int)32873);
        this.LeftEyeTextureId = GlStateManager._genTexture();
        RenderSystem.bindTexture((int)this.LeftEyeTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5124, null);
        this.openvr.texType0.handle(this.LeftEyeTextureId);
        this.openvr.texType0.eColorSpace(1);
        this.openvr.texType0.eType(1);
        this.RightEyeTextureId = GlStateManager._genTexture();
        RenderSystem.bindTexture((int)this.RightEyeTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5124, null);
        this.openvr.texType1.handle(this.RightEyeTextureId);
        this.openvr.texType1.eColorSpace(1);
        this.openvr.texType1.eType(1);
        RenderSystem.bindTexture((int)boundTextureId);
        this.lastError = RenderHelper.checkGLError("create VR textures");
    }

    @Override
    public void endFrame() throws RenderConfigException {
        int leftError = VRCompositor.VRCompositor_Submit(0, this.openvr.texType0, null, 0);
        int rightError = VRCompositor.VRCompositor_Submit(1, this.openvr.texType1, null, 0);
        VRCompositor.VRCompositor_PostPresentHandoff();
        if (leftError + rightError > 0) {
            throw new RenderConfigException((Component)Component.m_237113_((String)"Compositor Error"), (Component)Component.m_237113_((String)("Texture submission error: Left/Right " + OpenVRStereoRenderer.getCompositorError(leftError) + "/" + OpenVRStereoRenderer.getCompositorError(rightError))));
        }
        GL11C.glFlush();
    }

    public static String getCompositorError(int code) {
        return switch (code) {
            case 0 -> "None";
            case 1 -> "RequestFailed";
            case 100 -> "IncompatibleVersion";
            case 101 -> "DoesNotHaveFocus";
            case 102 -> "InvalidTexture";
            case 103 -> "IsNotSceneApplication";
            case 104 -> "TextureIsOnWrongDevice";
            case 105 -> "TextureUsesUnsupportedFormat:";
            case 106 -> "SharedTexturesNotSupported";
            case 107 -> "IndexOutOfRange";
            case 108 -> "AlreadySubmitted";
            case 109 -> "InvalidBounds";
            case 110 -> "AlreadySet";
            default -> "Unknown";
        };
    }

    @Override
    public boolean providesStencilMask() {
        return true;
    }

    @Override
    public String getName() {
        return "OpenVR";
    }

    @Override
    protected void destroyBuffers() {
        super.destroyBuffers();
        if (this.LeftEyeTextureId > -1) {
            TextureUtil.releaseTextureId((int)this.LeftEyeTextureId);
            this.LeftEyeTextureId = -1;
        }
        if (this.RightEyeTextureId > -1) {
            TextureUtil.releaseTextureId((int)this.RightEyeTextureId);
            this.RightEyeTextureId = -1;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.hiddenMeshes[0].free();
        this.hiddenMeshes[1].free();
    }
}

