/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.HeldInteractModule;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.interact_modules.DebugRenderModule;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class ThirdPersonCameraModule
implements DebugRenderModule,
HeldInteractModule {
    private static final class_2960 ID = new class_2960("vivecraft", "third_person_camera");
    private static final float INTERACT_DIST = 0.15f;
    private final ClientDataHolderVR dh;
    private class_243 camPos;

    public ThirdPersonCameraModule(ClientDataHolderVR dh) {
        this.dh = dh;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 750;
    }

    @Override
    public boolean isActive(@Nullable class_746 player, class_1268 hand, class_243 handPosition) {
        if (this.dh.vrSettings.mixedRealityRenderCameraModel && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON)) {
            VRData.VRDevicePose camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.THIRD);
            Vector3f offset = camData.getCustomVector(MathUtils.BACK).mul(0.15f * this.dh.vrPlayer.vrdata_world_pre.worldScale).add((Vector3fc)camData.getCustomVector(MathUtils.DOWN).mul(0.05f * this.dh.vrPlayer.vrdata_world_pre.worldScale));
            this.camPos = camData.getPosition().method_1023((double)offset.x, (double)offset.y, (double)offset.z);
            return handPosition.method_1022(this.camPos) < (double)(0.15f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
        }
        return false;
    }

    @Override
    public boolean onPress(@Nullable class_746 player, class_1268 hand) {
        VRHotkeys.startMovingThirdPersonCam(hand.ordinal(), VRHotkeys.Triggerer.INTERACTION);
        return true;
    }

    @Override
    public void onRelease(@Nullable class_746 player, class_1268 hand) {
        if (VRHotkeys.isMovingThirdPersonCam() && VRHotkeys.getMovingThirdPersonCamTriggerer() == VRHotkeys.Triggerer.INTERACTION && VRHotkeys.getMovingThirdPersonCamController() == hand.ordinal()) {
            VRHotkeys.stopMovingThirdPersonCam();
        }
    }

    public boolean isActive() {
        return this.dh.interactTracker.isActiveModule(this);
    }

    @Override
    public void renderDebug(boolean isActive) {
        if (this.dh.vrSettings.mixedRealityRenderCameraModel && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) && this.camPos != null) {
            VRData world = this.dh.vrPlayer.getVRDataWorld();
            class_243 cam = this.camPos.method_1020(this.dh.vrPlayer.vrdata_world_pre.origin).method_1019(world.origin);
            DebugRenderHelper.renderSphere((Vector3fc)MathUtils.subtractToVector3f(cam, world.getEye(this.dh.currentPass).getPosition()), 0.15f * world.worldScale, isActive ? MathUtils.GREEN : MathUtils.RED);
        }
    }
}

