/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import com.bhaptics.haptic.models.PositionType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.bodylink.Haptics;
import org.vivecraft.client_vr.bodylink.RiggedBody;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.packet.c2s.DamageDirectionPayloadC2S;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;

public class HapticTracker
implements Tracker {
    private static final int HUNGER_THRESHOLD = 15;
    private static final double MAX_EXPLOSION_DIST = 5.0;
    private final Random random = new Random();
    private final ArrayList<HapticsModule> modules = new ArrayList();
    private float lastHealth;
    private Vector3fc lastHitDirection = null;
    private float lastVanillaHurtYaw = 0.0f;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public HapticTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
        this.modules.add(new RainModule());
    }

    @Override
    public boolean isActive(class_746 player) {
        return player != null && Haptics.isConnected();
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        RiggedBody.getInstance().updatePose(this.dh.vrPlayer.getVRDataWorld());
        if (NetworkVersion.DAMAGE_DIRECTION.accepts(ClientNetworking.USED_NETWORK_VERSION) && !ClientNetworking.REQUESTED_DAMAGE_DIRECTION) {
            ClientNetworking.sendServerPacket(new DamageDirectionPayloadC2S());
            ClientNetworking.REQUESTED_DAMAGE_DIRECTION = true;
        }
        float thresholdLowHealth = 5.0f;
        float thresholdCriticalHealth = 2.0f;
        Haptics.setLoopState(Haptics.Animations.FIRE, player.method_5809());
        Haptics.setLoopState(Haptics.Animations.POTION_POSITIVE, this.hasPotionPositive(player));
        Haptics.setLoopState(Haptics.Animations.POTION_NEGATIVE, this.hasPotionNegative(player));
        Haptics.setLoopState(Haptics.Animations.LOW_HEALTH, player.method_6032() < thresholdLowHealth && !(player.method_6032() < thresholdCriticalHealth));
        Haptics.setLoopState(Haptics.Animations.CRITICAL_HEALTH, player.method_6032() < thresholdCriticalHealth);
        Haptics.setLoopState(Haptics.Animations.RAIN, this.isInRain(player));
        for (HapticsModule module : this.modules) {
            if (!module.enabled) continue;
            module.tick(player);
        }
        if (player.method_6032() != this.lastHealth) {
            float damage = this.lastHealth - player.method_6032();
            if (damage > 0.0f) {
                this.handleHit(player.method_6081(), damage);
            }
            this.lastHealth = player.method_6032();
        }
        this.doHunger(player);
        Haptics.tick();
    }

    private void doHunger(class_746 player) {
        float foodPerc;
        int food = player.method_7344().method_7586();
        if (food < 15 && this.random.nextInt(60 + (int)((foodPerc = (float)food / 20.0f) * 30.0f * 20.0f)) == 0) {
            Haptics.getAnimation(Haptics.Animations.HUNGER).playSingle(false, null);
        }
    }

    private boolean hasPotionPositive(class_746 player) {
        for (class_1293 effect : player.method_6026()) {
            if (!((class_1291)effect.method_5579().comp_349()).method_5573() || effect.method_5591()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPotionNegative(class_746 player) {
        return player.method_6026().stream().anyMatch(effect -> ((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272 && !effect.method_5591());
    }

    private boolean isInRain(class_746 player) {
        class_2338 blockpos = player.method_24515();
        return player.field_17892.method_8520(blockpos) || player.field_17892.method_8520(new class_2338(blockpos.method_10263(), (int)player.method_5829().field_1325, blockpos.method_10260()));
    }

    private void handleHit(class_1282 damageSrc, float damageAmount) {
        Vector3fc dmgVec = null;
        if (damageSrc != null) {
            dmgVec = Utils.getDirFromDamageSource(damageSrc, (class_1297)this.mc.field_1724);
        }
        if (dmgVec == null || MathUtils.isZero(dmgVec)) {
            if (this.lastHitDirection != null) {
                dmgVec = this.lastHitDirection;
            } else if (this.lastVanillaHurtYaw != this.mc.field_1724.method_48157()) {
                this.lastVanillaHurtYaw = this.mc.field_1724.method_48157();
                dmgVec = new Vector3f(1.0f, 0.0f, 0.0f).rotateY((-this.lastVanillaHurtYaw - this.mc.field_1724.method_36454()) * ((float)Math.PI / 180));
            }
        }
        this.lastHitDirection = null;
        if (dmgVec != null && !MathUtils.isZero(dmgVec)) {
            if (dmgVec.y() == 1.0f) {
                Haptics.getAnimation(Haptics.Animations.TOP_HIT).playSingle(true, null);
            } else if (dmgVec.y() == -1.0f) {
                Haptics.getAnimation(Haptics.Animations.BOTTOM_HIT).playSingle(true, null);
            } else {
                dmgVec = dmgVec.rotateY(this.dh.vrPlayer.getVRDataWorld().getBodyYawRad() + (float)Math.PI, new Vector3f());
                Haptics.getAnimation(Haptics.Animations.GENERIC_HIT).playSingle(true, dmgVec);
            }
        } else {
            Haptics.getAnimation(Haptics.Animations.ALL_AROUND_HIT).playSingle(true, null);
        }
    }

    public void handleExplode(class_243 explosionPos) {
        double explosionDist;
        if (this.isActive(this.mc.field_1724) && (explosionDist = explosionPos.method_1020(this.mc.field_1724.method_19538()).method_1033()) < 5.0) {
            double distFactor = 1.0 - explosionDist / 5.0;
            Haptics.getAnimation(Haptics.Animations.EXPLOSION).playSingle(true, null, distFactor);
        }
    }

    public void handleEat(class_1799 itemStack) {
        if (this.isActive(this.mc.field_1724) && itemStack.method_57824(class_9334.field_50075) != null) {
            if (((class_4174)itemStack.method_57824(class_9334.field_50075)).comp_2495().isEmpty()) {
                Haptics.getAnimation(Haptics.Animations.CONSUME).playSingle(true, null);
            } else {
                Haptics.getAnimation(Haptics.Animations.CONSUME_EFFECT).playSingle(true, null);
            }
        }
    }

    public void setLastHitDirection(Vector3fc lastHitDirection) {
        this.lastHitDirection = lastHitDirection;
    }

    private static class RainModule
    extends HapticsModule {
        private static final double MIN_ANGLE = 0.0;
        private static final double DROP_CHANCE_THRESHOLD = 0.2;
        Random random = new Random();

        public RainModule() {
            this.enabled = false;
        }

        @Override
        void tick(class_746 player) {
            if (!player.field_17892.method_8419()) {
                return;
            }
            boolean isSnow = ((class_1959)player.field_17892.method_23753(player.method_24515()).comp_349()).method_33599(player.method_24515());
            class_243 rainFall = new class_243(0.0, -9.0, 0.0);
            Vector3f rainDir = MathUtils.subtractToVector3f(rainFall, player.method_18798()).normalize().mul(-1.0f);
            ArrayList<RiggedBody.HapticPoint> points = RiggedBody.getInstance().getHapticPoints(PositionType.All);
            for (RiggedBody.HapticPoint p : points) {
                double snowFactor;
                if (!player.field_17892.method_8520(player.method_24515())) continue;
                Vector3f normal = p.getNormal(true);
                double exposure = normal.dot((Vector3fc)rainDir);
                if (exposure < 0.0) {
                    exposure = 0.0;
                }
                double d = snowFactor = isSnow ? 2.0 : 1.0;
                if (!(Math.abs(this.random.nextGaussian()) * exposure > 0.2 * snowFactor)) continue;
                int intensity = 10;
                int duration = 10;
                p.motor.dot(intensity, duration);
            }
        }
    }

    private static abstract class HapticsModule {
        boolean enabled = false;

        private HapticsModule() {
        }

        abstract void tick(class_746 var1);
    }
}

