/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_238;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4597;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.OptionEnum;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_vr.utils.RGBAColor;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class PhysicalKeyboard {
    private static final int ROWS = 4;
    private static final int COLUMNS = 13;
    private static final float SPACING = 0.0064f;
    private static final float KEY_WIDTH = 0.04f;
    private static final float KEY_HEIGHT = 0.04f;
    private static final float KEY_WIDTH_SPECIAL = 0.086399995f;
    private final class_310 mc = class_310.method_1551();
    private final ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    private boolean reinit;
    private boolean shift;
    private boolean shiftSticky;
    private final List<KeyButton> keys;
    private int rows;
    private int columns;
    private float spacing;
    private float keyWidth;
    private float keyHeight;
    private float keyWidthSpecial;
    private float scale = 1.0f;
    private final KeyButton[] pressedKey = new KeyButton[2];
    private final long[] pressTime = new long[2];
    private final long[] pressRepeatTime = new long[2];
    private long shiftPressTime;
    private boolean lastPressedShift;
    private Supplier<String> easterEggText = () -> {
        int[] data = new int[]{188, 161, 183, 175, 162, 238, 188, 175, 167, 160, 172, 161, 185};
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = (byte)(data[i] ^ 0xCE);
        }
        String str = new String(bytes, StandardCharsets.UTF_8);
        this.easterEggText = () -> str;
        return str;
    };
    private int easterEggIndex = 0;
    private boolean easterEggActive;
    private final Map<Integer, RGBAColor> customTheme = new HashMap<Integer, RGBAColor>();

    public PhysicalKeyboard() {
        this.keys = new ArrayList<KeyButton>();
    }

    public void init() {
        float calcRows;
        this.unpressAllKeys();
        this.keys.clear();
        this.rows = 4;
        this.columns = 13;
        this.spacing = 0.0064f * this.scale;
        this.keyWidth = 0.04f * this.scale;
        this.keyHeight = 0.04f * this.scale;
        this.keyWidthSpecial = 0.086399995f * this.scale;
        String chars = this.dh.vrSettings.keyboardKeys;
        if (this.shift) {
            chars = this.dh.vrSettings.keyboardKeysShift;
        }
        if (Math.abs((float)this.rows - (calcRows = (float)chars.length() / (float)this.columns)) > 0.01f) {
            this.rows = class_3532.method_15386((float)calcRows);
        }
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                int index = row * this.columns + column;
                char ch = ' ';
                if (index < chars.length()) {
                    ch = chars.charAt(index);
                }
                final char buttonChar = ch;
                final int code = index < this.dh.vrSettings.keyboardCodes.length ? this.dh.vrSettings.keyboardCodes[index] : -1;
                this.addKey(new KeyButton(index, String.valueOf(ch), this.keyWidthSpecial + this.spacing + (float)column * (this.keyWidth + this.spacing), (float)row * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight){

                    @Override
                    public void onPressed() {
                        InputSimulator.pressKeyForBind(code);
                        InputSimulator.typeChar(buttonChar);
                        if (!PhysicalKeyboard.this.shiftSticky) {
                            PhysicalKeyboard.this.setShift(false, false);
                        }
                        if (buttonChar == '/' && PhysicalKeyboard.this.mc.field_1755 == null) {
                            InputSimulator.pressKey(47);
                            InputSimulator.releaseKey(47);
                        }
                    }

                    @Override
                    public void onReleased() {
                        InputSimulator.releaseKeyForBind(code);
                    }
                });
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.addKey(new KeyButton(1000 + i, "Shift", i == 1 ? this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing) : 0.0f, 3.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

                @Override
                public void onPressed() {
                    if (PhysicalKeyboard.this.shift && !PhysicalKeyboard.this.shiftSticky && ClientUtils.milliTime() - PhysicalKeyboard.this.shiftPressTime < 400L) {
                        PhysicalKeyboard.this.setShift(true, true);
                    } else {
                        PhysicalKeyboard.this.setShift(!PhysicalKeyboard.this.shift, false);
                    }
                    PhysicalKeyboard.this.shiftPressTime = ClientUtils.milliTime();
                }

                @Override
                public RGBAColor getRenderColor() {
                    if (PhysicalKeyboard.this.shift) {
                        RGBAColor color = new RGBAColor(this.pressed ? 1.0f : 0.5f, this.pressed ? 1.0f : 0.5f, 0.0f, 0.5f);
                        if (!PhysicalKeyboard.this.shiftSticky) {
                            color.r = 0.0f;
                        }
                        return color;
                    }
                    return super.getRenderColor();
                }
            });
        }
        this.addKey(new KeyButton(this, 1002, " ", this.keyWidthSpecial + this.spacing + (float)(this.columns - 5) / 2.0f * (this.keyWidth + this.spacing), (float)this.rows * (this.keyHeight + this.spacing), 5.0f * (this.keyWidth + this.spacing) - this.spacing, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKeyForBind(32);
                InputSimulator.typeChar(' ');
            }

            @Override
            public void onReleased() {
                InputSimulator.releaseKeyForBind(32);
            }
        });
        this.addKey(new KeyPressButton(this, 1003, "Tab", 0.0f, this.keyHeight + this.spacing, this.keyWidthSpecial, this.keyHeight, 258));
        this.addKey(new KeyPressButton(this, 1004, "Esc", 0.0f, 0.0f, this.keyWidthSpecial, this.keyHeight, 256));
        this.addKey(new KeyPressButton(this, 1005, "Bksp", this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing), 0.0f, this.keyWidthSpecial, this.keyHeight, 259));
        this.addKey(new KeyPressButton(this, 1006, "Enter", this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing), 2.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight, 257));
        this.addKey(new KeyPressButton(this, 1007, "\u2191", this.keyWidthSpecial + this.spacing + (float)(this.columns + 1) * (this.keyWidth + this.spacing), 4.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 265));
        this.addKey(new KeyPressButton(this, 1008, "\u2193", this.keyWidthSpecial + this.spacing + (float)(this.columns + 1) * (this.keyWidth + this.spacing), 5.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 264));
        this.addKey(new KeyPressButton(this, 1009, "\u2190", this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing), 5.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 263));
        this.addKey(new KeyPressButton(this, 1010, "\u2192", this.keyWidthSpecial + this.spacing + (float)(this.columns + 2) * (this.keyWidth + this.spacing), 5.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 262));
        this.addKey(new KeyButton(this, 1011, "Cut", this.keyWidthSpecial + this.spacing, -1.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKey(341);
                InputSimulator.pressKey(88);
                InputSimulator.releaseKey(88);
                InputSimulator.releaseKey(341);
            }
        });
        this.addKey(new KeyButton(this, 1012, "Copy", 2.0f * (this.keyWidthSpecial + this.spacing), -1.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKey(341);
                InputSimulator.pressKey(67);
                InputSimulator.releaseKey(67);
                InputSimulator.releaseKey(341);
            }
        });
        this.addKey(new KeyButton(this, 1013, "Paste", 3.0f * (this.keyWidthSpecial + this.spacing), -1.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKey(341);
                InputSimulator.pressKey(86);
                InputSimulator.releaseKey(86);
                InputSimulator.releaseKey(341);
            }
        });
        block17: for (int c = 0; c < 2; ++c) {
            if (this.pressedKey[c] == null) continue;
            for (KeyButton key : this.keys) {
                if (key.id != this.pressedKey[c].id) continue;
                this.pressedKey[c] = key;
                key.pressed = true;
                continue block17;
            }
        }
        if (this.dh.vrSettings.physicalKeyboardTheme == KeyboardTheme.CUSTOM) {
            this.customTheme.clear();
            File themeFile = new File(this.mc.field_1697, "keyboardtheme.txt");
            if (!themeFile.exists()) {
                try (PrintWriter pw = new PrintWriter(new FileWriter(themeFile, StandardCharsets.UTF_8));){
                    char[] normalChars = this.dh.vrSettings.keyboardKeys.toCharArray();
                    for (int i = 0; i < normalChars.length; ++i) {
                        pw.println("# " + normalChars[i] + " (Normal)");
                        pw.println(i + "=255,255,255");
                    }
                    char[] shiftChars = this.dh.vrSettings.keyboardKeysShift.toCharArray();
                    for (int i = 0; i < shiftChars.length; ++i) {
                        pw.println("# " + shiftChars[i] + " (Shifted)");
                        pw.println(i + 500 + "=255,255,255");
                    }
                    this.keys.forEach(button -> {
                        if (button.id >= 1000) {
                            pw.println("# " + button.label);
                            pw.println(button.id + "=255,255,255");
                        }
                    });
                }
                catch (IOException ex) {
                    VRSettings.LOGGER.error("Vivecraft: error creating keyboard template: ", (Throwable)ex);
                }
            } else {
                try (Stream<String> lines = Files.lines(Paths.get(themeFile.toURI()), StandardCharsets.UTF_8);){
                    lines.forEach(line -> {
                        if (line.isEmpty() || line.charAt(0) == '#') {
                            return;
                        }
                        try {
                            String[] split = line.split("=", 2);
                            int id = Integer.parseInt(split[0]);
                            String[] colorSplit = split[1].split(",");
                            RGBAColor color = new RGBAColor(Integer.parseInt(colorSplit[0]), Integer.parseInt(colorSplit[1]), Integer.parseInt(colorSplit[2]), 255);
                            this.customTheme.put(id, color);
                        }
                        catch (Exception ex) {
                            VRSettings.LOGGER.error("Vivecraft: error reading keyboard theme line: {}:", line, (Object)ex);
                        }
                    });
                }
                catch (IOException ex) {
                    VRSettings.LOGGER.error("Vivecraft: error reading keyboard theme:", (Throwable)ex);
                }
            }
        }
        this.reinit = false;
    }

    public void process() {
        if (this.reinit) {
            this.init();
        }
        for (int c = 0; c < 2; ++c) {
            ControllerType controller = ControllerType.values()[c];
            KeyButton key = this.findTouchedKey(controller);
            long milliTime = ClientUtils.milliTime();
            if (key != null) {
                if (key != this.pressedKey[c] && milliTime - this.pressTime[c] >= 150L) {
                    if (this.pressedKey[c] != null) {
                        this.pressedKey[c].unpress();
                        this.pressedKey[c] = null;
                    }
                    key.press(controller, false);
                    this.pressedKey[c] = key;
                    this.pressTime[c] = milliTime;
                    this.pressRepeatTime[c] = milliTime;
                    continue;
                }
                if (key != this.pressedKey[c] || milliTime - this.pressTime[c] < 500L || milliTime - this.pressRepeatTime[c] < 100L) continue;
                key.press(controller, true);
                this.pressRepeatTime[c] = milliTime;
                continue;
            }
            if (this.pressedKey[c] == null) continue;
            this.pressedKey[c].unpress();
            this.pressedKey[c] = null;
            this.pressTime[c] = milliTime;
        }
    }

    public void processBindings() {
        if (GuiHandler.KEY_KEYBOARD_SHIFT.method_1436()) {
            this.setShift(true, true);
            this.lastPressedShift = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_SHIFT.method_1434() && this.lastPressedShift) {
            this.setShift(false, false);
            this.lastPressedShift = false;
        }
    }

    private Vector3f getCenterPos() {
        return new Vector3f(((this.keyWidth + this.spacing) * ((float)this.columns + (float)this.columns % 2.0f / 2.0f) + (this.keyWidthSpecial + this.spacing) * 2.0f) / 2.0f, (this.keyHeight + this.spacing) * (float)(this.rows + 1), 0.0f);
    }

    private KeyButton findTouchedKey(ControllerType controller) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate((Vector3fc)this.getCenterPos());
        matrix.mul((Matrix4fc)new Matrix4f((Matrix4fc)KeyboardHandler.ROTATION_ROOM).invert());
        matrix.translate(-KeyboardHandler.POS_ROOM.x, -KeyboardHandler.POS_ROOM.y, -KeyboardHandler.POS_ROOM.z);
        Vector3f pos = matrix.transformPosition(this.dh.vrPlayer.vrdata_room_pre.getController(controller.ordinal()).getPositionF());
        for (KeyButton key : this.keys) {
            if (!key.getCollisionBoundingBox().method_1008((double)pos.x, (double)pos.y, (double)pos.z)) continue;
            return key;
        }
        return null;
    }

    private void updateEasterEgg(String label) {
        String text = this.easterEggText.get();
        if (this.easterEggIndex < text.length()) {
            this.easterEggIndex = label.toLowerCase().equals(String.valueOf(text.charAt(this.easterEggIndex))) ? ++this.easterEggIndex : 0;
        } else if (label.equals("Enter")) {
            this.easterEggActive = !this.easterEggActive;
        } else {
            this.easterEggIndex = 0;
        }
    }

    private void drawBox(class_287 buf, class_238 box, RGBAColor color, Matrix4f matrix) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        buf.method_22918(matrix, minX, minY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, maxY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, maxY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, minY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, minY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, minY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, minY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, minY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, minY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, minY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, maxY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, maxY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, maxY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, maxY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, minY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, minY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, maxY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, maxY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, maxY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, minX, maxY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, maxY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, minY, maxZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, minY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buf.method_22918(matrix, maxX, maxY, minZ).method_22913(0.0f, 0.0f).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    public void render(Matrix4fStack poseStack) {
        if (this.keys.isEmpty()) {
            return;
        }
        poseStack.pushMatrix();
        Vector3f center = this.getCenterPos();
        poseStack.translate(-center.x, -center.y, -center.z);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        if (this.easterEggActive) {
            for (KeyButton key : this.keys) {
                RGBAColor color = RGBAColor.fromHSB(((float)this.dh.tickCounter + ClientUtils.getCurrentPartialTick()) / 100.0f + (float)(key.boundingBox.field_1323 + (key.boundingBox.field_1320 - key.boundingBox.field_1323) / 2.0) / 2.0f, 1.0f, 1.0f);
                key.color.r = color.r;
                key.color.g = color.g;
                key.color.b = color.b;
            }
        } else {
            this.keys.forEach(button -> {
                if (this.dh.vrSettings.physicalKeyboardTheme == KeyboardTheme.CUSTOM) {
                    RGBAColor color = this.customTheme.get(this.shift && button.id < 1000 ? button.id + 500 : button.id);
                    if (color != null) {
                        button.color.r = color.r;
                        button.color.g = color.g;
                        button.color.b = color.b;
                    }
                } else {
                    this.dh.vrSettings.physicalKeyboardTheme.assignColor((KeyButton)button);
                }
            });
        }
        RenderSystem.depthFunc((int)519);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        class_327 font = this.mc.field_1772;
        ArrayList<class_3545> labels = new ArrayList<class_3545>();
        float textScale = 0.002f * this.scale;
        RenderSystem.setShader(class_757::method_34543);
        ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
        class_287 buf = class_289.method_1348().method_1349();
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        for (KeyButton key : this.keys) {
            class_238 box = key.getRenderBoundingBox();
            RGBAColor color = key.getRenderColor();
            this.drawBox(buf, box, color, (Matrix4f)poseStack);
            float stringWidth = (float)font.method_1727(key.label) * textScale;
            Objects.requireNonNull(font);
            float stringHeight = 9.0f * textScale;
            float textX = (float)box.field_1323 + ((float)box.field_1320 - (float)box.field_1323) / 2.0f - stringWidth / 2.0f;
            float textY = (float)box.field_1322 + ((float)box.field_1325 - (float)box.field_1322) / 2.0f - stringHeight / 2.0f;
            float textZ = (float)box.field_1321 + ((float)box.field_1324 - (float)box.field_1321) / 2.0f;
            labels.add(new class_3545((Object)key.label, (Object)new Vector3f(textX, textY, textZ)));
        }
        class_286.method_43433((class_287.class_7433)buf.method_1326());
        RenderSystem.depthFunc((int)515);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)buf);
        for (class_3545 label : labels) {
            poseStack.pushMatrix();
            poseStack.translate(((Vector3f)label.method_15441()).x, ((Vector3f)label.method_15441()).y, ((Vector3f)label.method_15441()).z);
            poseStack.scale(textScale, textScale, 1.0f);
            font.method_27522((String)label.method_15442(), 0.0f, 0.0f, -1, false, (Matrix4f)poseStack, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0, font.method_1726());
            poseStack.popMatrix();
        }
        bufferSource.method_22993();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        poseStack.popMatrix();
    }

    public void show() {
        if (!this.shiftSticky) {
            this.shift = false;
        }
        this.scale = this.dh.vrSettings.physicalKeyboardScale;
        this.reinit = true;
    }

    public void unpressAllKeys() {
        for (KeyButton key : this.keys) {
            if (!key.pressed) continue;
            key.unpress();
        }
    }

    private KeyButton addKey(KeyButton key) {
        this.keys.add(key);
        return key;
    }

    public boolean isShift() {
        return this.shift;
    }

    public boolean isShiftSticky() {
        return this.shiftSticky;
    }

    public void setShift(boolean shift, boolean sticky) {
        if (shift != this.shift || sticky != this.shiftSticky) {
            this.shift = shift;
            this.shiftSticky = shift && sticky;
            this.reinit = true;
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.reinit = true;
    }

    private abstract class KeyButton {
        public final int id;
        public final String label;
        public final class_238 boundingBox;
        public RGBAColor color = new RGBAColor(1.0f, 1.0f, 1.0f, 0.5f);
        public boolean pressed;

        public KeyButton(int id, String label, float x, float y, float width, float height) {
            this.id = id;
            this.label = label;
            this.boundingBox = new class_238((double)x, (double)y, 0.0, (double)(x + width), (double)(y + height), 0.028 * (double)PhysicalKeyboard.this.scale);
        }

        public class_238 getRenderBoundingBox() {
            return this.pressed ? this.boundingBox.method_989(0.0, 0.0, 0.012 * (double)PhysicalKeyboard.this.scale) : this.boundingBox;
        }

        public class_238 getCollisionBoundingBox() {
            return this.pressed ? this.boundingBox.method_1012(0.0, 0.0, 0.08) : this.boundingBox;
        }

        public RGBAColor getRenderColor() {
            RGBAColor color = this.color.copy();
            if (!this.pressed) {
                color.r *= 0.5f;
                color.g *= 0.5f;
                color.b *= 0.5f;
            }
            return color;
        }

        public final void press(ControllerType controller, boolean isRepeat) {
            if (!isRepeat) {
                PhysicalKeyboard.this.mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
            MCVR.get().triggerHapticPulse(controller, isRepeat ? 300 : 600);
            this.pressed = true;
            this.onPressed();
            PhysicalKeyboard.this.updateEasterEgg(this.label);
        }

        public final void unpress() {
            this.pressed = false;
            this.onReleased();
        }

        public abstract void onPressed();

        public void onReleased() {
        }
    }

    private class KeyPressButton
    extends KeyButton {
        private final int keyCode;

        public KeyPressButton(PhysicalKeyboard physicalKeyboard, int id, String label, float x, float y, float width, float height, int keyCode) {
            super(id, label, x, y, width, height);
            this.keyCode = keyCode;
        }

        @Override
        public void onPressed() {
            InputSimulator.pressKey(this.keyCode);
        }

        @Override
        public void onReleased() {
            InputSimulator.releaseKey(this.keyCode);
        }
    }

    public static enum KeyboardTheme implements OptionEnum<KeyboardTheme>
    {
        DEFAULT{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 1.0f;
                button.color.g = 1.0f;
                button.color.b = 1.0f;
            }
        }
        ,
        RED{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 1.0f;
                button.color.g = 0.0f;
                button.color.b = 0.0f;
            }
        }
        ,
        GREEN{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 0.0f;
                button.color.g = 1.0f;
                button.color.b = 0.0f;
            }
        }
        ,
        BLUE{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 0.0f;
                button.color.g = 0.0f;
                button.color.b = 1.0f;
            }
        }
        ,
        BLACK{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 0.0f;
                button.color.g = 0.0f;
                button.color.b = 0.0f;
            }
        }
        ,
        GRASS{

            @Override
            public void assignColor(KeyButton button) {
                if (button.boundingBox.field_1325 < 0.07) {
                    button.color.r = 0.321f;
                    button.color.g = 0.584f;
                    button.color.b = 0.184f;
                } else {
                    button.color.r = 0.607f;
                    button.color.g = 0.462f;
                    button.color.b = 0.325f;
                }
            }
        }
        ,
        BEES{

            @Override
            public void assignColor(KeyButton button) {
                float val;
                button.color.r = val = button.boundingBox.field_1320 % 0.2 < 0.1 ? 1.0f : 0.0f;
                button.color.g = val;
                button.color.b = 0.0f;
            }
        }
        ,
        AESTHETIC{

            @Override
            public void assignColor(KeyButton button) {
                if (button.id >= 1000) {
                    button.color.r = 0.0f;
                    button.color.g = 1.0f;
                    button.color.b = 1.0f;
                } else {
                    button.color.r = 1.0f;
                    button.color.g = 0.0f;
                    button.color.b = 1.0f;
                }
            }
        }
        ,
        DOSE{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = button.id % 2 == 0 ? 0.5f : 0.0f;
                button.color.g = button.id % 2 == 0 ? 0.0f : 1.0f;
                button.color.b = button.id % 2 == 0 ? 1.0f : 0.0f;
            }
        }
        ,
        CUSTOM{

            @Override
            public void assignColor(KeyButton button) {
            }
        };


        public abstract void assignColor(KeyButton var1);
    }
}

