/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.c2s;

import com.google.common.base.Charsets;
import net.minecraft.class_2540;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;

public record VersionPayloadC2S(String version, boolean vr, int maxVersion, int minVersion, boolean legacy) implements VivecraftPayloadC2S
{
    public VersionPayloadC2S(String version, boolean vr, int maxVersion, int minVersion) {
        this(version, vr, maxVersion, minVersion, false);
    }

    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.VERSION;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        buffer.writeBytes(String.format("%s %s\n%d\n%d", this.version, this.vr ? "VR" : "NONVR", this.maxVersion, this.minVersion).getBytes(Charsets.UTF_8));
    }

    public static VersionPayloadC2S read(class_2540 buffer) {
        boolean vr;
        byte[] stringBytes = new byte[buffer.readableBytes()];
        buffer.readBytes(stringBytes);
        String[] parts = new String(stringBytes).split("\\n");
        boolean bl = vr = !parts[0].contains("NONVR");
        if (parts.length >= 3) {
            return new VersionPayloadC2S(parts[0], vr, Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), false);
        }
        return new VersionPayloadC2S(parts[0], vr, NetworkVersion.LEGACY.protocolVersion(), NetworkVersion.LEGACY.protocolVersion(), true);
    }
}

