/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.gui.framework.widgets.MultilineComponent;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.GuiHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.common.utils.MathUtils;

public class FBTCalibrationScreen
extends Screen {
    private static final Vec3i COLOR_INACTIVE = new Vec3i(128, 64, 64);
    private static final Vec3i COLOR_ACTIVE = new Vec3i(64, 128, 64);
    private static final byte ALPHA = -56;
    private final Screen parent;
    private final boolean wasFbtCalibrated;
    private final boolean wasFbtExtendedCalibrated;
    private final Vector3fc[] oldFbtOffsets;
    private final Quaternionfc[] oldFbtRotations;
    private boolean calibrated = false;
    private boolean usingUnlabeledTrackers = false;
    private boolean rightHandAtPosition = false;
    private boolean leftHandAtPosition = false;
    private org.joml.Vector3f rightHand = new org.joml.Vector3f();
    private org.joml.Vector3f leftHand = new org.joml.Vector3f();
    private float yaw;
    private MultilineComponent calibrationText;
    private MultilineComponent unlabeledTrackersWarningText;
    private MultilineComponent unlabeledTrackersConfirmationText;
    private Button resetButton;
    private Button cancelButton;

    public FBTCalibrationScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"vivecraft.options.screen.fbtcalibration"));
        this.parent = parent;
        this.wasFbtCalibrated = ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated;
        this.wasFbtExtendedCalibrated = ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated;
        this.oldFbtOffsets = new Vector3fc[ClientDataHolderVR.getInstance().vrSettings.fbtOffsets.length];
        this.oldFbtRotations = new Quaternionfc[ClientDataHolderVR.getInstance().vrSettings.fbtRotations.length];
        for (int i = 0; i < this.oldFbtOffsets.length; ++i) {
            this.oldFbtOffsets[i] = new org.joml.Vector3f((Vector3fc)ClientDataHolderVR.getInstance().vrSettings.fbtOffsets[i]);
            this.oldFbtRotations[i] = new Quaternionf((Quaternionfc)ClientDataHolderVR.getInstance().vrSettings.fbtRotations[i]);
        }
        ClientDataHolderVR.getInstance().showedFbtCalibrationNotification = true;
        ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = false;
        if (VRState.VR_INITIALIZED) {
            boolean fbt = ClientDataHolderVR.getInstance().vr.hasFBT();
            boolean extended = ClientDataHolderVR.getInstance().vr.hasExtendedFBT();
            int trackers = ClientDataHolderVR.getInstance().vr.getTrackers().size();
            this.usingUnlabeledTrackers = ClientDataHolderVR.getInstance().vrSettings.unlabeledTrackersUsed || !extended && trackers >= 7 || !fbt && trackers >= 3;
        }
    }

    private void reset() {
        this.calibrated = false;
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vr.resetFBT();
        }
        ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.unlabeledTrackersUsed = this.usingUnlabeledTrackers;
        ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        this.cancelButton.m_93666_((Component)Component.m_237115_((String)"gui.cancel"));
        this.resetButton.f_93624_ = false;
    }

    public boolean isCalibrated() {
        return this.calibrated;
    }

    protected void m_7856_() {
        this.calibrationText = new MultilineComponent(this.f_96543_ / 2, 30, 400, (Component)Component.m_237115_((String)"vivecraft.messages.fbtcalibration"), true, this.f_96547_);
        this.unlabeledTrackersWarningText = new MultilineComponent(this.f_96543_ / 2, this.calibrationText.f_93621_ + this.calibrationText.m_93694_(), 400, (Component)Component.m_237115_((String)"vivecraft.messages.fbtcalibration.unlabeledTrackers"), true, this.f_96547_);
        this.unlabeledTrackersWarningText.f_93624_ = this.usingUnlabeledTrackers;
        this.unlabeledTrackersConfirmationText = new MultilineComponent(this.f_96543_ / 2, 30, 400, (Component)Component.m_237115_((String)"vivecraft.messages.fbtcalibration.unlabeledTrackersConfirm"), true, this.f_96547_);
        this.unlabeledTrackersConfirmationText.f_93624_ = false;
        this.resetButton = new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 54, 150, 20, (Component)Component.m_237115_((String)"controls.reset"), p -> this.reset());
        this.resetButton.f_93624_ = this.calibrated;
        this.cancelButton = new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 32, 150, 20, (Component)Component.m_237115_((String)(this.calibrated ? "vivecraft.gui.ok" : "gui.cancel")), p -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.calibrationText);
        this.m_142416_((GuiEventListener)this.unlabeledTrackersWarningText);
        this.m_142416_((GuiEventListener)this.unlabeledTrackersConfirmationText);
        this.m_142416_((GuiEventListener)this.resetButton);
        this.m_142416_((GuiEventListener)this.cancelButton);
        if (VRState.VR_RUNNING) {
            this.yaw = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getYawRad();
        }
    }

    public void m_7861_() {
        if (!this.calibrated) {
            ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = this.wasFbtCalibrated;
            ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = this.wasFbtExtendedCalibrated;
            for (int i = 0; i < this.oldFbtOffsets.length; ++i) {
                ClientDataHolderVR.getInstance().vrSettings.fbtOffsets[i].set(this.oldFbtOffsets[i]);
                ClientDataHolderVR.getInstance().vrSettings.fbtRotations[i].set(this.oldFbtRotations[i]);
            }
            ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.calibrationText.f_93624_ = !this.calibrated;
        this.unlabeledTrackersWarningText.f_93624_ = !this.calibrated && this.usingUnlabeledTrackers;
        this.unlabeledTrackersConfirmationText.f_93624_ = this.calibrated && this.usingUnlabeledTrackers;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (!this.calibrated || !this.usingUnlabeledTrackers) {
            GuiHelper.renderOutline(poseStack, this.f_96543_ / 2 - 64, this.f_96544_ - 32 - 96, 48, 16, -1);
            GuiHelper.renderOutline(poseStack, this.f_96543_ / 2 + 16, this.f_96544_ - 32 - 96, 48, 16, -1);
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)((float)this.f_96544_ - 32.0f), 0.0);
            poseStack.m_85841_(4.0f, -4.0f, 4.0f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.PI));
            if (VRState.VR_RUNNING) {
                poseStack.m_85845_(Vector3f.f_122225_.m_122270_(this.yaw - ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getYawRad()));
            }
            Vec3i color = this.leftHandAtPosition && this.rightHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE;
            BufferBuilder builder = Tesselator.m_85913_().m_85915_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            RenderHelper.renderBox((VertexConsumer)builder, new Vec3(2.0, 0.0, 0.0), new Vec3(2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((VertexConsumer)builder, new Vec3(-2.0, 0.0, 0.0), new Vec3(-2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((VertexConsumer)builder, new Vec3(0.0, 12.0, 0.0), new Vec3(0.0, 24.0, 0.0), 8.0f, 4.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((VertexConsumer)builder, new Vec3(0.0, 24.0, 0.0), new Vec3(0.0, 32.0, 0.0), 8.0f, 8.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((VertexConsumer)builder, new Vec3(6.0, 22.0, 0.0).m_82492_((double)(this.leftHand.x * 2.0f), (double)(this.leftHand.y * 2.0f), (double)(this.leftHand.z * 2.0f)), new Vec3(6.0, 22.0, 0.0).m_82520_((double)(this.leftHand.x * 10.0f), (double)(this.leftHand.y * 10.0f), (double)(this.leftHand.z * 10.0f)), 4.0f, 4.0f, this.leftHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack);
            RenderHelper.renderBox((VertexConsumer)builder, new Vec3(-6.0, 22.0, 0.0).m_82492_((double)(this.rightHand.x * 2.0f), (double)(this.rightHand.y * 2.0f), (double)(this.rightHand.z * 2.0f)), new Vec3(-6.0, 22.0, 0.0).m_82520_((double)(this.rightHand.x * 10.0f), (double)(this.rightHand.y * 10.0f), (double)(this.rightHand.z * 10.0f)), 4.0f, 4.0f, this.rightHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
            poseStack.m_85849_();
        }
    }

    public void m_86600_() {
        boolean leftHandNew;
        if (!VRState.VR_RUNNING) {
            this.rightHand.set(MathUtils.DOWN);
            this.leftHand.set(MathUtils.DOWN);
            return;
        }
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        org.joml.Vector3f hmdPosAvg = dataHolder.vr.hmdPivotHistory.averagePosition(0.5);
        float height = hmdPosAvg.y / 1.52f;
        float scale = height * 0.9375f;
        int main = dataHolder.vrSettings.reverseHands ? 1 : 0;
        this.rightHand = dataHolder.vrPlayer.vrdata_room_post.getController(main).getPositionF().sub(hmdPosAvg.x, 1.375f * scale, hmdPosAvg.z).rotateY(this.yaw).add(scale * 0.375f, 0.0f, 0.0f).normalize();
        this.leftHand = dataHolder.vrPlayer.vrdata_room_post.getController(1 - main).getPositionF().sub(hmdPosAvg.x, 1.375f * scale, hmdPosAvg.z).rotateY(this.yaw).add(-scale * 0.375f, 0.0f, 0.0f).normalize();
        boolean rightHandNew = this.rightHand.dot(MathUtils.RIGHT) > 0.9f;
        boolean bl = leftHandNew = this.leftHand.dot(MathUtils.LEFT) > 0.9f;
        if (!this.rightHandAtPosition && rightHandNew) {
            dataHolder.vr.triggerHapticPulse(ControllerType.RIGHT, 0.01f, 100.0f, 1.0f);
        }
        if (!this.leftHandAtPosition && leftHandNew) {
            dataHolder.vr.triggerHapticPulse(ControllerType.LEFT, 0.01f, 100.0f, 1.0f);
        }
        this.rightHandAtPosition = rightHandNew;
        this.leftHandAtPosition = leftHandNew;
        if (VRState.VR_RUNNING) {
            if (this.calibrated && this.usingUnlabeledTrackers) {
                dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(false);
            } else {
                dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(this.leftHandAtPosition && this.rightHandAtPosition);
                if (VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.LEFT) && VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.RIGHT) && VivecraftVRMod.INSTANCE.keyVRInteract.m_90859_()) {
                    AutoCalibration.calibrateManual();
                    dataHolder.vr.calibrateFBT(this.yaw + (float)Math.PI);
                    dataHolder.vrSettings.unlabeledTrackersUsed = this.usingUnlabeledTrackers;
                    dataHolder.vrSettings.saveOptions();
                    ClientUtils.addChatMessage((Component)Component.m_237115_((String)"vivecraft.messages.fbtcalibrationsuccess"));
                    this.calibrated = true;
                    if (!this.usingUnlabeledTrackers) {
                        this.f_96541_.m_91152_(this.parent);
                    } else {
                        this.cancelButton.m_93666_((Component)Component.m_237115_((String)"vivecraft.gui.ok"));
                        this.resetButton.f_93624_ = true;
                    }
                }
            }
        }
    }
}

