/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.render.VRPlayerModel;
import org.vivecraft.client.render.models.HandModel;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.settings.VRSettings;

public class VRPlayerModel_WithArms<T extends LivingEntity>
extends VRPlayerModel<T>
implements HandModel {
    public static final int LOWER_EXTENSION = 2;
    public static final int UPPER_EXTENSION = 3;
    public ModelPart leftHand;
    public ModelPart rightHand;
    public ModelPart leftHandSleeve;
    public ModelPart rightHandSleeve;
    private final Vector3f jointOffset = new Vector3f();

    public VRPlayerModel_WithArms(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.leftHandSleeve = root.m_171324_("left_hand_sleeve");
        this.rightHandSleeve = root.m_171324_("right_hand_sleeve");
        this.leftHand = root.m_171324_("left_hand");
        this.rightHand = root.m_171324_("right_hand");
        ModelUtils.textureHack(this.f_102812_, this.leftHand);
        ModelUtils.textureHack(this.f_102811_, this.rightHand);
        ModelUtils.textureHack(this.f_103374_, this.leftHandSleeve);
        ModelUtils.textureHack(this.f_103375_, this.rightHandSleeve);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        float lowerShrinkage;
        MeshDefinition meshDefinition = VRPlayerModel.createMesh(cubeDeformation, slim);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 3 : 0;
        int lowerExtension = connected ? 2 : 0;
        float f = lowerShrinkage = connected ? -0.05f : 0.0f;
        if (slim) {
            partDefinition.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(32, 55 - lowerExtension).m_171488_(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(lowerShrinkage)), PartPose.m_171419_((float)5.5f, (float)12.0f, (float)0.0f));
            partDefinition.m_171599_("left_hand_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 55 - lowerExtension).m_171488_(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(0.25f + lowerShrinkage)), PartPose.m_171419_((float)5.5f, (float)12.0f, (float)0.0f));
            partDefinition.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(40, 23 - lowerExtension).m_171488_(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(lowerShrinkage)), PartPose.m_171419_((float)-5.5f, (float)12.0f, (float)0.0f));
            partDefinition.m_171599_("right_hand_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 39 - lowerExtension).m_171488_(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(0.25f + lowerShrinkage)), PartPose.m_171419_((float)-5.5f, (float)12.0f, (float)0.0f));
            partDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            partDefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            partDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
            partDefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        } else {
            partDefinition.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(32, 55 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(lowerShrinkage)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.m_171599_("left_hand_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 55 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(0.25f + lowerShrinkage)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(40, 23 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(lowerShrinkage)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partDefinition.m_171599_("right_hand_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 39 - lowerExtension).m_171488_(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.m_171469_(0.25f + lowerShrinkage)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
            partDefinition.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.m_171469_(0.25f)), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        }
        return meshDefinition;
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.leftHand, (Object)this.rightHand, (Object)this.leftHandSleeve, (Object)this.rightHandSleeve));
    }

    @Override
    public void m_6973_(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart mainShoulder;
        super.m_6973_(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.rotInfo == null) {
            return;
        }
        ModelPart offHand = this.rotInfo.leftHanded ? this.rightHand : this.leftHand;
        ModelPart mainHand = this.rotInfo.leftHanded ? this.leftHand : this.rightHand;
        ModelPart offShoulder = this.rotInfo.leftHanded ? this.f_102811_ : this.f_102812_;
        ModelPart modelPart = mainShoulder = this.rotInfo.leftHanded ? this.f_102812_ : this.f_102811_;
        if (this.rotInfo.offHandPos.distanceSquared(this.rotInfo.mainHandPos) > 0.0f) {
            boolean useWorldScale;
            float offset = (this.f_103380_ ? 0.5f : 1.0f) * this.armScale * (this.rotInfo.leftHanded ? -1.0f : 1.0f);
            boolean bl = useWorldScale = this.isMainPlayer || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale;
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((LivingEntity)player, mainShoulder, mainHand, this.rotInfo.mainHandPos, this.rotInfo.mainHandQuat, -offset, this.rotInfo.rightElbowPos, true, this.mainArm, useWorldScale);
            } else {
                this.positionSplitLimb((LivingEntity)player, mainShoulder, mainHand, this.rotInfo.mainHandPos, this.rotInfo.mainHandQuat, 0.0f, -offset, this.rotInfo.rightElbowPos, true, this.mainArm, useWorldScale);
            }
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((LivingEntity)player, offShoulder, offHand, this.rotInfo.offHandPos, this.rotInfo.offHandQuat, offset, this.rotInfo.leftElbowPos, true, this.mainArm.m_20828_(), useWorldScale);
            } else {
                this.positionSplitLimb((LivingEntity)player, offShoulder, offHand, this.rotInfo.offHandPos, this.rotInfo.offHandQuat, 0.0f, offset, this.rotInfo.leftElbowPos, true, this.mainArm.m_20828_(), useWorldScale);
            }
            if (this.isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                this.tempM.rotateLocalX(this.xRot);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.set3x3((Matrix3fc)this.tempM);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateX(-1.5707964f);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateLocalY(-this.bodyYaw - (float)Math.PI);
                ModelUtils.modelToWorld(player, offHand.f_104200_, offHand.f_104201_, offHand.f_104202_, this.rotInfo, this.bodyYaw, true, true, this.tempV);
                GuiHandler.GUI_POS_PLAYER_MODEL = player.m_20318_(ClientUtils.getCurrentPartialTick()).m_82520_((double)this.tempV.x, (double)this.tempV.y, (double)this.tempV.z);
            }
        } else {
            float offset = this.f_103380_ ? this.armScale * 0.5f : this.armScale;
            this.tempV.set(-offset, 10.0f, 0.0f).rotateZ(mainShoulder.f_104205_).rotateY(mainShoulder.f_104204_).rotateX(mainShoulder.f_104203_);
            mainHand.m_104315_(mainShoulder);
            mainHand.f_104200_ += this.tempV.x;
            mainHand.f_104201_ += this.tempV.y;
            mainHand.f_104202_ += this.tempV.z;
            this.tempV.set(offset, 10.0f, 0.0f).rotateZ(offShoulder.f_104205_).rotateY(offShoulder.f_104204_).rotateX(offShoulder.f_104203_);
            offHand.m_104315_(offShoulder);
            offHand.f_104200_ += this.tempV.x;
            offHand.f_104201_ += this.tempV.y;
            offHand.f_104202_ += this.tempV.z;
            if (this.isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                GuiHandler.GUI_POS_PLAYER_MODEL = Vec3.f_82478_;
            }
        }
        this.rightHand.f_233553_ = this.rightHand.f_233555_ = this.armScale;
        this.leftHand.f_233555_ = this.rightHand.f_233555_;
        this.leftHand.f_233553_ = this.rightHand.f_233555_;
        if (this.layAmount > 0.0f) {
            ModelUtils.applySwimRotationOffset(player, this.xRot, this.tempV, this.tempV2, new ModelPart[]{this.f_102812_, this.f_102811_, this.leftHand, this.rightHand});
        }
        if (player.m_21209_()) {
            VRPlayerModel_WithArms.spinOffset(this.f_102812_, this.f_102811_, this.leftHand, this.rightHand);
        }
        this.leftHandSleeve.m_104315_(this.leftHand);
        this.rightHandSleeve.m_104315_(this.rightHand);
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103375_.m_104315_(this.f_102811_);
        this.leftHandSleeve.f_104207_ &= this.f_103374_.f_104207_;
        this.rightHandSleeve.f_104207_ &= this.f_103375_.f_104207_;
    }

    protected void positionSplitLimb(LivingEntity player, ModelPart upper, ModelPart lower, Vector3fc lowerPos, Quaternionfc lowerRot, float lowerXRot, float lowerXOffset, Vector3fc jointPos, boolean jointDown, HumanoidArm arm, boolean useWorldScale) {
        ModelUtils.worldToModel(player, lowerPos, this.rotInfo, this.bodyYaw, useWorldScale, this.tempV);
        lower.m_104227_(this.tempV.x, this.tempV.y, this.tempV.z);
        ModelUtils.estimateJointDir(upper, lower, lowerRot, this.bodyYaw, jointDown, jointPos, player, this.rotInfo, useWorldScale, this.tempV2, this.tempV);
        ModelUtils.estimateJoint(upper.f_104200_, upper.f_104201_, upper.f_104202_, lower.f_104200_, lower.f_104201_, lower.f_104202_, (Vector3fc)this.tempV2, 12.0f, this.tempV);
        if (jointDown) {
            this.tempV2.mul(-1.0f);
        }
        this.jointOffset.set(lower.f_104200_ - upper.f_104200_, lower.f_104201_ - upper.f_104201_, lower.f_104202_ - upper.f_104202_);
        this.jointOffset.cross((Vector3fc)this.tempV2).normalize().mul(lowerXOffset * 0.5f);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointModelAtModelWithUp(upper, this.tempV.x, this.tempV.y, this.tempV.z, (Vector3fc)this.tempV2, this.tempV, this.tempM);
        this.tempM.rotateLocalX(-this.xRot);
        ModelUtils.setRotation(upper, (Matrix3fc)this.tempM, this.tempV);
        ModelUtils.toModelDir(this.bodyYaw, lowerRot, this.tempM);
        if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && arm != null && this.attackArm == arm) {
            ModelUtils.swingAnimation(lower, arm, -3.0f, this.f_102608_, this.isMainPlayer, this.tempM, this.tempV, this.tempV2);
        }
        this.tempM.rotateLocalX(-this.xRot + lowerXRot);
        ModelUtils.setRotation(lower, (Matrix3fc)this.tempM, this.tempV);
    }

    protected void positionConnectedLimb(LivingEntity player, ModelPart upper, ModelPart lower, Vector3fc lowerPos, Quaternionfc lowerRot, float lowerXOffset, Vector3fc jointPos, boolean jointDown, HumanoidArm arm, boolean useWorldScale) {
        ModelUtils.worldToModel(player, lowerPos, this.rotInfo, this.bodyYaw, useWorldScale, this.tempV);
        float armLength = 10.0f;
        if (arm != null) {
            this.tempV.normalize(this.tempV2);
            armLength += 2.0f * this.tempV2.z * this.tempV2.z;
        }
        this.tempV.sub(upper.f_104200_, upper.f_104201_, upper.f_104202_, this.tempV2);
        float length = this.tempV2.length();
        upper.f_104201_ -= 2.0f * Math.min(1.0f, length / armLength) * Math.max(0.0f, -this.tempV2.y / length);
        if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && length > armLength) {
            this.tempV.sub(upper.f_104200_, upper.f_104201_, upper.f_104202_);
            this.tempV.normalize().mul(armLength);
            this.tempV.add(upper.f_104200_, upper.f_104201_, upper.f_104202_);
        }
        lower.m_104227_(this.tempV.x, this.tempV.y, this.tempV.z);
        ModelUtils.estimateJointDir(upper, lower, lowerRot, this.bodyYaw, jointDown, jointPos, player, this.rotInfo, useWorldScale, this.tempV2, this.tempV);
        ModelUtils.estimateJoint(upper.f_104200_, upper.f_104201_, upper.f_104202_, lower.f_104200_, lower.f_104201_, lower.f_104202_, (Vector3fc)this.tempV2, armLength, this.tempV);
        if (jointDown) {
            this.tempV2.mul(-1.0f);
        }
        float jointX = this.tempV.x;
        float jointY = this.tempV.y;
        float jointZ = this.tempV.z;
        this.jointOffset.set(lower.f_104200_ - upper.f_104200_, lower.f_104201_ - upper.f_104201_, lower.f_104202_ - upper.f_104202_);
        this.jointOffset.cross((Vector3fc)this.tempV2).normalize().mul(lowerXOffset * 0.5f);
        this.tempV.set(jointX - upper.f_104200_, jointY - upper.f_104201_, jointZ - upper.f_104202_);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointAtModel((Vector3fc)this.tempV, (Vector3fc)this.tempV2, this.tempM);
        this.tempM.rotateLocalX(-this.xRot);
        ModelUtils.setRotation(upper, (Matrix3fc)this.tempM, this.tempV);
        this.tempV.set(lower.f_104200_ - jointX, lower.f_104201_ - jointY, lower.f_104202_ - jointZ);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointAtModel((Vector3fc)this.tempV, (Vector3fc)this.tempV2, this.tempM);
        if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && arm != null && this.attackArm == arm) {
            ModelUtils.swingAnimation(lower, arm, -armLength * 0.5f, this.f_102608_, this.isMainPlayer, this.tempM, this.tempV, this.tempV2);
        }
        this.tempM.rotateLocalX(-this.xRot);
        ModelUtils.setRotation(lower, (Matrix3fc)this.tempM, this.tempV);
    }

    public void m_102872_(HumanoidModel<T> model) {
        super.m_102872_(model);
        if (model instanceof HandModel) {
            HandModel handModel = (HandModel)model;
            handModel.getLeftHand().m_104315_(this.leftHand);
            handModel.getRightHand().m_104315_(this.rightHand);
        }
    }

    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.leftHand.f_104207_ = visible;
        this.rightHand.f_104207_ = visible;
        this.leftHandSleeve.f_104207_ = visible;
        this.rightHandSleeve.f_104207_ = visible;
    }

    @Override
    public ModelPart getLeftHand() {
        return this.leftHand;
    }

    @Override
    public ModelPart getRightHand() {
        return this.rightHand;
    }

    @Override
    public void hideLeftArm(boolean completeArm) {
        this.leftHand.f_104207_ = false;
        this.leftHandSleeve.f_104207_ = false;
        if (completeArm) {
            super.hideLeftArm(false);
        }
    }

    @Override
    public void hideRightArm(boolean onlyHand) {
        this.rightHand.f_104207_ = false;
        this.rightHandSleeve.f_104207_ = false;
        if (onlyHand) {
            super.hideRightArm(false);
        }
    }

    protected ModelPart m_102851_(HumanoidArm side) {
        return side == HumanoidArm.RIGHT ? this.rightHand : this.leftHand;
    }

    @Override
    public void m_6002_(HumanoidArm side, PoseStack poseStack) {
        this.m_102851_(side).m_104299_(poseStack);
        poseStack.m_85837_(side == HumanoidArm.LEFT ? -0.0625 : 0.0625, (double)-0.65f, 0.0);
        this.doAttackAnim(side, poseStack);
    }
}

