/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.network.packet.c2s.CrawlPayloadC2S;

public class CrawlTracker
implements Tracker {
    private boolean wasCrawling;
    public boolean crawling;
    public boolean crawlsteresis;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public CrawlTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrSettings.allowCrawling) {
            return false;
        }
        if (!ClientNetworking.SERVER_ALLOWS_CRAWLING) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        return !player.m_20159_();
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.crawling = false;
        this.crawlsteresis = false;
        this.updateState(player);
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        float scaledWorldScale = this.dh.vrPlayer.worldScale / ScaleHelper.getEntityEyeHeightScale((LivingEntity)player, ClientUtils.getCurrentPartialTick());
        this.crawling = this.dh.vr.hmdPivotHistory.averagePosition((double)((double)0.2f)).y * scaledWorldScale + 0.1f < this.dh.vrSettings.crawlThreshold;
        this.updateState(player);
    }

    private void updateState(LocalPlayer player) {
        if (this.crawling != this.wasCrawling) {
            if (this.crawling) {
                player.m_20124_(Pose.SWIMMING);
                this.crawlsteresis = true;
            }
            if (ClientNetworking.SERVER_ALLOWS_CRAWLING) {
                ClientNetworking.sendServerPacket(new CrawlPayloadC2S(this.crawling));
            }
            this.wasCrawling = this.crawling;
        }
        if (!this.crawling && player.m_20089_() != Pose.SWIMMING) {
            this.crawlsteresis = false;
        }
    }
}

