/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.MirrorNotification;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;

public class ShaderHelper {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static float FOV_REDUCTION = 1.0f;
    private static float WATER_EFFECT;
    private static boolean WAS_IN_WATER;
    private static float PUMPKIN_EFFECT;
    private static float PORTAL_EFFECT;
    private static float RED;
    private static float BLACK;
    private static float BLUE;
    private static float TIME;

    public static void renderFullscreenQuad(@NotNull ShaderInstance instance, @NotNull RenderTarget source) {
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69461_();
        instance.m_173350_("Sampler0", (Object)source.m_83975_());
        instance.m_173363_();
        ShaderHelper.drawFullscreenQuad(instance.m_173364_());
        instance.m_173362_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private static void drawFullscreenQuad(VertexFormat format) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, format);
        if (format == DefaultVertexFormat.f_85817_) {
            builder.m_5483_(-1.0, -1.0, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
            builder.m_5483_(1.0, -1.0, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
            builder.m_5483_(1.0, 1.0, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
            builder.m_5483_(-1.0, 1.0, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        } else if (format == DefaultVertexFormat.f_85819_) {
            builder.m_5483_(-1.0, -1.0, 0.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            builder.m_5483_(1.0, -1.0, 0.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            builder.m_5483_(1.0, 1.0, 0.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
            builder.m_5483_(-1.0, 1.0, 0.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        } else {
            throw new IllegalStateException("Unexpected vertex format " + format);
        }
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static void doVrPostProcess(RenderPass eye, RenderTarget source, float partialTick) {
        if (eye == RenderPass.LEFT) {
            RED = 0.0f;
            BLACK = 0.0f;
            BLUE = 0.0f;
            TIME = (float)Util.m_137550_() / 1000.0f;
            PUMPKIN_EFFECT = 0.0f;
            PORTAL_EFFECT = 0.0f;
            if (ShaderHelper.MC.f_91074_ != null && ShaderHelper.MC.f_91073_ != null) {
                boolean isInWater = ((GameRendererExtension)ShaderHelper.MC.f_91063_).vivecraft$isInWater();
                if (ShaderHelper.DATA_HOLDER.vrSettings.waterEffect && WAS_IN_WATER != isInWater) {
                    WATER_EFFECT = 2.3f;
                } else {
                    WATER_EFFECT = isInWater ? (WATER_EFFECT -= 0.008333334f) : (WATER_EFFECT -= 0.016666668f);
                    if (WATER_EFFECT < 0.0f) {
                        WATER_EFFECT = 0.0f;
                    }
                }
                WAS_IN_WATER = isInWater;
                if (IrisHelper.isLoaded() && !IrisHelper.hasWaterEffect()) {
                    WATER_EFFECT = 0.0f;
                }
                float portalTime = Mth.m_14179_((float)partialTick, (float)ShaderHelper.MC.f_91074_.f_108590_, (float)ShaderHelper.MC.f_91074_.f_108589_);
                PORTAL_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.portalEffect && portalTime > 0.0f && !ShaderHelper.MC.f_91074_.m_21023_(MobEffects.f_19604_) ? portalTime : 0.0f;
                ItemStack itemstack = ShaderHelper.MC.f_91074_.m_6844_(EquipmentSlot.HEAD);
                PUMPKIN_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.pumpkinEffect && itemstack.m_41720_() == Blocks.f_50143_.m_5456_() && (!itemstack.m_41782_() || itemstack.m_41783_().m_128451_("CustomModelData") == 0) ? 1.0f : 0.0f;
                float hurtTimer = (float)ShaderHelper.MC.f_91074_.f_20916_ - partialTick;
                float healthPercent = 1.0f - ShaderHelper.MC.f_91074_.m_21223_() / ShaderHelper.MC.f_91074_.m_21233_();
                healthPercent = (healthPercent - 0.5f) * 0.75f;
                if (ShaderHelper.DATA_HOLDER.vrSettings.hitIndicator && hurtTimer > 0.0f) {
                    hurtTimer /= (float)ShaderHelper.MC.f_91074_.f_20917_;
                    RED = hurtTimer = healthPercent + Mth.m_14031_((float)(hurtTimer * hurtTimer * hurtTimer * hurtTimer * (float)Math.PI)) * 0.5f;
                } else if (ShaderHelper.DATA_HOLDER.vrSettings.lowHealthIndicator) {
                    RED = healthPercent * Mth.m_14154_((float)Mth.m_14031_((float)(2.5f * TIME / (1.0f - healthPercent + 0.1f))));
                    if (ShaderHelper.MC.f_91074_.m_7500_()) {
                        RED = 0.0f;
                    }
                }
                float freeze = ShaderHelper.MC.f_91074_.m_146889_();
                if (ShaderHelper.DATA_HOLDER.vrSettings.freezeEffect && freeze > 0.0f) {
                    BLUE = RED;
                    BLUE = Math.max(freeze / 2.0f, BLUE);
                    RED = 0.0f;
                }
                if (ShaderHelper.MC.f_91074_.m_5803_()) {
                    BLACK = 0.5f + 0.3f * (float)ShaderHelper.MC.f_91074_.m_36318_() * 0.01f;
                }
                if (ShaderHelper.DATA_HOLDER.vr.isWalkingAbout && BLACK < 0.8f) {
                    BLACK = 0.5f;
                }
                if (ShaderHelper.DATA_HOLDER.vrSettings.useFOVReduction && ShaderHelper.DATA_HOLDER.vrPlayer.getFreeMove()) {
                    FOV_REDUCTION = Math.abs(ShaderHelper.MC.f_91074_.f_20902_) > 0.0f || Math.abs(ShaderHelper.MC.f_91074_.f_20900_) > 0.0f ? (FOV_REDUCTION -= 0.05f) : (FOV_REDUCTION += 0.01f);
                    FOV_REDUCTION = Mth.m_14036_((float)FOV_REDUCTION, (float)ShaderHelper.DATA_HOLDER.vrSettings.fovReductionMin, (float)0.8f);
                } else {
                    FOV_REDUCTION = 1.0f;
                }
            } else {
                WATER_EFFECT = 0.0f;
                FOV_REDUCTION = 1.0f;
            }
            if (PUMPKIN_EFFECT > 0.0f) {
                VRShaders.POST_PROCESSING_FOV_REDUCTION_RADIUS_UNIFORM.m_5985_(0.3f);
                VRShaders.POST_PROCESSING_FOV_REDUCTION_BORDER_UNIFORM.m_5985_(0.0f);
            } else {
                VRShaders.POST_PROCESSING_FOV_REDUCTION_RADIUS_UNIFORM.m_5985_(FOV_REDUCTION);
                VRShaders.POST_PROCESSING_FOV_REDUCTION_BORDER_UNIFORM.m_5985_(0.06f);
            }
            VRShaders.POST_PROCESSING_FOV_REDUCTION_OFFSET_UNIFORM.m_5985_(ShaderHelper.DATA_HOLDER.vrSettings.fovRedutioncOffset);
            VRShaders.POST_PROCESSING_OVERLAY_HEALTH_ALPHA_UNiFORM.m_5985_(RED);
            VRShaders.POST_PROCESSING_OVERLAY_FREEZE_ALPHA_UNiFORM.m_5985_(BLUE);
            VRShaders.POST_PROCESSING_OVERLAY_BLACK_ALPHA_UNIFORM.m_5985_(BLACK);
            VRShaders.POST_PROCESSING_OVERLAY_TIME_UNIFORM.m_5985_(TIME);
            VRShaders.POST_PROCESSING_OVERLAY_WATER_AMPLITUDE_UNIFORM.m_5985_(WATER_EFFECT);
            VRShaders.POST_PROCESSING_OVERLAY_PORTAL_AMPLITUDE_UNIFORM.m_5985_(PORTAL_EFFECT);
            VRShaders.POST_PROCESSING_OVERLAY_PUMPKIN_AMPLITUDE_UNIFORM.m_5985_(PUMPKIN_EFFECT);
        }
        VRShaders.POST_PROCESSING_OVERLAY_EYE_UNIFORM.m_142617_(eye == RenderPass.LEFT ? 1 : -1);
        ShaderHelper.renderFullscreenQuad(VRShaders.POST_PROCESSING_SHADER, source);
    }

    public static void drawMirror() {
        if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF && ShaderHelper.DATA_HOLDER.vr.isHMDTracking()) {
            MirrorNotification.notify("Mirror is OFF", true, 1000);
        } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            if (VRShaders.MIXED_REALITY_SHADER != null) {
                ShaderHelper.doMixedRealityMirror();
            } else {
                MirrorNotification.notify("Mixed Reality Shader compile failed, see log for info", true, 10000);
            }
        } else if (!(ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.DUAL || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible())) {
            RenderTarget leftEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            RenderTarget rightEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
            int screenWidth = ((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenWidth() / 2;
            int screenHeight = ((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenHeight();
            if (leftEye != null) {
                ShaderHelper.blitToScreen(leftEye, 0, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
            if (rightEye != null) {
                ShaderHelper.blitToScreen(rightEye, screenWidth, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
        } else {
            float xCrop = 0.0f;
            float yCrop = 0.0f;
            boolean keepAspect = false;
            RenderTarget source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                keepAspect = true;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.GUI) {
                source = GuiHandler.GUI_FRAMEBUFFER;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.SINGLE || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.CROPPED) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
                xCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                yCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                keepAspect = true;
            }
            if (source != null) {
                ShaderHelper.blitToScreen(source, 0, ((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenWidth(), ((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenHeight(), 0, xCrop, yCrop, keepAspect);
            }
        }
        MirrorNotification.render();
    }

    public static void doMixedRealityMirror() {
        RenderSystem.m_69949_((int)0, (int)0, (int)((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenWidth(), (int)((WindowExtension)MC.m_91268_()).vivecraft$getActualScreenHeight());
        Vector3f camPlayer = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getHeadPivotF().sub((Vector3fc)ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getPositionF());
        Matrix4f viewMatrix = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getMatrix().transpose();
        Vector3f cameraLook = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getDirection();
        cameraLook.set(-cameraLook.x, 0.0f, -cameraLook.z);
        boolean alphaMask = ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike && ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityAlphaMask;
        VRShaders.MIXED_REALITY_PROJECTION_MATRIX_UNIFORM.m_5679_(((GameRendererExtension)ShaderHelper.MC.f_91063_).vivecraft$getThirdPassProjectionMatrix());
        VRShaders.MIXED_REALITY_VIEW_MATRIX_UNIFORM.m_5679_(MathUtils.toMcMat4((Matrix4fc)viewMatrix));
        VRShaders.MIXED_REALITY_HMD_VIEW_POSITION_UNIFORM.m_5889_(camPlayer.x, camPlayer.y, camPlayer.z);
        VRShaders.MIXED_REALITY_HMD_PLANE_NORMAL_UNIFORM.m_5889_(cameraLook.x, cameraLook.y, cameraLook.z);
        if (!alphaMask) {
            VRShaders.MIXED_REALITY_KEY_COLOR_UNIFORM.m_5889_((float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getRed() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getGreen() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getBlue() / 255.0f);
        } else {
            VRShaders.MIXED_REALITY_KEY_COLOR_UNIFORM.m_5889_(0.0f, 0.0f, 0.0f);
        }
        VRShaders.MIXED_REALITY_ALPHA_MODE_UNIFORM.m_142617_(alphaMask ? 1 : 0);
        VRShaders.MIXED_REALITY_FIRST_PERSON_PASS_UNIFORM.m_142617_(ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike ? 1 : 0);
        VRShaders.MIXED_REALITY_SHADER.m_173350_("thirdPersonColor", (Object)ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.m_83975_());
        VRShaders.MIXED_REALITY_SHADER.m_173350_("thirdPersonDepth", (Object)ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.m_83980_());
        if (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike) {
            RenderTarget source = ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible() ? ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer : (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUndistorted ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted : (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0 : ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1));
            VRShaders.MIXED_REALITY_SHADER.m_173350_("firstPersonColor", (Object)source.m_83975_());
        }
        VRShaders.MIXED_REALITY_SHADER.m_173363_();
        ShaderHelper.drawFullscreenQuad(VRShaders.MIXED_REALITY_SHADER.m_173364_());
        VRShaders.MIXED_REALITY_SHADER.m_173362_();
    }

    public static void doFSAA(RenderTarget source, RenderTarget firstPass, RenderTarget secondPass) {
        if (firstPass == null) {
            ShaderHelper.DATA_HOLDER.vrRenderer.reinitFrameBuffers("FSAA Setting Changed");
        } else {
            RenderSystem.m_69461_();
            RenderSystem.m_69456_((int)519);
            firstPass.m_83947_(true);
            VRShaders.LANCZOS_SHADER.m_173350_("Sampler0", (Object)source.m_83975_());
            VRShaders.LANCZOS_SHADER.m_173350_("Sampler1", (Object)source.m_83980_());
            VRShaders.LANCZOS_TEXEL_WIDTH_OFFSET_UNIFORM.m_5985_(1.0f / (3.0f * (float)firstPass.f_83917_));
            VRShaders.LANCZOS_TEXEL_HEIGHT_OFFSET_UNIFORM.m_5985_(0.0f);
            VRShaders.LANCZOS_SHADER.m_173363_();
            ShaderHelper.drawFullscreenQuad(VRShaders.LANCZOS_SHADER.m_173364_());
            secondPass.m_83947_(true);
            VRShaders.LANCZOS_SHADER.m_173350_("Sampler0", (Object)firstPass.m_83975_());
            VRShaders.LANCZOS_SHADER.m_173350_("Sampler1", (Object)firstPass.m_83980_());
            VRShaders.LANCZOS_TEXEL_WIDTH_OFFSET_UNIFORM.m_5985_(0.0f);
            VRShaders.LANCZOS_TEXEL_HEIGHT_OFFSET_UNIFORM.m_5985_(1.0f / (3.0f * (float)secondPass.f_83918_));
            VRShaders.LANCZOS_SHADER.m_173363_();
            ShaderHelper.drawFullscreenQuad(VRShaders.LANCZOS_SHADER.m_173364_());
            VRShaders.LANCZOS_SHADER.m_173362_();
            secondPass.m_83970_();
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69478_();
        }
    }

    public static void blitToScreen(RenderTarget source, int left, int width, int height, int top, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.m_187554_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69461_();
        float drawAspect = (float)width / (float)height;
        float bufferAspect = (float)source.f_83917_ / (float)source.f_83918_;
        float xMin = xCropFactor;
        float yMin = yCropFactor;
        float xMax = 1.0f - xCropFactor;
        float yMax = 1.0f - yCropFactor;
        if (keepAspect) {
            if (drawAspect > bufferAspect) {
                float heightAspect = bufferAspect / drawAspect * (0.5f - yCropFactor);
                yMin = 0.5f - heightAspect;
                yMax = 0.5f + heightAspect;
            } else {
                float widthAspect = drawAspect / bufferAspect * (0.5f - xCropFactor);
                xMin = 0.5f - widthAspect;
                xMax = 0.5f + widthAspect;
            }
        }
        VRShaders.BLIT_VR_SHADER.m_173350_("DiffuseSampler", (Object)source.m_83975_());
        VRShaders.BLIT_VR_SHADER.m_173363_();
        BufferBuilder bufferBuilder = RenderSystem.m_69883_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, VRShaders.BLIT_VR_SHADER.m_173364_());
        float xMinPos = (float)left / (float)ShaderHelper.MC.m_91385_().f_83917_ * 2.0f - 1.0f;
        float yMinPos = (float)top / (float)ShaderHelper.MC.m_91385_().f_83918_ * 2.0f - 1.0f;
        float xMaxPos = xMinPos + (float)width / (float)ShaderHelper.MC.m_91385_().f_83917_ * 2.0f;
        float yMaxPos = yMinPos + (float)height / (float)ShaderHelper.MC.m_91385_().f_83918_ * 2.0f;
        bufferBuilder.m_5483_((double)xMinPos, (double)yMinPos, 0.0).m_7421_(xMin, yMin).m_5752_();
        bufferBuilder.m_5483_((double)xMaxPos, (double)yMinPos, 0.0).m_7421_(xMax, yMin).m_5752_();
        bufferBuilder.m_5483_((double)xMaxPos, (double)yMaxPos, 0.0).m_7421_(xMax, yMax).m_5752_();
        bufferBuilder.m_5483_((double)xMinPos, (double)yMaxPos, 0.0).m_7421_(xMin, yMax).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        VRShaders.BLIT_VR_SHADER.m_173362_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

