/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.utils;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3fc;

public class MathUtils {
    public static final Vector3fc FORWARD = new org.joml.Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3fc BACK = new org.joml.Vector3f(0.0f, 0.0f, -1.0f);
    public static final Vector3fc LEFT = new org.joml.Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3fc RIGHT = new org.joml.Vector3f(-1.0f, 0.0f, 0.0f);
    public static final Vector3fc UP = new org.joml.Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3fc DOWN = new org.joml.Vector3f(0.0f, -1.0f, 0.0f);
    public static final Vector3fc ZERO = new org.joml.Vector3f();
    public static final Vec3 FORWARD_D = new Vec3(0.0, 0.0, 1.0);
    public static final Vec3 BACK_D = new Vec3(0.0, 0.0, -1.0);
    public static final Vec3 LEFT_D = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 RIGHT_D = new Vec3(-1.0, 0.0, 0.0);
    public static final Vec3 UP_D = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 DOWN_D = new Vec3(0.0, -1.0, 0.0);
    public static final Vector3fc RED = LEFT;
    public static final Vector3fc GREEN = UP;
    public static final Vector3fc BLUE = FORWARD;
    public static final Vector3fc ORANGE = new org.joml.Vector3f(1.0f, 0.75f, 0.0f);
    public static final Vector3fc DARK_GRAY = new org.joml.Vector3f(0.25f);
    public static final Vector3fc LIGHT_GRAY = new org.joml.Vector3f(0.75f);
    public static final Matrix4fc IDENTITY = new org.joml.Matrix4f();

    public static org.joml.Vector3f subtractToVector3f(Vec3 a, Vec3 b) {
        return new org.joml.Vector3f((float)(a.f_82479_ - b.f_82479_), (float)(a.f_82480_ - b.f_82480_), (float)(a.f_82481_ - b.f_82481_));
    }

    public static Vec3 toMcVec3(Vector3fc v) {
        return new Vec3((double)v.x(), (double)v.y(), (double)v.z());
    }

    public static Vector3f toMcVector3f(Vector3fc v) {
        return new Vector3f(v.x(), v.y(), v.z());
    }

    public static org.joml.Vector3f getPerpendicularVec(Vector3fc vec) {
        if (Math.abs(vec.dot(UP)) / vec.length() != 1.0f) {
            return vec.cross(UP, new org.joml.Vector3f()).normalize();
        }
        return vec.cross(LEFT, new org.joml.Vector3f()).normalize();
    }

    public static Matrix4f toMcMat4(Matrix4fc m) {
        Matrix4f mcMat = new Matrix4f();
        mcMat.f_27603_ = m.m00();
        mcMat.f_27604_ = m.m10();
        mcMat.f_27605_ = m.m20();
        mcMat.f_27606_ = m.m30();
        mcMat.f_27607_ = m.m01();
        mcMat.f_27608_ = m.m11();
        mcMat.f_27609_ = m.m21();
        mcMat.f_27610_ = m.m31();
        mcMat.f_27611_ = m.m02();
        mcMat.f_27612_ = m.m12();
        mcMat.f_27613_ = m.m22();
        mcMat.f_27614_ = m.m32();
        mcMat.f_27615_ = m.m03();
        mcMat.f_27616_ = m.m13();
        mcMat.f_27617_ = m.m23();
        mcMat.f_27618_ = m.m33();
        return mcMat;
    }

    public static Quaternion toMcQuat(Quaternionfc q) {
        return new Quaternion(q.x(), q.y(), q.z(), q.w());
    }

    public static double lerpMod(double from, double to, double percent, double mod) {
        return Math.abs(to - from) < mod / 2.0 ? from + (to - from) * percent : from + (to - from - Math.signum(to - from) * mod) * percent;
    }

    public static float angleDiff(float a, float b) {
        float d = Math.abs(a - b) % 360.0f;
        float r = d > 180.0f ? 360.0f - d : d;
        float diff = a - b;
        int sign = diff >= 0.0f && diff <= 180.0f || diff <= -180.0f && diff >= -360.0f ? 1 : -1;
        return r * (float)sign;
    }

    public static float angleNormalize(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static float wrapRadians(float value) {
        float wrapped = value % ((float)Math.PI * 2);
        if (wrapped >= (float)Math.PI) {
            wrapped -= (float)Math.PI * 2;
        }
        if (wrapped < (float)(-Math.PI)) {
            wrapped += (float)Math.PI * 2;
        }
        return wrapped;
    }

    public static float rotLerpRad(float delta, float start, float end) {
        return start + delta * MathUtils.wrapRadians(end - start);
    }

    public static Vec3 vecDLerp(Vec3 start, Vec3 end, double fraction) {
        double x = start.f_82479_ + (end.f_82479_ - start.f_82479_) * fraction;
        double y = start.f_82480_ + (end.f_82480_ - start.f_82480_) * fraction;
        double z = start.f_82481_ + (end.f_82481_ - start.f_82481_) * fraction;
        return new Vec3(x, y, z);
    }

    public static org.joml.Vector3f vecLerp(org.joml.Vector3f start, float endX, float endY, float endZ, float fraction) {
        return start.set(start.x + (endX - start.x) * fraction, start.y + (endY - start.y) * fraction, start.z + (endZ - start.z) * fraction);
    }

    public static float applyDeadzone(float axis, float deadzone) {
        if (Math.abs(axis) > deadzone) {
            float scalar = 1.0f / (1.0f - deadzone);
            return (Math.abs(axis) - deadzone) * scalar * Math.signum(axis);
        }
        return 0.0f;
    }

    public static Vector2f toDigital(Vector2f value, float deadzone) {
        Vector2f digital = new Vector2f();
        if (value.length() > deadzone) {
            float angle = (float)Math.atan2(value.x, value.y);
            float angleAbs = Math.abs(angle);
            float PI_8TH = 0.3926991f;
            if (angleAbs >= 0.3926991f && angleAbs <= 2.7488937f) {
                digital.x = Math.signum(angle);
            }
            if (angleAbs < 1.1780972f) {
                digital.y = 1.0f;
            } else if (angleAbs > 1.9634955f) {
                digital.y = -1.0f;
            }
        }
        return digital;
    }

    public static float normalizedDotXZ(Vector3fc a, Vector3fc b) {
        return (a.x() * b.x() + a.z() * b.z()) / (float)Math.sqrt((a.x() * a.x() + a.z() * a.z()) * (b.x() * b.x() + b.z() * b.z()));
    }

    public static void rotateX(org.joml.Vector3f v, float sin, float cos) {
        float ogY = v.y;
        v.y = ogY * cos - v.z * sin;
        v.z = ogY * sin + v.z * cos;
    }

    public static org.joml.Vector3f getEulerAnglesYZX(Quaternionf rot) {
        return new org.joml.Vector3f((float)Math.asin(-2.0f * (rot.y * rot.z - rot.w * rot.x)), (float)Math.atan2(2.0f * (rot.x * rot.z + rot.w * rot.y), rot.w * rot.w - rot.x * rot.x - rot.y * rot.y + rot.z * rot.z), (float)Math.atan2(2.0f * (rot.x * rot.y + rot.w * rot.z), rot.w * rot.w - rot.x * rot.x + rot.y * rot.y - rot.z * rot.z));
    }

    public static org.joml.Vector3f getEulerAnglesZYX(Quaternionfc rot, org.joml.Vector3f eulerAngles) {
        eulerAngles.x = org.joml.Math.atan2((float)(rot.y() * rot.z() + rot.w() * rot.x()), (float)(0.5f - rot.x() * rot.x() - rot.y() * rot.y()));
        eulerAngles.y = org.joml.Math.safeAsin((float)(-2.0f * (rot.x() * rot.z() - rot.w() * rot.y())));
        eulerAngles.z = org.joml.Math.atan2((float)(rot.x() * rot.y() + rot.w() * rot.z()), (float)(0.5f - rot.y() * rot.y() - rot.z() * rot.z()));
        return eulerAngles;
    }

    public static boolean isZero(Vector3fc vec) {
        return vec.x() == 0.0f && vec.y() == 0.0f && vec.z() == 0.0f;
    }

    public static org.joml.Matrix4f addTranslation(org.joml.Matrix4f matrix, org.joml.Vector3f translation) {
        return matrix.m30(matrix.m30() + translation.x).m31(matrix.m31() + translation.y).m32(matrix.m32() + translation.z);
    }

    public static float bodyYawRad(Vector3fc rightHand, Vector3fc leftHand, Vector3fc headDir) {
        org.joml.Vector3f dir = leftHand.add(rightHand, new org.joml.Vector3f());
        float hDot = MathUtils.normalizedDotXZ((Vector3fc)dir, headDir);
        org.joml.Vector3f armsForward = leftHand.sub(rightHand, new org.joml.Vector3f()).rotateY(-1.5707964f);
        if (armsForward.dot(headDir) < 0.0f) {
            armsForward.mul(-1.0f);
        }
        armsForward.lerp((Vector3fc)dir, Math.max(0.0f, hDot), dir);
        dir.normalize().lerp(headDir, 0.5f, dir);
        return (float)Math.atan2(-dir.x, dir.z);
    }
}

