/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import org.vivecraft.Xloader;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;

public class TooltipUtil {
    public static String getClientConfigTooltip(VRSettings.VrOptions option) {
        Language lang = Language.m_128107_();
        Object tooltip = "";
        String tooltipString = "vivecraft.options." + option.name() + ".tooltip";
        String tooltipDisabledString = "vivecraft.options." + option.name() + ".disabled.tooltip";
        if (lang.m_6722_(tooltipString)) {
            tooltip = lang.m_6834_(tooltipString);
        }
        if (!option.isChangeable()) {
            tooltip = lang.m_6834_(tooltipDisabledString) + "\n" + (String)tooltip;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.overrides.hasSetting(option)) {
            VRSettings.ServerOverrides.Setting setting = ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(option);
            if (setting.isValueOverridden()) {
                tooltip = lang.m_6834_("vivecraft.message.overriddenbyserver") + (String)tooltip;
            } else if (setting.isFloat() && (setting.isValueMinOverridden() || setting.isValueMaxOverridden())) {
                tooltip = lang.m_6834_("vivecraft.message.limitedbyserver").formatted(Float.valueOf(setting.getValueMin()), Float.valueOf(setting.getValueMax())) + (String)tooltip;
            }
        }
        return tooltip;
    }

    public static String getServerConfigTooltip(String serverConfigPath, boolean addAllTooltip) {
        Language lang = Language.m_128107_();
        Object tooltip = "";
        String configString = "vivecraft.serverSettings." + serverConfigPath;
        String tooltipString = configString + ".tooltip";
        if (lang.m_6722_(tooltipString)) {
            tooltip = lang.m_6834_(tooltipString);
        } else if (lang.m_6722_(configString)) {
            tooltip = lang.m_6834_(configString);
        }
        if (addAllTooltip) {
            String selfAllTooltip = "vivecraft.serverSettings." + serverConfigPath + ".tooltipall";
            if (lang.m_6722_(selfAllTooltip)) {
                tooltip = (String)tooltip + "\n" + lang.m_6834_(selfAllTooltip);
            } else {
                String parent = serverConfigPath.substring(0, Math.max(serverConfigPath.lastIndexOf(46), 0));
                String parentAllTooltip = "vivecraft.serverSettings." + parent + ".tooltipall";
                if (lang.m_6722_(parentAllTooltip)) {
                    tooltip = (String)tooltip + "\n" + lang.m_6834_(parentAllTooltip);
                }
            }
        }
        if (!Xloader.isDedicatedServer()) {
            tooltip = (String)tooltip + TooltipUtil.getClientOnlyTooltip();
        }
        return tooltip;
    }

    private static String getClientOnlyTooltip() {
        if (Minecraft.m_91087_().f_91073_ != null && !Minecraft.m_91087_().m_91090_()) {
            return "\n" + Language.m_128107_().m_6834_("vivecraft.messages.serversettingsnotavailablesingle");
        }
        return "";
    }
}

