/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.utils;

import net.minecraft.class_2477;
import net.minecraft.class_310;
import org.vivecraft.Xloader;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;

public class TooltipUtil {
    public static String getClientConfigTooltip(VRSettings.VrOptions option) {
        class_2477 lang = class_2477.method_10517();
        Object tooltip = "";
        String tooltipString = "vivecraft.options." + option.name() + ".tooltip";
        String tooltipDisabledString = "vivecraft.options." + option.name() + ".disabled.tooltip";
        if (lang.method_4678(tooltipString)) {
            tooltip = lang.method_48307(tooltipString);
        }
        if (!option.isChangeable()) {
            tooltip = lang.method_48307(tooltipDisabledString) + "\n" + (String)tooltip;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.overrides.hasSetting(option)) {
            VRSettings.ServerOverrides.Setting setting = ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(option);
            if (setting.isValueOverridden()) {
                tooltip = lang.method_48307("vivecraft.message.overriddenbyserver") + (String)tooltip;
            } else if (setting.isFloat() && (setting.isValueMinOverridden() || setting.isValueMaxOverridden())) {
                tooltip = lang.method_48307("vivecraft.message.limitedbyserver").formatted(Float.valueOf(setting.getValueMin()), Float.valueOf(setting.getValueMax())) + (String)tooltip;
            }
        }
        return tooltip;
    }

    public static String getServerConfigTooltip(String serverConfigPath, boolean addAllTooltip) {
        class_2477 lang = class_2477.method_10517();
        Object tooltip = "";
        String configString = "vivecraft.serverSettings." + serverConfigPath;
        String tooltipString = configString + ".tooltip";
        if (lang.method_4678(tooltipString)) {
            tooltip = lang.method_48307(tooltipString);
        } else if (lang.method_4678(configString)) {
            tooltip = lang.method_48307(configString);
        }
        if (addAllTooltip) {
            String selfAllTooltip = "vivecraft.serverSettings." + serverConfigPath + ".tooltipall";
            if (lang.method_4678(selfAllTooltip)) {
                tooltip = (String)tooltip + "\n" + lang.method_48307(selfAllTooltip);
            } else {
                String parent = serverConfigPath.substring(0, Math.max(serverConfigPath.lastIndexOf(46), 0));
                String parentAllTooltip = "vivecraft.serverSettings." + parent + ".tooltipall";
                if (lang.method_4678(parentAllTooltip)) {
                    tooltip = (String)tooltip + "\n" + lang.method_48307(parentAllTooltip);
                }
            }
        }
        if (!Xloader.isDedicatedServer()) {
            tooltip = (String)tooltip + TooltipUtil.getClientOnlyTooltip();
        }
        return tooltip;
    }

    private static String getClientOnlyTooltip() {
        if (class_310.method_1551().field_1687 != null && !class_310.method_1551().method_1542()) {
            return "\n" + class_2477.method_10517().method_48307("vivecraft.messages.serversettingsnotavailablesingle");
        }
        return "";
    }
}

