/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.server;

import io.netty.channel.ChannelHandler;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.common.api_impl.VRAPIImpl;
import org.vivecraft.server.AimFixHandler;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerUtil;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin
extends ServerCommonPacketListenerImpl {
    @Shadow
    public ServerPlayer player;

    public ServerGamePacketListenerImplMixin(MinecraftServer server, Connection connection, CommonListenerCookie cookie) {
        super(server, connection, cookie);
    }

    @Inject(method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="TAIL")})
    private void vivecraft$addAimFix(CallbackInfo ci) {
        if (this.connection.channel != null && this.connection.channel.pipeline().get("packet_handler") != null) {
            this.connection.channel.pipeline().addBefore("packet_handler", "vr_aim_fix", (ChannelHandler)new AimFixHandler(this.connection));
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void vivecraft$sendVRPlayers(CallbackInfo ci) {
        ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(this.player);
        if (vivePlayer != null) {
            if (this.player.hasDisconnected()) {
                ServerVRPlayers.getPlayersWithVivecraft(this.player.server).remove(this.player.getUUID());
            } else if (vivePlayer.isVR() && vivePlayer.vrPlayerState() != null) {
                ServerNetworking.sendVrPlayerStateToClients(vivePlayer);
                if (((Boolean)ServerConfig.DEBUG_PARTICLES.get()).booleanValue()) {
                    ServerUtil.debugParticleAxes(vivePlayer);
                }
            }
        }
    }

    @Inject(method={"onDisconnect(Lnet/minecraft/network/DisconnectionDetails;)V"}, at={@At(value="TAIL")})
    private void vivecraft$doPlayerLeave(CallbackInfo ci) {
        String message;
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() && !(message = (String)ServerConfig.MESSAGES_LEAVE_MESSAGE.get()).isEmpty()) {
            this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)message.formatted(this.player.getScoreboardName())), false);
        }
        ServerVRPlayers.getPlayersWithVivecraft(this.server).remove(this.player.getUUID());
        VRAPIImpl.INSTANCE.clearPoseHistory(this.player.getUUID(), false);
    }
}

