/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.api.data;

import net.minecraft.class_1268;
import org.vivecraft.api.data.FBTMode;

public enum VRBodyPart {
    MAIN_HAND,
    OFF_HAND,
    RIGHT_FOOT,
    LEFT_FOOT,
    WAIST,
    RIGHT_KNEE,
    LEFT_KNEE,
    RIGHT_ELBOW,
    LEFT_ELBOW,
    HEAD;


    public VRBodyPart opposite() {
        return switch (this) {
            case MAIN_HAND -> OFF_HAND;
            case OFF_HAND -> MAIN_HAND;
            case RIGHT_FOOT -> LEFT_FOOT;
            case LEFT_FOOT -> RIGHT_FOOT;
            case RIGHT_KNEE -> LEFT_KNEE;
            case LEFT_KNEE -> RIGHT_KNEE;
            case RIGHT_ELBOW -> LEFT_ELBOW;
            case LEFT_ELBOW -> RIGHT_ELBOW;
            default -> this;
        };
    }

    public static VRBodyPart fromInteractionHand(class_1268 hand) {
        return hand == class_1268.field_5808 ? MAIN_HAND : OFF_HAND;
    }

    public boolean availableInMode(FBTMode fbtMode) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case MAIN_HAND, OFF_HAND, HEAD -> true;
            case RIGHT_FOOT, LEFT_FOOT, WAIST -> {
                if (fbtMode != FBTMode.ARMS_ONLY) {
                    yield true;
                }
                yield false;
            }
            case RIGHT_KNEE, LEFT_KNEE, RIGHT_ELBOW, LEFT_ELBOW -> fbtMode == FBTMode.WITH_JOINTS;
        };
    }

    public boolean isFoot() {
        return this == RIGHT_FOOT || this == LEFT_FOOT;
    }

    public boolean isHand() {
        return this == MAIN_HAND || this == OFF_HAND;
    }
}

