/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_310;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;

public class RunTracker
implements Tracker {
    private double direction = 0.0;
    private float speed = 0.0f;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public RunTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(class_746 player) {
        if (!this.dh.vrPlayer.getFreeMove() || this.dh.vrSettings.seated) {
            return false;
        }
        if (this.dh.vrSettings.getVrFreeMoveMode(false, this.dh.vrPlayer.vrdata_world_pre.fbtMode) != VRSettings.FreeMove.RUN_IN_PLACE) {
            return false;
        }
        if (player == null || !player.method_5805()) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (!player.method_24828() && (player.method_5799() || player.method_5771())) {
            return false;
        }
        if (player.method_6101()) {
            return false;
        }
        return !this.dh.bowTracker.isNotched();
    }

    public double getYaw() {
        return this.direction;
    }

    public double getSpeed() {
        return this.speed;
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.speed = 0.0f;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        float c0Move = this.dh.vr.controllerHistory[0].averageSpeed(0.33);
        float c1Move = this.dh.vr.controllerHistory[1].averageSpeed(0.33);
        if (this.speed > 0.0f) {
            if (c0Move < 0.1f && c1Move < 0.1f) {
                this.speed = 0.0f;
                return;
            }
        } else if (c0Move < 0.6f && c1Move < 0.6f) {
            this.speed = 0.0f;
            return;
        }
        if (Math.abs(c0Move - c1Move) > 0.5f) {
            this.speed = 0.0f;
            return;
        }
        Vector3f v = this.dh.vrPlayer.vrdata_world_pre.getController(0).getDirection().add((Vector3fc)this.dh.vrPlayer.vrdata_world_pre.getController(1).getDirection()).mul(0.5f);
        this.direction = Math.atan2(-v.x, v.z);
        float spd = (c0Move + c1Move) * 0.5f;
        this.speed = spd * 1.3f;
        if (this.speed > 0.1f) {
            this.speed = 1.0f;
        }
        if (this.speed > 1.0f) {
            this.speed = 1.3f;
        }
    }
}

