/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.utils;

public class RGBAColor {
    public float r;
    public float g;
    public float b;
    public float a;

    public RGBAColor() {
        this(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public RGBAColor(float red, float green, float blue, float alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
    }

    public RGBAColor(int red, int green, int blue, int alpha) {
        this.r = (float)red / 255.0f;
        this.g = (float)green / 255.0f;
        this.b = (float)blue / 255.0f;
        this.a = (float)alpha / 255.0f;
    }

    public RGBAColor(int value) {
        this(value & 0xFF, value >> 8 & 0xFF, value >> 16 & 0xFF, value >> 24 & 0xFF);
    }

    public int toIntEncoding() {
        return (int)(this.r * 255.0f) | (int)(this.g * 255.0f) << 8 | (int)(this.b * 255.0f) << 16 | (int)(this.a * 255.0f) << 24;
    }

    public int toIntEncodingARGB() {
        return (int)(this.b * 255.0f) | (int)(this.g * 255.0f) << 8 | (int)(this.r * 255.0f) << 16 | (int)(this.a * 255.0f) << 24;
    }

    public RGBAColor copy() {
        return new RGBAColor(this.r, this.g, this.b, this.a);
    }

    public void setRGB(float red, float green, float blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    public void setRGB(RGBAColor other) {
        this.r = other.r;
        this.g = other.g;
        this.b = other.b;
    }

    public static RGBAColor fromHSB(float hue, float saturation, float brightness) {
        RGBAColor color = new RGBAColor();
        if (saturation == 0.0f) {
            color.g = color.b = brightness;
            color.r = color.b;
        } else {
            float f = (hue - (float)Math.floor(hue)) * 6.0f;
            float f1 = f - (float)Math.floor(f);
            float f2 = brightness * (1.0f - saturation);
            float f3 = brightness * (1.0f - saturation * f1);
            float f4 = brightness * (1.0f - saturation * (1.0f - f1));
            switch ((int)f) {
                case 0: {
                    color.r = brightness;
                    color.g = f4;
                    color.b = f2;
                    break;
                }
                case 1: {
                    color.r = f3;
                    color.g = brightness;
                    color.b = f2;
                    break;
                }
                case 2: {
                    color.r = f2;
                    color.g = brightness;
                    color.b = f4;
                    break;
                }
                case 3: {
                    color.r = f2;
                    color.g = f3;
                    color.b = brightness;
                    break;
                }
                case 4: {
                    color.r = f4;
                    color.g = f2;
                    color.b = brightness;
                    break;
                }
                case 5: {
                    color.r = brightness;
                    color.g = f2;
                    color.b = f3;
                }
            }
        }
        return color;
    }
}

