/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.vivecraft.client_vr.utils.RGBAColor;

public class ColorPicker
extends AbstractWidget {
    private static final int HUE_WIDTH = 10;
    private float hue;
    private float saturation = 0.0f;
    private float brightness = 1.0f;
    private boolean clickedHue;

    public ColorPicker(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"Color Picker"));
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
        for (int i = 0; i < this.f_93619_ - 2; ++i) {
            RGBAColor color = RGBAColor.fromHSB((float)i / (float)(this.f_93619_ - 2), 1.0f, 1.0f);
            guiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + i + 1, this.m_252754_() + 10 - 1, this.m_252907_() + i + 2, color.toIntEncodingARGB());
        }
        for (int x = 10; x < this.f_93618_ - 2; ++x) {
            for (int y = 0; y < this.f_93619_ - 2; ++y) {
                RGBAColor color = RGBAColor.fromHSB(this.hue, (float)(x - 10) / (float)(this.f_93618_ - 10 - 2), 1.0f - (float)y / (float)(this.f_93619_ - 3));
                int xPos = this.m_252754_() + x + 1;
                int yPos = this.m_252907_() + y + 1;
                guiGraphics.m_280509_(xPos, yPos, xPos + 1, yPos + 1, color.toIntEncodingARGB());
            }
        }
        int satX = (int)((float)(this.m_252754_() + 10 + 1) + this.saturation * (float)(this.f_93618_ - 10 - 3));
        int satY = (int)((float)(this.m_252907_() + 1) + (1.0f - this.brightness) * (float)(this.f_93619_ - 3));
        guiGraphics.m_280637_(satX - 2, satY - 2, 5, 5, -1);
        int hueY = (int)((float)(this.m_252907_() + 1) + this.hue * (float)(this.f_93619_ - 3));
        guiGraphics.m_280637_(this.m_252754_(), hueY - 2, 10, 5, -1);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.clickedHue = mouseX < (double)(this.m_252754_() + 10);
        this.setColor(mouseX, mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.setColor(mouseX, mouseY);
    }

    private void setColor(double mouseX, double mouseY) {
        if (this.clickedHue) {
            this.hue = (float)Mth.m_14008_((double)((mouseY - (double)(this.m_252907_() + 1)) / (double)(this.f_93619_ - 2)), (double)0.0, (double)1.0);
        } else {
            this.brightness = 1.0f - (float)Mth.m_14008_((double)((mouseY - (double)this.m_252907_() - 1.0) / (double)(this.f_93619_ - 2)), (double)0.0, (double)1.0);
            this.saturation = (float)Mth.m_14008_((double)((mouseX - (double)this.m_252754_() - 10.0 - 1.0) / (double)(this.m_5711_() - 10 - 2)), (double)0.0, (double)1.0);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    public RGBAColor getColor() {
        return RGBAColor.fromHSB(this.hue, this.saturation, this.brightness);
    }

    public void setColor(RGBAColor color) {
        float max = Math.max(color.r, Math.max(color.g, color.b));
        float min = Math.min(color.r, Math.min(color.g, color.b));
        float dif = max - min;
        this.brightness = max;
        float f = this.saturation = max == 0.0f ? 0.0f : dif / max;
        if (dif == 0.0f) {
            this.hue = 0.0f;
            return;
        }
        this.hue = max == color.r ? (color.g - color.b) / dif : (max == color.g ? 2.0f + (color.b - color.r) / dif : 4.0f + (color.r - color.g) / dif);
        this.hue *= 60.0f;
        this.hue = (this.hue + 360.0f) % 360.0f / 360.0f;
    }
}

