/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.common.utils.MathUtils;

public class BackpackTracker
implements Tracker {
    public boolean[] wasIn = new boolean[2];
    public int previousSlot = 0;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public BackpackTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrSettings.backpackSwitching) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        return !this.dh.bowTracker.isDrawing();
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        VRPlayer provider = this.dh.vrPlayer;
        Vec3 hmdPos = provider.vrdata_room_pre.getHeadRear();
        for (int c = 0; c < 2; ++c) {
            boolean zone;
            Vec3 controllerPos = provider.vrdata_room_pre.getController(c).getPosition();
            Vector3f controllerDir = provider.vrdata_room_pre.getHand(c).getDirection();
            Vector3f hmdDir = provider.vrdata_room_pre.hmd.getDirection();
            Vector3f delta = MathUtils.subtractToVector3f(hmdPos, controllerPos);
            double dot = controllerDir.dot(MathUtils.DOWN);
            double dotDelta = delta.dot((Vector3fc)hmdDir);
            boolean below = Math.abs(hmdPos.f_82480_ - controllerPos.f_82480_) < 0.25;
            boolean behind = dotDelta > 0.0 && (double)delta.length() > 0.05;
            boolean aimDown = dot > 0.6;
            boolean infront = dotDelta < 0.0 && (double)delta.length() > 0.25;
            boolean aimUp = dot < 0.0;
            boolean bl = zone = below && behind && aimDown;
            if (zone) {
                if (this.wasIn[c]) continue;
                if (c == 0) {
                    if (!this.dh.climbTracker.isGrabbingLadder() || !ClimbTracker.isClaws(this.mc.f_91074_.m_21205_())) {
                        if (player.m_150109_().f_35977_ != 0) {
                            this.previousSlot = player.m_150109_().f_35977_;
                            player.m_150109_().f_35977_ = 0;
                        } else {
                            player.m_150109_().f_35977_ = this.previousSlot;
                            this.previousSlot = 0;
                        }
                    }
                } else if (!(this.dh.climbTracker.isGrabbingLadder() && ClimbTracker.isClaws(this.mc.f_91074_.m_21206_()) || this.dh.vrSettings.physicalGuiEnabled)) {
                    player.f_108617_.m_295327_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
                }
                this.dh.vr.triggerHapticPulse(c, 1500);
                this.wasIn[c] = true;
                continue;
            }
            if (!infront && !aimUp) continue;
            this.wasIn[c] = false;
        }
    }
}

