/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.MinecraftExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.ShaderHelper;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class VRPassHelper {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();

    public static void renderSingleView(RenderPass eye, float partialTick, long nanoTime, boolean renderLevel) {
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        VRPassHelper.MC.f_91063_.m_109093_(partialTick, nanoTime, renderLevel);
        RenderHelper.checkGLError("post game render " + eye);
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.LEFT || VRPassHelper.DATA_HOLDER.currentPass == RenderPass.RIGHT) {
            MC.m_91307_().m_6180_("postProcessEye");
            RenderTarget rendertarget = MC.m_91385_();
            if (VRPassHelper.DATA_HOLDER.vrSettings.useFsaa) {
                MC.m_91307_().m_6180_("fsaa");
                ShaderHelper.doFSAA(VRPassHelper.DATA_HOLDER.vrRenderer.framebufferVrRender, VRPassHelper.DATA_HOLDER.vrRenderer.fsaaFirstPassResultFBO, VRPassHelper.DATA_HOLDER.vrRenderer.fsaaLastPassResultFBO);
                rendertarget = VRPassHelper.DATA_HOLDER.vrRenderer.fsaaLastPassResultFBO;
                RenderHelper.checkGLError("fsaa " + eye);
                MC.m_91307_().m_7238_();
            }
            if (eye == RenderPass.LEFT) {
                VRPassHelper.DATA_HOLDER.vrRenderer.framebufferEye0.m_83947_(true);
            } else {
                VRPassHelper.DATA_HOLDER.vrRenderer.framebufferEye1.m_83947_(true);
            }
            ShaderHelper.doVrPostProcess(eye, rendertarget, partialTick);
            RenderHelper.checkGLError("post overlay" + eye);
            MC.m_91307_().m_7238_();
        }
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.CAMERA) {
            MC.m_91307_().m_6180_("cameraCopy");
            VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.m_83947_(true);
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
            VRPassHelper.DATA_HOLDER.vrRenderer.cameraRenderFramebuffer.m_83938_(VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.f_83917_, VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.f_83918_);
            MC.m_91307_().m_7238_();
        }
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.THIRD && VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY && renderLevel && VRPassHelper.MC.f_91073_ != null && OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.copyOptifineShaderDepth(VRPassHelper.DATA_HOLDER.vrRenderer.framebufferMR);
        }
    }

    public static void renderAndSubmit(boolean renderLevel, long nanoTime, float actualPartialTick) {
        Object guiProjection;
        MC.m_91307_().m_6180_("gameRenderer");
        MC.m_91307_().m_6180_("VR guis");
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        GuiGraphics guiGraphics = new GuiGraphics(MC, MC.m_91269_().m_110104_());
        MC.m_91307_().m_6180_("gui cursor");
        if (VRPassHelper.MC.f_91080_ != null || !VRPassHelper.MC.f_91067_.m_91600_()) {
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.m_85836_();
            poseStack.m_166856_();
            poseStack.m_252880_(0.0f, 0.0f, -11000.0f);
            RenderSystem.applyModelViewMatrix();
            guiProjection = new Matrix4f().setOrtho(0.0f, (float)MC.m_91268_().m_85445_(), (float)MC.m_91268_().m_85446_(), 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)guiProjection, (VertexSorting)VertexSorting.f_276633_);
            int x = (int)(VRPassHelper.MC.f_91067_.m_91589_() * (double)MC.m_91268_().m_85445_() / (double)MC.m_91268_().m_85443_());
            int y = (int)(VRPassHelper.MC.f_91067_.m_91594_() * (double)MC.m_91268_().m_85446_() / (double)MC.m_91268_().m_85444_());
            RenderHelper.drawMouseMenuQuad(guiGraphics, x, y);
            guiGraphics.m_280262_();
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
        MC.m_91307_().m_6182_("fps pie");
        ((MinecraftExtension)MC).vivecraft$drawProfiler();
        if (!RenderSystem.getModelViewStack().m_85851_()) {
            RenderSystem.getModelViewStack().m_85849_();
        }
        RenderSystem.applyModelViewMatrix();
        if (VRPassHelper.DATA_HOLDER.vrSettings.guiMipmaps) {
            OpenGLHelper.genMipmaps(VRPassHelper.MC.f_91042_);
        }
        MC.m_91307_().m_6182_("2D Keyboard");
        if (KeyboardHandler.SHOWING && !VRPassHelper.DATA_HOLDER.vrSettings.physicalKeyboard) {
            VRPassHelper.MC.f_91042_ = KeyboardHandler.FRAMEBUFFER;
            VRPassHelper.MC.f_91042_.m_83954_(Minecraft.f_91002_);
            VRPassHelper.MC.f_91042_.m_83947_(true);
            RenderHelper.drawScreen(guiGraphics, actualPartialTick, KeyboardHandler.UI, true);
        }
        MC.m_91307_().m_6182_("Radial Menu");
        if (RadialHandler.isShowing()) {
            VRPassHelper.MC.f_91042_ = RadialHandler.FRAMEBUFFER;
            VRPassHelper.MC.f_91042_.m_83954_(Minecraft.f_91002_);
            VRPassHelper.MC.f_91042_.m_83947_(true);
            RenderHelper.drawScreen(guiGraphics, actualPartialTick, RadialHandler.UI, true);
        }
        MC.m_91307_().m_7238_();
        RenderHelper.checkGLError("post 2d ");
        MC.m_91307_().m_7238_();
        List<RenderPass> list = VRPassHelper.DATA_HOLDER.vrRenderer.getRenderPasses(false);
        VRPassHelper.DATA_HOLDER.isFirstPass = true;
        guiProjection = list.iterator();
        while (guiProjection.hasNext()) {
            RenderPass renderpass;
            VRPassHelper.DATA_HOLDER.currentPass = renderpass = (RenderPass)((Object)guiProjection.next());
            if (VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && VRPassHelper.DATA_HOLDER.cameraTracker.isVisible() && (renderpass == RenderPass.CENTER || renderpass == RenderPass.THIRD && VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.MIXED_REALITY)) continue;
            switch (renderpass) {
                case LEFT: 
                case RIGHT: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.STEREO_XR);
                    break;
                }
                case CENTER: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.CENTER);
                    break;
                }
                case THIRD: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.MIXED_REALITY);
                    break;
                }
                case SCOPEL: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.LEFT_TELESCOPE);
                    break;
                }
                case SCOPER: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.RIGHT_TELESCOPE);
                    break;
                }
                case CAMERA: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.CAMERA);
                }
            }
            MC.m_91307_().m_6180_("Eye:" + VRPassHelper.DATA_HOLDER.currentPass);
            MC.m_91307_().m_6180_("setup");
            VRPassHelper.MC.f_91042_.m_83947_(true);
            MC.m_91307_().m_7238_();
            VRPassHelper.renderSingleView(renderpass, actualPartialTick, nanoTime, renderLevel);
            MC.m_91307_().m_7238_();
            if (VRPassHelper.DATA_HOLDER.grabScreenShot) {
                boolean flag;
                if (list.contains((Object)RenderPass.CAMERA)) {
                    flag = renderpass == RenderPass.CAMERA;
                } else if (list.contains((Object)RenderPass.CENTER)) {
                    flag = renderpass == RenderPass.CENTER;
                } else {
                    boolean bl = VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? renderpass == RenderPass.LEFT : (flag = renderpass == RenderPass.RIGHT);
                }
                if (flag) {
                    RenderTarget rendertarget = VRPassHelper.MC.f_91042_;
                    if (renderpass == RenderPass.CAMERA) {
                        rendertarget = VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                    }
                    VRPassHelper.MC.f_91042_.m_83970_();
                    ClientUtils.takeScreenshot(rendertarget);
                    MC.m_91268_().m_85435_();
                    VRPassHelper.DATA_HOLDER.grabScreenShot = false;
                }
            }
            VRPassHelper.DATA_HOLDER.isFirstPass = false;
        }
        MC.m_91307_().m_7238_();
        VRPassHelper.DATA_HOLDER.vrPlayer.postRender(actualPartialTick);
        MC.m_91307_().m_6180_("Display/Reproject");
        try {
            VRPassHelper.DATA_HOLDER.vrRenderer.endFrame();
        }
        catch (RenderConfigException exception) {
            VRSettings.LOGGER.error("Vivecraft: error ending frame: {}", (Object)exception.error.getString());
        }
        MC.m_91307_().m_7238_();
        RenderHelper.checkGLError("post submit");
    }
}

