/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.fabric;

import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.vivecraft.Xloader;
import org.vivecraft.common.utils.ClassUtils;

public class XloaderImpl
implements Xloader {
    private static Xloader.ModLoader CURRENT_MODLOADER = null;

    public static Xloader.ModLoader getModloader() {
        if (CURRENT_MODLOADER == null) {
            try {
                ClassUtils.getClassWithAlternative("org.quiltmc.loader.api.QuiltLoader", "org.quiltmc.loader.impl.QuiltLoaderImpl");
                CURRENT_MODLOADER = Xloader.ModLoader.QUILT;
            }
            catch (ClassNotFoundException e) {
                CURRENT_MODLOADER = Xloader.ModLoader.FABRIC;
            }
        }
        return CURRENT_MODLOADER;
    }

    public static boolean isModLoaded(String name) {
        return FabricLoader.getInstance().isModLoaded(name);
    }

    public static String getModVersion() {
        if (Xloader.isModLoadedSuccess()) {
            return ((ModContainer)FabricLoader.getInstance().getModContainer("vivecraft").get()).getMetadata().getVersion().getFriendlyString();
        }
        return "no version";
    }

    public static Path getConfigPath(String fileName) {
        return FabricLoader.getInstance().getConfigDir().resolve(fileName);
    }

    public static Path getJarPath() {
        return (Path)((ModContainer)FabricLoader.getInstance().getModContainer("vivecraft").get()).getRootPaths().get(0);
    }

    public static boolean isDedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER);
    }
}

