/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

public class AimFixHandler
extends ChannelInboundHandlerAdapter {
    private final Connection netManager;

    public AimFixHandler(Connection netManager) {
        this.netManager = netManager;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        boolean isCapturedPacket;
        ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)this.netManager.getPacketListener();
        ServerPlayer serverPlayer = listener.player;
        boolean bl = isCapturedPacket = msg instanceof ServerboundUseItemPacket || msg instanceof ServerboundUseItemOnPacket || msg instanceof ServerboundPlayerActionPacket;
        if (!ServerVRPlayers.isVRPlayer(serverPlayer) || !isCapturedPacket || serverPlayer.getServer() == null) {
            ctx.fireChannelRead(msg);
            return;
        }
        serverPlayer.getServer().submit(() -> {
            Vec3 aimPos;
            ServerVivePlayer vivePlayer;
            float eyeHeight;
            float prevYHeadRot;
            float prevYRot;
            float prevXRot;
            float yHeadRot;
            float yRot;
            float xRot;
            Vec3 prevPos;
            Vec3 pos;
            block11: {
                pos = serverPlayer.position();
                prevPos = new Vec3(serverPlayer.xo, serverPlayer.yo, serverPlayer.zo);
                xRot = serverPlayer.getXRot();
                yRot = serverPlayer.getYRot();
                yHeadRot = serverPlayer.yHeadRot;
                prevXRot = serverPlayer.xRotO;
                prevYRot = serverPlayer.yRotO;
                prevYHeadRot = serverPlayer.yHeadRotO;
                eyeHeight = serverPlayer.getEyeHeight();
                vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                aimPos = null;
                if (vivePlayer != null && vivePlayer.isVR()) {
                    aimPos = vivePlayer.getAimPos(false);
                    Vec3 dir = vivePlayer.getAimDir(false);
                    serverPlayer.setPosRaw(aimPos.x, aimPos.y, aimPos.z);
                    serverPlayer.xo = aimPos.x;
                    serverPlayer.yo = aimPos.y;
                    serverPlayer.zo = aimPos.z;
                    serverPlayer.setXRot((float)Math.toDegrees(Math.asin(-dir.y)));
                    serverPlayer.setYRot((float)Math.toDegrees(Math.atan2(-dir.x, dir.z)));
                    serverPlayer.xRotO = serverPlayer.getXRot();
                    serverPlayer.yHeadRotO = serverPlayer.yHeadRot = serverPlayer.getYRot();
                    serverPlayer.yRotO = serverPlayer.yHeadRot;
                    serverPlayer.eyeHeight = 1.0E-4f;
                    vivePlayer.offset = pos.subtract(aimPos);
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: AimFix: {} {} {}, {} {}", new Object[]{aimPos.x, aimPos.y, aimPos.z, Float.valueOf(serverPlayer.getXRot()), Float.valueOf(serverPlayer.getYRot())});
                    }
                }
                try {
                    if (!this.netManager.isConnected()) break block11;
                    try {
                        if (msg instanceof ServerboundUseItemPacket) {
                            ServerboundUseItemPacket p = (ServerboundUseItemPacket)msg;
                            new ServerboundUseItemPacket(p.getHand(), p.getSequence(), serverPlayer.getYRot(), serverPlayer.getXRot()).handle((ServerGamePacketListener)listener);
                            break block11;
                        }
                        ((Packet)msg).handle(this.netManager.getPacketListener());
                    }
                    catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                        // empty catch block
                    }
                }
                finally {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
            if (aimPos != null && !serverPlayer.position().equals((Object)aimPos) || aimPos == null && !serverPlayer.position().equals((Object)pos)) {
                pos = serverPlayer.position();
                if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                    ServerNetworking.LOGGER.info("Vivecraft: AimFix moved Player to: {} {} {}", new Object[]{pos.x, pos.y, pos.z});
                }
            }
            serverPlayer.setPosRaw(pos.x, pos.y, pos.z);
            serverPlayer.xo = prevPos.x;
            serverPlayer.yo = prevPos.y;
            serverPlayer.zo = prevPos.z;
            serverPlayer.setXRot(xRot);
            serverPlayer.setYRot(yRot);
            serverPlayer.yHeadRot = yHeadRot;
            serverPlayer.xRotO = prevXRot;
            serverPlayer.yRotO = prevYRot;
            serverPlayer.yHeadRotO = prevYHeadRot;
            serverPlayer.eyeHeight = eyeHeight;
            if (vivePlayer != null) {
                vivePlayer.offset = Vec3.ZERO;
            }
        });
    }
}

