/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.iris;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.irisshaders.iris.api.v0.IrisApi;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.vivecraft.Xloader;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.common.utils.ClassUtils;

public class IrisHelper {
    private static boolean INITIALIZED = false;
    private static boolean INIT_FAILED = false;
    private static Method Iris_reload;
    private static Method Iris_getPipelineManager;
    private static Method PipelineManager_getPipeline;
    private static Method WorldRenderingPipeline_shouldRenderUnderwaterOverlay;
    private static Class IrisRenderingPipeline;
    private static Field IrisRenderingPipeline_shaderStorageBufferHolder;
    private static Method ShaderStorageBufferHolder_setupBuffers;
    private static RenderPass lastSSBOPass;
    private static boolean DH_PRESENT;
    private static Object dhOverrideInjector;
    private static Method OverrideInjector_unbind;
    private static Class<?> IDhApiFramebuffer;
    private static Method Pipeline_getDHCompat;
    private static Method DHCompatInternal_getInstance;
    private static Method DHCompatInternal_getShadowFBWrapper;
    private static Method DHCompatInternal_getSolidFBWrapper;
    private static Class<?> IDhApiGenericObjectShaderProgram;
    private static Method DHCompatInternal_getGenericShader;
    private static Method CapturedRenderingState_getGbufferProjection;
    private static Method WorldRenderingSettings_setUseExtendedVertexFormat;
    private static Method WorldRenderingSettings_shouldUseExtendedVertexFormat;
    private static Object WorldRenderingSettings_INSTANCE;
    public static boolean SLOW_MODE;

    public static boolean isLoaded() {
        return Xloader.isModLoaded("iris") || Xloader.isModLoaded("oculus");
    }

    public static boolean isShaderActive() {
        try {
            return IrisApi.getInstance().isShaderPackInUse() || WorldRenderingSettings_shouldUseExtendedVertexFormat != null && (Boolean)WorldRenderingSettings_shouldUseExtendedVertexFormat.invoke(WorldRenderingSettings_INSTANCE, new Object[0]) != false;
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return false;
        }
    }

    public static boolean isRenderingShadows() {
        return IrisApi.getInstance().isRenderingShadowPass();
    }

    public static void setShadersActive(boolean enabled) {
        IrisApi.getInstance().getConfig().setShadersEnabledAndApply(enabled);
        if (!enabled && IrisHelper.hasIssuesWithMenuWorld()) {
            try {
                WorldRenderingSettings_setUseExtendedVertexFormat.invoke(WorldRenderingSettings_INSTANCE, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.LOGGER.error("Vivecraft: error disabling Iris shaders:", (Throwable)e);
            }
        }
    }

    public static boolean hasIssuesWithMenuWorld() {
        return IrisHelper.init() && WorldRenderingSettings_setUseExtendedVertexFormat != null;
    }

    public static void reload() {
        RenderPassManager.setVanillaRenderPass();
        if (IrisHelper.init()) {
            try {
                Iris_reload.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                VRSettings.LOGGER.error("Vivecraft: Error reloading Iris shaders on Frame Buffer reinit:", (Throwable)e);
            }
        }
    }

    public static boolean hasWaterEffect() {
        if (IrisHelper.init()) {
            try {
                return (Boolean)((Optional)PipelineManager_getPipeline.invoke(Iris_getPipelineManager.invoke(null, new Object[0]), new Object[0])).map(o -> {
                    try {
                        return WorldRenderingPipeline_shouldRenderUnderwaterOverlay.invoke(o, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        VRSettings.LOGGER.error("Vivecraft: Iris water effect check failed:", (Throwable)e);
                        return true;
                    }
                }).orElse(true);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.LOGGER.error("Vivecraft: Iris water effect check failed:", (Throwable)e);
            }
        }
        return true;
    }

    public static void unregisterDHIfThere(Object pipeline) {
        if (IrisHelper.init() && DH_PRESENT) {
            try {
                Object dhCompatInstance;
                Object dhCompat = Pipeline_getDHCompat.invoke(pipeline, new Object[0]);
                if (dhCompat != null && (dhCompatInstance = DHCompatInternal_getInstance.invoke(dhCompat, new Object[0])) != null) {
                    OverrideInjector_unbind.invoke(dhOverrideInjector, IDhApiFramebuffer, DHCompatInternal_getShadowFBWrapper.invoke(dhCompatInstance, new Object[0]));
                    OverrideInjector_unbind.invoke(dhOverrideInjector, IDhApiFramebuffer, DHCompatInternal_getSolidFBWrapper.invoke(dhCompatInstance, new Object[0]));
                    if (DHCompatInternal_getGenericShader != null) {
                        OverrideInjector_unbind.invoke(dhOverrideInjector, IDhApiGenericObjectShaderProgram, DHCompatInternal_getGenericShader.invoke(dhCompatInstance, new Object[0]));
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.LOGGER.error("Vivecraft: Iris DH reset failed", (Throwable)e);
            }
        }
    }

    public static Matrix4fc getGbufferProjection(Object source) {
        if (IrisHelper.init() && DH_PRESENT) {
            try {
                return (Matrix4fc)CapturedRenderingState_getGbufferProjection.invoke(source, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.LOGGER.error("Vivecraft: couldn't get iris gbuffer projection matrix:", (Throwable)e);
            }
        }
        return new Matrix4f();
    }

    public static void swapSSBOs(Object newPipeline, RenderPass newPass) {
        if (IrisHelper.init() && IrisRenderingPipeline_shaderStorageBufferHolder != null && ShaderStorageBufferHolder_setupBuffers != null && IrisRenderingPipeline != null && IrisRenderingPipeline.isInstance(newPipeline) && newPass != lastSSBOPass) {
            try {
                Object ssbos = IrisRenderingPipeline_shaderStorageBufferHolder.get(newPipeline);
                if (ssbos != null) {
                    ShaderStorageBufferHolder_setupBuffers.invoke(ssbos, new Object[0]);
                }
                lastSSBOPass = newPass;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.LOGGER.error("Vivecraft: couldn't swap iris ssbos:", (Throwable)e);
            }
        }
    }

    private static boolean init() {
        block11: {
            if (INITIALIZED) {
                return !INIT_FAILED;
            }
            try {
                Class<?> iris = ClassUtils.getClassWithAlternative("net.coderbot.iris.Iris", "net.irisshaders.iris.Iris");
                Iris_reload = iris.getMethod("reload", new Class[0]);
                Iris_getPipelineManager = iris.getMethod("getPipelineManager", new Class[0]);
                Class<?> pipelineManager = ClassUtils.getClassWithAlternative("net.coderbot.iris.pipeline.PipelineManager", "net.irisshaders.iris.pipeline.PipelineManager");
                PipelineManager_getPipeline = pipelineManager.getMethod("getPipeline", new Class[0]);
                Class<?> worldRenderingPipeline = ClassUtils.getClassWithAlternative("net.coderbot.iris.pipeline.WorldRenderingPipeline", "net.irisshaders.iris.pipeline.WorldRenderingPipeline");
                WorldRenderingPipeline_shouldRenderUnderwaterOverlay = worldRenderingPipeline.getMethod("shouldRenderUnderwaterOverlay", new Class[0]);
                try {
                    Class<?> WorldRenderingSettings = Class.forName("net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings");
                    WorldRenderingSettings_setUseExtendedVertexFormat = WorldRenderingSettings.getMethod("setUseExtendedVertexFormat", Boolean.TYPE);
                    WorldRenderingSettings_shouldUseExtendedVertexFormat = WorldRenderingSettings.getMethod("shouldUseExtendedVertexFormat", new Class[0]);
                    WorldRenderingSettings_INSTANCE = WorldRenderingSettings.getField("INSTANCE").get(null);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException WorldRenderingSettings) {
                    // empty catch block
                }
                try {
                    IrisRenderingPipeline = ClassUtils.getClassWithAlternative("net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline", "net.irisshaders.iris.pipeline.IrisRenderingPipeline");
                    IrisRenderingPipeline_shaderStorageBufferHolder = IrisRenderingPipeline.getDeclaredField("shaderStorageBufferHolder");
                    IrisRenderingPipeline_shaderStorageBufferHolder.setAccessible(true);
                    Class<?> shaderStorageBufferHolder = ClassUtils.getClassWithAlternative("net.coderbot.iris.gl.buffer.ShaderStorageBufferHolder", "net.irisshaders.iris.gl.buffer.ShaderStorageBufferHolder");
                    ShaderStorageBufferHolder_setupBuffers = shaderStorageBufferHolder.getMethod("setupBuffers", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
                    VRSettings.LOGGER.info("Vivecraft: iris has no SSBO support");
                }
                if (!Xloader.isModLoaded("distanthorizons")) break block11;
                try {
                    Class<?> OverrideInjector = Class.forName("com.seibel.distanthorizons.coreapi.DependencyInjection.OverrideInjector");
                    dhOverrideInjector = OverrideInjector.getDeclaredField("INSTANCE").get(null);
                    OverrideInjector_unbind = OverrideInjector.getMethod("unbind", Class.class, Class.forName("com.seibel.distanthorizons.api.interfaces.override.IDhApiOverrideable"));
                    IDhApiFramebuffer = Class.forName("com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiFramebuffer");
                    Pipeline_getDHCompat = Class.forName("net.irisshaders.iris.pipeline.WorldRenderingPipeline").getMethod("getDHCompat", new Class[0]);
                    DHCompatInternal_getInstance = Class.forName("net.irisshaders.iris.compat.dh.DHCompat").getMethod("getInstance", new Class[0]);
                    Class<?> DHCompatInternal = Class.forName("net.irisshaders.iris.compat.dh.DHCompatInternal");
                    DHCompatInternal_getShadowFBWrapper = DHCompatInternal.getMethod("getShadowFBWrapper", new Class[0]);
                    DHCompatInternal_getSolidFBWrapper = DHCompatInternal.getMethod("getSolidFBWrapper", new Class[0]);
                    try {
                        IDhApiGenericObjectShaderProgram = Class.forName("com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiGenericObjectShaderProgram");
                        DHCompatInternal_getGenericShader = DHCompatInternal.getMethod("getGenericShader", new Class[0]);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                        // empty catch block
                    }
                    Class<?> CapturedRenderingState = Class.forName("net.irisshaders.iris.uniforms.CapturedRenderingState");
                    CapturedRenderingState_getGbufferProjection = CapturedRenderingState.getMethod("getGbufferProjection", new Class[0]);
                    DH_PRESENT = true;
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                    VRSettings.LOGGER.error("Vivecraft: DH present but compat init failed:", (Throwable)e);
                    DH_PRESENT = false;
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                INIT_FAILED = true;
                VRSettings.LOGGER.error("Vivecraft: Failed to initialize Iris compat", (Throwable)e);
            }
        }
        INITIALIZED = true;
        return !INIT_FAILED;
    }

    static {
        DH_PRESENT = false;
        SLOW_MODE = false;
    }
}

