/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.mixin.world.entity.LivingEntityMixin;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntityMixin {
    @Shadow
    @Final
    public InventoryMenu inventoryMenu;

    @Shadow
    public abstract Inventory getInventory();

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract ItemCooldowns getCooldowns();

    public PlayerMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"sweepAttack()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I")})
    protected int vivecraft$modifySweepParticleSpawnPos(ServerLevel instance, ParticleOptions type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, Operation<Integer> original) {
        return (Integer)original.call(new Object[]{instance, type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed});
    }

    @ModifyArg(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurtOrSimulate(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    protected float vivecraft$damageModifier(float damage) {
        return damage;
    }

    @WrapMethod(method={"hurtCurrentlyUsedShield(F)V"})
    protected void vivecraft$roomscaleShieldItemDamage(float damageAmount, Operation<Void> original) {
        original.call(new Object[]{Float.valueOf(damageAmount)});
    }

    @ModifyExpressionValue(method={"hurtCurrentlyUsedShield(F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getUsedItemHand()Lnet/minecraft/world/InteractionHand;")})
    protected InteractionHand vivecraft$roomscaleShieldHand(InteractionHand original) {
        return original;
    }

    @ModifyVariable(method={"setItemSlot(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private EquipmentSlot vivecraft$setOffhand(EquipmentSlot equipmentSlot) {
        PlayerMixin playerMixin = this;
        if (playerMixin instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerMixin;
            if (((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue() && ServerVRPlayers.isVRPlayer(serverPlayer)) {
                ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                if (vivePlayer.networkVersion >= 2 && vivePlayer.activeBodyPart == VRBodyPart.OFF_HAND) {
                    equipmentSlot = EquipmentSlot.OFFHAND;
                }
            }
        }
        return equipmentSlot;
    }
}

