/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render.armor;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.entity.EquipmentSlot;
import org.vivecraft.client.render.armor.VRArmorModel_WithArms;
import org.vivecraft.client.render.armor.VRArmorModel_WithArmsLegs;

public class VRArmorLayer<S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>>
extends HumanoidArmorLayer<S, M, A> {
    public static LayerDefinition VR_ARMOR_DEF_ARMS_INNER;
    public static LayerDefinition VR_ARMOR_DEF_ARMS_OUTER;
    public static LayerDefinition VR_ARMOR_DEF_ARMS_LEGS_INNER;
    public static LayerDefinition VR_ARMOR_DEF_ARMS_LEGS_OUTER;

    public static void createLayers() {
        VR_ARMOR_DEF_ARMS_INNER = LayerDefinition.create((MeshDefinition)VRArmorModel_WithArms.createBodyLayer(new CubeDeformation(0.5f)), (int)64, (int)32);
        VR_ARMOR_DEF_ARMS_OUTER = LayerDefinition.create((MeshDefinition)VRArmorModel_WithArms.createBodyLayer(new CubeDeformation(1.0f)), (int)64, (int)32);
        VR_ARMOR_DEF_ARMS_LEGS_INNER = LayerDefinition.create((MeshDefinition)VRArmorModel_WithArmsLegs.createBodyLayer(new CubeDeformation(0.5f)), (int)64, (int)32);
        VR_ARMOR_DEF_ARMS_LEGS_OUTER = LayerDefinition.create((MeshDefinition)VRArmorModel_WithArmsLegs.createBodyLayer(new CubeDeformation(1.0f)), (int)64, (int)32);
    }

    public VRArmorLayer(RenderLayerParent<S, M> renderer, A innerModel, A outerModel, EquipmentLayerRenderer equipmentRenderer) {
        super(renderer, innerModel, outerModel, equipmentRenderer);
    }

    protected void setPartVisibility(A model, EquipmentSlot slot) {
        super.setPartVisibility(model, slot);
        switch (slot) {
            case CHEST: {
                if (!(model instanceof VRArmorModel_WithArms)) break;
                VRArmorModel_WithArms armsModel = (VRArmorModel_WithArms)model;
                armsModel.leftHand.visible = true;
                armsModel.rightHand.visible = true;
                break;
            }
            case LEGS: {
                if (!(model instanceof VRArmorModel_WithArmsLegs)) break;
                VRArmorModel_WithArmsLegs legsModel = (VRArmorModel_WithArmsLegs)model;
                legsModel.leftFoot.visible = true;
                legsModel.rightFoot.visible = true;
                break;
            }
            case FEET: {
                if (!(model instanceof VRArmorModel_WithArmsLegs)) break;
                VRArmorModel_WithArmsLegs legsModel = (VRArmorModel_WithArmsLegs)model;
                legsModel.leftLeg.visible = false;
                legsModel.rightLeg.visible = false;
                legsModel.leftFoot.visible = true;
                legsModel.rightFoot.visible = true;
            }
        }
    }

    static {
        VRArmorLayer.createLayers();
    }
}

