/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.TwoHandedScreen;
import org.vivecraft.client_vr.provider.InputSimulator;

public class GuiKeyboard
extends TwoHandedScreen {
    private boolean isShift = false;

    public void init() {
        String keys = this.dh.vrSettings.keyboardKeys;
        String shiftKeys = this.dh.vrSettings.keyboardKeysShift;
        this.clearWidgets();
        if (this.isShift) {
            keys = shiftKeys;
        }
        int columns = 13;
        int margin = 32;
        int spacing = 2;
        int buttonWidth = 25;
        double rowsD = (double)keys.length() / (double)columns;
        int rows = Math.floor(rowsD) == rowsD ? (int)rowsD : (int)(rowsD + 1.0);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int index = row * columns + column;
                char buttonChar = ' ';
                if (index < keys.length()) {
                    buttonChar = keys.charAt(index);
                }
                String label = String.valueOf(buttonChar);
                int code = index < this.dh.vrSettings.keyboardCodes.length ? this.dh.vrSettings.keyboardCodes[index] : -1;
                this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)label), p -> {
                    InputSimulator.pressKeyForBind(code);
                    InputSimulator.releaseKeyForBind(code);
                    InputSimulator.typeChars(label);
                }).size(buttonWidth, 20).pos(margin + column * (buttonWidth + spacing), margin + row * (20 + spacing)).build());
            }
        }
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"Shift"), p -> this.setShift(!this.isShift)).size(30, 20).pos(0, margin + 3 * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)" "), p -> {
            InputSimulator.pressKeyForBind(32);
            InputSimulator.releaseKeyForBind(32);
            InputSimulator.typeChars(" ");
        }).size(5 * (buttonWidth + spacing), 20).pos(margin + 4 * (buttonWidth + spacing), margin + rows * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"BKSP"), p -> {
            InputSimulator.pressKey(259);
            InputSimulator.releaseKey(259);
        }).size(35, 20).pos(columns * (buttonWidth + spacing) + margin, margin).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"ENTER"), p -> {
            InputSimulator.pressKey(257);
            InputSimulator.releaseKey(257);
        }).size(35, 20).pos(columns * (buttonWidth + spacing) + margin, margin + 2 * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"TAB"), p -> {
            InputSimulator.pressKey(258);
            InputSimulator.releaseKey(258);
        }).size(30, 20).pos(0, margin + 20 + spacing).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"ESC"), p -> {
            InputSimulator.pressKey(256);
            InputSimulator.releaseKey(256);
        }).size(30, 20).pos(0, margin).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\u2191"), p -> {
            InputSimulator.pressKey(265);
            InputSimulator.releaseKey(265);
        }).size(buttonWidth, 20).pos((columns - 1) * (buttonWidth + spacing) + margin, margin + rows * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\u2193"), p -> {
            InputSimulator.pressKey(264);
            InputSimulator.releaseKey(264);
        }).size(buttonWidth, 20).pos((columns - 1) * (buttonWidth + spacing) + margin, margin + (rows + 1) * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\u2190"), p -> {
            InputSimulator.pressKey(263);
            InputSimulator.releaseKey(263);
        }).size(buttonWidth, 20).pos((columns - 2) * (buttonWidth + spacing) + margin, margin + (rows + 1) * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\u2192"), p -> {
            InputSimulator.pressKey(262);
            InputSimulator.releaseKey(262);
        }).size(buttonWidth, 20).pos(columns * (buttonWidth + spacing) + margin, margin + (rows + 1) * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"CUT"), p -> {
            InputSimulator.pressKey(341);
            InputSimulator.pressKey(88);
            InputSimulator.releaseKey(88);
            InputSimulator.releaseKey(341);
        }).size(35, 20).pos(margin, margin + -1 * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"COPY"), p -> {
            InputSimulator.pressKey(341);
            InputSimulator.pressKey(67);
            InputSimulator.releaseKey(67);
            InputSimulator.releaseKey(341);
        }).size(35, 20).pos(35 + spacing + margin, margin + -1 * (20 + spacing)).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"PASTE"), p -> {
            InputSimulator.pressKey(341);
            InputSimulator.pressKey(86);
            InputSimulator.releaseKey(86);
            InputSimulator.releaseKey(341);
        }).size(35, 20).pos(2 * (35 + spacing) + margin, margin + -1 * (20 + spacing)).build());
    }

    public void setShift(boolean shift) {
        if (shift != this.isShift) {
            this.isShift = shift;
            this.reinit = true;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, "Keyboard", this.width / 2, 2, -1);
        super.render(guiGraphics, 0, 0, partialTick);
    }
}

