/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.Profiler;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.helpers.GuiRenderHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.ShaderHelper;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class VRPassHelper {
    private static final Minecraft MC = Minecraft.getInstance();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();

    public static void renderSingleView(RenderPass eye, DeltaTracker.Timer deltaTracker, boolean renderLevel) {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(MC.getMainRenderTarget().getColorTexture(), -16777216, MC.getMainRenderTarget().getDepthTexture(), 1.0);
        VRPassHelper.MC.gameRenderer.render((DeltaTracker)deltaTracker, renderLevel);
        VRPassHelper.MC.levelRenderer.endFrame();
        RenderHelper.checkGLError("post game render " + String.valueOf((Object)eye));
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.LEFT || VRPassHelper.DATA_HOLDER.currentPass == RenderPass.RIGHT) {
            Profiler.get().push("postProcessEye");
            RenderTarget rendertarget = MC.getMainRenderTarget();
            if (VRPassHelper.DATA_HOLDER.vrSettings.useFsaa) {
                Profiler.get().push("fsaa");
                ShaderHelper.doFSAA(VRPassHelper.DATA_HOLDER.vrRenderer.framebufferVrRender, VRPassHelper.DATA_HOLDER.vrRenderer.fsaaFirstPassResultFBO, VRPassHelper.DATA_HOLDER.vrRenderer.fsaaLastPassResultFBO);
                rendertarget = VRPassHelper.DATA_HOLDER.vrRenderer.fsaaLastPassResultFBO;
                RenderHelper.checkGLError("fsaa " + String.valueOf((Object)eye));
                Profiler.get().pop();
            }
            ShaderHelper.doVrPostProcess(eye, rendertarget, eye == RenderPass.LEFT ? VRPassHelper.DATA_HOLDER.vrRenderer.framebufferEye0 : VRPassHelper.DATA_HOLDER.vrRenderer.framebufferEye1, deltaTracker.getGameTimeDeltaPartialTick(false));
            RenderHelper.checkGLError("post overlay" + String.valueOf((Object)eye));
            Profiler.get().pop();
        }
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.CAMERA) {
            Profiler.get().push("cameraCopy");
            RenderSystem.getDevice().createCommandEncoder().clearColorTexture(VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.getColorTexture(), -16777216);
            VRPassHelper.DATA_HOLDER.vrRenderer.cameraRenderFramebuffer.blitAndBlendToTexture(VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.getColorTextureView());
            Profiler.get().pop();
        }
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.THIRD && VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY && renderLevel && VRPassHelper.MC.level != null && OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.copyOptifineShaderDepth(VRPassHelper.DATA_HOLDER.vrRenderer.framebufferMR);
        }
    }

    public static void renderAndSubmit(boolean renderLevel, DeltaTracker.Timer deltaTracker) {
        Profiler.get().push("gameRenderer");
        Profiler.get().push("VR guis");
        Profiler.get().push("gui cursor");
        if (VRPassHelper.MC.screen != null || !VRPassHelper.MC.mouseHandler.isMouseGrabbed()) {
            int x = (int)(VRPassHelper.MC.mouseHandler.xpos() * (double)MC.getWindow().getGuiScaledWidth() / (double)MC.getWindow().getScreenWidth());
            int y = (int)(VRPassHelper.MC.mouseHandler.ypos() * (double)MC.getWindow().getGuiScaledHeight() / (double)MC.getWindow().getScreenHeight());
            RenderHelper.drawMouseMenuQuad(GuiRenderHelper.getGuiGraphics(), x, y);
            GuiRenderHelper.finish();
        }
        try {
            RenderSystem.getModelViewStack().popMatrix();
        }
        catch (IllegalStateException ignore) {
            VRSettings.LOGGER.error("Vivecraft: ModelViewStack was empty!");
        }
        if (VRPassHelper.DATA_HOLDER.vrSettings.guiMipmaps) {
            OpenGLHelper.genMipmaps(VRPassHelper.MC.mainRenderTarget.getColorTexture());
        }
        Profiler.get().popPush("2D Keyboard");
        if (KeyboardHandler.SHOWING && !VRPassHelper.DATA_HOLDER.vrSettings.physicalKeyboard) {
            VRPassHelper.MC.mainRenderTarget = KeyboardHandler.FRAMEBUFFER;
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(KeyboardHandler.FRAMEBUFFER.getColorTexture(), 0, KeyboardHandler.FRAMEBUFFER.getDepthTexture(), 1.0);
            RenderHelper.drawScreen(KeyboardHandler.UI, true);
        }
        Profiler.get().popPush("Radial Menu");
        if (RadialHandler.isShowing()) {
            VRPassHelper.MC.mainRenderTarget = RadialHandler.FRAMEBUFFER;
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(RadialHandler.FRAMEBUFFER.getColorTexture(), 0, RadialHandler.FRAMEBUFFER.getDepthTexture(), 1.0);
            RenderHelper.drawScreen(RadialHandler.UI, true);
        }
        Profiler.get().pop();
        RenderHelper.checkGLError("post 2d ");
        Profiler.get().pop();
        List<RenderPass> list = VRPassHelper.DATA_HOLDER.vrRenderer.getRenderPasses(false);
        VRPassHelper.DATA_HOLDER.isFirstPass = true;
        Iterator<RenderPass> y = list.iterator();
        while (y.hasNext()) {
            RenderPass renderpass;
            VRPassHelper.DATA_HOLDER.currentPass = renderpass = y.next();
            if (VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && VRPassHelper.DATA_HOLDER.cameraTracker.isVisible() && (renderpass == RenderPass.CENTER || renderpass == RenderPass.THIRD && VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.MIXED_REALITY)) continue;
            switch (renderpass) {
                case LEFT: 
                case RIGHT: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.STEREO_XR);
                    break;
                }
                case CENTER: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.CENTER);
                    break;
                }
                case THIRD: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.MIXED_REALITY);
                    break;
                }
                case SCOPEL: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.LEFT_TELESCOPE);
                    break;
                }
                case SCOPER: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.RIGHT_TELESCOPE);
                    break;
                }
                case CAMERA: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.CAMERA);
                }
            }
            Profiler.get().push("Eye:" + String.valueOf((Object)VRPassHelper.DATA_HOLDER.currentPass));
            Profiler.get().push("setup");
            Profiler.get().pop();
            VRPassHelper.renderSingleView(renderpass, deltaTracker, renderLevel);
            Profiler.get().pop();
            if (VRPassHelper.DATA_HOLDER.grabScreenShot) {
                boolean flag;
                if (list.contains((Object)RenderPass.CAMERA)) {
                    flag = renderpass == RenderPass.CAMERA;
                } else if (list.contains((Object)RenderPass.CENTER)) {
                    flag = renderpass == RenderPass.CENTER;
                } else {
                    boolean bl = VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? renderpass == RenderPass.LEFT : (flag = renderpass == RenderPass.RIGHT);
                }
                if (flag) {
                    RenderTarget rendertarget = VRPassHelper.MC.mainRenderTarget;
                    if (renderpass == RenderPass.CAMERA) {
                        rendertarget = VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                    }
                    ClientUtils.takeScreenshot(rendertarget);
                    MC.getWindow().updateDisplay(null);
                    VRPassHelper.DATA_HOLDER.grabScreenShot = false;
                }
            }
            VRPassHelper.DATA_HOLDER.isFirstPass = false;
        }
        Profiler.get().pop();
        VRPassHelper.DATA_HOLDER.vrPlayer.postRender(deltaTracker.getGameTimeDeltaPartialTick(true));
        Profiler.get().push("Display/Reproject");
        try {
            VRPassHelper.DATA_HOLDER.vrRenderer.endFrame();
        }
        catch (RenderConfigException exception) {
            VRSettings.LOGGER.error("Vivecraft: error ending frame: {}", (Object)exception.error.getString());
        }
        Profiler.get().pop();
        RenderHelper.checkGLError("post submit");
    }
}

