/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.utils.UpdateChecker;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ConfigBuilder;
import org.vivecraft.server.config.ServerConfig;

public class ServerUtil {
    public static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();

    public static void scheduleWelcomeMessageOrKick(ServerPlayer serverPlayer) {
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() || ((Boolean)ServerConfig.VIVE_ONLY.get()).booleanValue() || ((Boolean)ServerConfig.VR_ONLY.get()).booleanValue()) {
            SCHEDULER.schedule(() -> {
                if (!serverPlayer.hasDisconnected()) {
                    ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                    String message = "";
                    if (ServerUtil.kickIfNotAllowed(serverPlayer)) {
                        return;
                    }
                    if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() && !(message = vivePlayer == null ? (String)ServerConfig.MESSAGES_WELCOME_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_WELCOME_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_WELCOME_SEATED.get() : (String)ServerConfig.MESSAGES_WELCOME_VR.get()))).isEmpty()) {
                        try {
                            serverPlayer.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)message.formatted(serverPlayer.getName().getString())), false);
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("Vivecraft: Welcome message '{}' has errors: ", (Object)message, (Object)e);
                        }
                    }
                }
            }, (long)((Double)ServerConfig.MESSAGE_KICK_DELAY.get() * 1000.0), TimeUnit.MILLISECONDS);
        }
    }

    public static boolean kickIfNotAllowed(ServerPlayer player) {
        if (!player.hasDisconnected()) {
            boolean isOpAndAllowed;
            ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(player);
            boolean bl = isOpAndAllowed = (Boolean)ServerConfig.ALLOW_OP.get() != false && player.getServer().getPlayerList().isOp(player.getGameProfile());
            if (!(isOpAndAllowed || !((Boolean)ServerConfig.VR_ONLY.get()).booleanValue() || vivePlayer != null && vivePlayer.isVR())) {
                String kickMessage = (String)ServerConfig.MESSAGES_KICK_VR_ONLY.get();
                try {
                    kickMessage = kickMessage.formatted(player.getName().getString());
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: KickVROnly message '{}' has errors: ", (Object)kickMessage, (Object)e);
                }
                player.connection.disconnect((Component)Component.literal((String)kickMessage));
                return true;
            }
            if (!isOpAndAllowed && ((Boolean)ServerConfig.VIVE_ONLY.get()).booleanValue() && vivePlayer == null) {
                String kickMessage = (String)ServerConfig.MESSAGES_KICK_VIVE_ONLY.get();
                try {
                    kickMessage = kickMessage.formatted(player.getName().getString());
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: KickViveOnly message '{}' has errors: ", (Object)kickMessage, (Object)e);
                }
                player.connection.disconnect((Component)Component.literal((String)kickMessage));
                return true;
            }
        }
        return false;
    }

    public static void sendUpdateNotificationIfOP(ServerPlayer serverPlayer) {
        if (((Boolean)ServerConfig.CHECK_FOR_UPDATES.get()).booleanValue() && serverPlayer.getServer().isDedicatedServer() && serverPlayer.getServer().getPlayerList().isOp(serverPlayer.getGameProfile())) {
            SCHEDULER.schedule(() -> {
                if (UpdateChecker.checkForUpdates()) {
                    serverPlayer.sendSystemMessage((Component)Component.literal((String)("Vivecraft update available: \u00a7a" + UpdateChecker.NEWEST_VERSION)));
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vivecraft-server-config").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"reload").executes(context -> {
            ServerConfig.init((action, path, incorrectValue, correctedValue) -> {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Corrected \u00a7a[%s]\u00a7r: was '(%s)%s', is now '(%s)%s'".formatted(String.join((CharSequence)"\u00a7r.\u00a7a", path), incorrectValue.getClass().getSimpleName(), incorrectValue, correctedValue.getClass().getSimpleName(), correctedValue)));
                String pathString = String.join((CharSequence)".", path);
                ServerConfig.getConfigValues().stream().filter(c -> c.getPath().equals(pathString)).findFirst().ifPresent(setting -> {
                    setting.onUpdate(((CommandSourceStack)context.getSource()).getServer());
                    ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).getServer(), setting);
                });
            });
            return 1;
        })));
        for (ConfigBuilder.ConfigValue setting : ServerConfig.getConfigValues()) {
            IntegerArgumentType argument;
            String argumentName;
            Class<?> clazz = setting.get().getClass();
            if (clazz == Integer.class) {
                argumentName = "int";
                argument = IntegerArgumentType.integer();
            } else if (clazz == Double.class) {
                argumentName = "double";
                argument = DoubleArgumentType.doubleArg();
            } else if (clazz == Boolean.class) {
                argumentName = "bool";
                argument = BoolArgumentType.bool();
            } else {
                argumentName = "string";
                argument = StringArgumentType.string();
            }
            LiteralArgumentBuilder baseCommand = Commands.literal((String)setting.getPath());
            if (setting instanceof ConfigBuilder.InListValue) {
                ConfigBuilder.InListValue inListValue = (ConfigBuilder.InListValue)setting;
                baseCommand.then(Commands.literal((String)"set").then(Commands.argument((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Object value : inListValue.getValidValues()) {
                        if (!value.toString().toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    Object newValue = context.getArgument(argumentName, clazz);
                    if (inListValue.getValidValues().contains(newValue)) {
                        setting.set(newValue);
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)));
                        setting.onUpdate(((CommandSourceStack)context.getSource()).getServer());
                        ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).getServer(), setting);
                        return 1;
                    }
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)Component.literal((String)("Unsupported value: " + newValue.toString())));
                })));
            } else if (setting instanceof ConfigBuilder.EnumValue) {
                ConfigBuilder.EnumValue enumValue = (ConfigBuilder.EnumValue)setting;
                baseCommand.then(Commands.literal((String)"set").then(Commands.argument((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Enum value : enumValue.getValidValues()) {
                        if (!value.toString().toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    Object newValue = context.getArgument(argumentName, String.class);
                    Object newEnumValue = enumValue.getEnumValue(newValue);
                    if (newEnumValue != null) {
                        setting.set(newEnumValue);
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newEnumValue)));
                        setting.onUpdate(((CommandSourceStack)context.getSource()).getServer());
                        ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).getServer(), setting);
                        return 1;
                    }
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)Component.literal((String)("Unsupported value: " + newValue.toString())));
                })));
            } else if (!(setting.get() instanceof List)) {
                baseCommand.then(Commands.literal((String)"set").then(Commands.argument((String)argumentName, (ArgumentType)argument).executes(context -> {
                    Object newValue = context.getArgument(argumentName, clazz);
                    setting.set(newValue);
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)));
                    setting.onUpdate(((CommandSourceStack)context.getSource()).getServer());
                    ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).getServer(), setting);
                    return 1;
                })));
            } else {
                ConfigBuilder.ConfigValue listConfig = setting;
                baseCommand.then(Commands.literal((String)"add").then(Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)buildContext)).executes(context -> {
                    try {
                        String newValue = BuiltInRegistries.BLOCK.getKey((Object)((BlockInput)context.getArgument("block", BlockInput.class)).getState().getBlock()).toString();
                        List list = (List)listConfig.get();
                        list.add(newValue);
                        listConfig.set(list);
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"added '%s' to \u00a7a[%s]\u00a7r".formatted(newValue, setting.getPath())));
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"is now '%s'".formatted(setting.get())));
                        setting.onUpdate(((CommandSourceStack)context.getSource()).getServer());
                        ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).getServer(), setting);
                        return 1;
                    }
                    catch (Exception e) {
                        ServerNetworking.LOGGER.error("Vivecraft: error adding block to list:", (Throwable)e);
                        return 0;
                    }
                })));
                baseCommand.then(Commands.literal((String)"remove").then(Commands.argument((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                    for (String block : (List)listConfig.get()) {
                        if (!block.contains(builder.getRemaining())) continue;
                        builder.suggest(block);
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    String newValue = (String)context.getArgument("block", String.class);
                    List list = (List)listConfig.get();
                    list.remove(newValue);
                    listConfig.set(list);
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"removed '%s' from \u00a7a[%s]\u00a7r".formatted(newValue, setting.getPath())));
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"is now '%s'".formatted(setting.get())));
                    setting.onUpdate(((CommandSourceStack)context.getSource()).getServer());
                    ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).getServer(), setting);
                    return 1;
                })));
            }
            baseCommand.then(Commands.literal((String)"reset").executes(context -> {
                Object newValue = setting.reset();
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"reset \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)));
                setting.onUpdate(((CommandSourceStack)context.getSource()).getServer());
                ServerNetworking.sendUpdatePacketToAll(((CommandSourceStack)context.getSource()).getServer(), setting);
                return 1;
            }));
            baseCommand.executes(context -> {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7a[%s]\u00a7r is set to '%s'".formatted(setting.getPath(), setting.get())));
                return 1;
            });
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vivecraft-server-config").requires(source -> source.hasPermission(4))).then((ArgumentBuilder)baseCommand));
        }
    }

    public static void debugParticleAxes(ServerVivePlayer vivePlayer) {
        if (vivePlayer.isVR() && vivePlayer.vrPlayerState() != null) {
            for (VRBodyPart bodyPart : VRBodyPart.values()) {
                if (!bodyPart.availableInMode(vivePlayer.vrPlayerState().fbtMode()) || bodyPart == VRBodyPart.HEAD) continue;
                ServerUtil.debugParticleAxes(vivePlayer.player.level(), vivePlayer.getBodyPartPos(bodyPart), vivePlayer.vrPlayerState().getBodyPartPose(bodyPart).orientation());
            }
            if (((Boolean)ServerConfig.DEBUG_PARTICLES_HEAD.get()).booleanValue()) {
                ServerUtil.debugParticleAxes(vivePlayer.player.level(), vivePlayer.getHMDPos(), vivePlayer.vrPlayerState().hmd().orientation());
            }
        }
    }

    public static void debugParticleAxes(ServerLevel level, Vec3 position, Quaternionfc rot) {
        Vector3f red = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f green = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f blue = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f forward = rot.transform(MathUtils.BACK, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f());
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f());
        ServerUtil.spawnParticlesDirection(level, blue, position, forward);
        ServerUtil.spawnParticlesDirection(level, green, position, up);
        ServerUtil.spawnParticlesDirection(level, red, position, right);
    }

    public static void spawnParticlesDirection(ServerLevel level, Vector3f color, Vec3 position, Vector3f direction) {
        DustParticleOptions particle = new DustParticleOptions(ARGB.colorFromFloat((float)1.0f, (float)color.x, (float)color.y, (float)color.z), 0.25f);
        for (int i = 0; i < 5; ++i) {
            Vector3f offset = direction.mul(0.0625f * (float)i, new Vector3f());
            level.sendParticles((ParticleOptions)particle, position.x + (double)offset.x, position.y + (double)offset.y, position.z + (double)offset.z, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(SCHEDULER::shutdownNow));
    }
}

