/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.vivecraft.Xloader;
import org.vivecraft.client.api_impl.VRClientAPIImpl;
import org.vivecraft.client.gui.screens.ErrorScreen;
import org.vivecraft.client.gui.screens.GarbageCollectorScreen;
import org.vivecraft.client.utils.TextUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.bodylink.Haptics;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.menuworlds.MenuWorldRenderer;
import org.vivecraft.client_vr.provider.nullvr.NullVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.MCOpenVR;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VRState {
    public static boolean VR_ENABLED = false;
    public static boolean VR_INITIALIZED = false;
    public static boolean VR_RUNNING = false;
    private static boolean FRAME_DELAY = false;

    public static void initializeVR() {
        if (VR_INITIALIZED) {
            return;
        }
        if (!FRAME_DELAY) {
            FRAME_DELAY = true;
            return;
        }
        try {
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isAntialiasing()) {
                throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.incompatiblesettings"), (Component)Component.translatable((String)"vivecraft.messages.optifineaa"));
            }
            ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
            dh.vr = dh.vrSettings.stereoProviderPluginID == VRSettings.VRProvider.OPENVR ? new MCOpenVR(Minecraft.getInstance(), dh) : new NullVR(Minecraft.getInstance(), dh);
            if (!dh.vr.init()) {
                throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.vriniterror"), (Component)Component.translatable((String)"vivecraft.messages.rendersetupfailed", (Object[])new Object[]{dh.vr.initStatus, dh.vr.getName()}));
            }
            dh.vrRenderer = dh.vr.createVRRenderer();
            VR_INITIALIZED = true;
            dh.vrRenderer.setupRenderConfiguration();
            RenderPassManager.setVanillaRenderPass();
            dh.vrPlayer = new VRPlayer();
            if (Xloader.isModLoaded("hapticcraft")) {
                VRSettings.LOGGER.info("Vivecraft: Not activating bHaptics integration, because the official 'HapticCraft' is loaded!");
            } else {
                Haptics.connect();
            }
            dh.menuWorldRenderer = new MenuWorldRenderer();
            dh.menuWorldRenderer.init();
            try {
                String garbageCollector = StringUtils.getCommonPrefix((String[])((String[])ManagementFactory.getGarbageCollectorMXBeans().stream().map(MemoryManagerMXBean::getName).toArray(String[]::new))).trim();
                if (garbageCollector.isEmpty()) {
                    garbageCollector = ManagementFactory.getGarbageCollectorMXBeans().get(0).getName();
                }
                VRSettings.LOGGER.info("Vivecraft: Garbage collector: {}", (Object)garbageCollector);
                OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                VRSettings.LOGGER.info("Vivecraft: Available CPU threads: {}", (Object)Runtime.getRuntime().availableProcessors());
                VRSettings.LOGGER.info("Vivecraft: Total physical memory: {} GiB", (Object)String.format("%.01f", Float.valueOf((float)os.getTotalMemorySize() / 1.0737418E9f)));
                VRSettings.LOGGER.info("Vivecraft: Free physical memory: {} GiB", (Object)String.format("%.01f", Float.valueOf((float)os.getFreeMemorySize() / 1.0737418E9f)));
                if (!garbageCollector.startsWith("ZGC") && !ClientDataHolderVR.getInstance().vrSettings.disableGarbageCollectorMessage && os.getTotalMemorySize() >= 0x2F0000000L && Runtime.getRuntime().availableProcessors() >= 6) {
                    VRState.setScreenAndCache(new GarbageCollectorScreen(garbageCollector));
                }
            }
            catch (Throwable e) {
                VRSettings.LOGGER.error("Vivecraft: Failed checking GC: ", e);
            }
        }
        catch (Throwable exception) {
            VRSettings.LOGGER.error("Vivecraft: Failed to initialize VR: ", exception);
            VRState.destroyVR(true);
            if (exception instanceof RenderConfigException) {
                RenderConfigException renderConfigException = (RenderConfigException)exception;
                VRState.setScreenAndCache(new ErrorScreen(renderConfigException.title, renderConfigException.error));
            }
            VRState.setScreenAndCache(new ErrorScreen((Component)Component.translatable((String)"vivecraft.messages.vriniterror"), TextUtils.throwableToComponent(exception)));
        }
    }

    private static void setScreenAndCache(Screen screen) {
        Minecraft.getInstance().setScreen(screen);
        ClientDataHolderVR.getInstance().cachedScreen = screen;
    }

    public static void destroyVR(boolean disableVRSetting) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        if (dh.vr != null) {
            dh.vr.destroy();
        }
        dh.vr = null;
        dh.vrPlayer = null;
        if (dh.vrRenderer != null) {
            dh.vrRenderer.destroy();
            dh.vrRenderer = null;
        }
        RenderPassManager.setVanillaRenderPass();
        if (dh.menuWorldRenderer != null) {
            dh.menuWorldRenderer.completeDestroy();
            dh.menuWorldRenderer = null;
        }
        Haptics.disconnect();
        VR_ENABLED = false;
        VR_INITIALIZED = false;
        FRAME_DELAY = false;
        if (disableVRSetting) {
            dh.vrSettings.vrEnabled = false;
            dh.vrSettings.saveOptions();
            if (Xloader.isModLoaded("distanthorizons")) {
                ShadersHelper.maybeReloadShaders();
            }
            if (ClientDataHolderVR.getInstance().vrSettings.fullReloadOnInit) {
                Minecraft.getInstance().reloadResourcePacks();
            } else {
                Minecraft.getInstance().levelRenderer.onResourceManagerReload(Minecraft.getInstance().getResourceManager());
                try {
                    dh.updateActivePostChains();
                }
                catch (IOException exception) {
                    VRSettings.LOGGER.error("Vivecraft: Failed close vr postchains: ", (Throwable)exception);
                }
            }
        }
        VRClientAPIImpl.INSTANCE.clearPoseHistory();
    }
}

