/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.HeldInteractModule;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.interact_modules.DebugRenderModule;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.common.utils.MathUtils;

public class ScreenshotCameraModule
implements DebugRenderModule,
HeldInteractModule {
    private static final ResourceLocation ID = new ResourceLocation("vivecraft", "screenshot_camera");
    private static final float INTERACT_DIST = 0.11f;
    private final ClientDataHolderVR dh;
    private Vec3 camPos;

    public ScreenshotCameraModule(ClientDataHolderVR dh) {
        this.dh = dh;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 750;
    }

    @Override
    public boolean isActive(@Nullable LocalPlayer player, InteractionHand hand, Vec3 handPosition) {
        if (this.dh.cameraTracker.isVisible() && !this.dh.cameraTracker.isQuickMode()) {
            VRData.VRDevicePose camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.CAMERA);
            Vector3f offset = camData.getCustomVector(MathUtils.BACK).mul(0.08f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
            this.camPos = camData.getPosition().subtract((double)offset.x, (double)offset.y, (double)offset.z);
            return handPosition.distanceTo(this.camPos) < (double)(0.11f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
        }
        return false;
    }

    @Override
    public boolean onPress(@Nullable LocalPlayer player, InteractionHand hand) {
        this.dh.cameraTracker.startMoving(hand.ordinal());
        return true;
    }

    @Override
    public void onRelease(@Nullable LocalPlayer player, InteractionHand hand) {
        if (this.dh.cameraTracker.isMoving() && this.dh.cameraTracker.getMovingController() == hand.ordinal() && !this.dh.cameraTracker.isQuickMode()) {
            this.dh.cameraTracker.stopMoving();
        }
    }

    public boolean isActive() {
        return this.dh.interactTracker.isActiveModule(this);
    }

    @Override
    public void renderDebug(PoseStack poseStack, boolean isActive) {
        if (this.dh.cameraTracker.isVisible() && !this.dh.cameraTracker.isQuickMode() && this.camPos != null) {
            VRData world = this.dh.vrPlayer.getVRDataWorld();
            DebugRenderHelper.renderSphere(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.camPos, world.getEye(this.dh.currentPass).getPosition()), 0.11f * world.worldScale, isActive ? MathUtils.GREEN : MathUtils.RED);
        }
    }
}

