/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.MinecraftExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.ShaderHelper;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class VRPassHelper {
    private static final Minecraft MC = Minecraft.getInstance();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();

    public static void renderSingleView(RenderPass eye, float partialTick, long nanoTime, boolean renderLevel) {
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        VRPassHelper.MC.gameRenderer.render(partialTick, nanoTime, renderLevel);
        RenderHelper.checkGLError("post game render " + eye);
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.LEFT || VRPassHelper.DATA_HOLDER.currentPass == RenderPass.RIGHT) {
            MC.getProfiler().push("postProcessEye");
            RenderTarget rendertarget = MC.getMainRenderTarget();
            if (VRPassHelper.DATA_HOLDER.vrSettings.useFsaa) {
                MC.getProfiler().push("fsaa");
                ShaderHelper.doFSAA(VRPassHelper.DATA_HOLDER.vrRenderer.framebufferVrRender, VRPassHelper.DATA_HOLDER.vrRenderer.fsaaFirstPassResultFBO, VRPassHelper.DATA_HOLDER.vrRenderer.fsaaLastPassResultFBO);
                rendertarget = VRPassHelper.DATA_HOLDER.vrRenderer.fsaaLastPassResultFBO;
                RenderHelper.checkGLError("fsaa " + eye);
                MC.getProfiler().pop();
            }
            if (eye == RenderPass.LEFT) {
                VRPassHelper.DATA_HOLDER.vrRenderer.framebufferEye0.bindWrite(true);
            } else {
                VRPassHelper.DATA_HOLDER.vrRenderer.framebufferEye1.bindWrite(true);
            }
            ShaderHelper.doVrPostProcess(eye, rendertarget, partialTick);
            RenderHelper.checkGLError("post overlay" + eye);
            MC.getProfiler().pop();
        }
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.CAMERA) {
            MC.getProfiler().push("cameraCopy");
            VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.bindWrite(true);
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
            VRPassHelper.DATA_HOLDER.vrRenderer.cameraRenderFramebuffer.blitToScreen(VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.viewWidth, VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.viewHeight);
            MC.getProfiler().pop();
        }
        if (VRPassHelper.DATA_HOLDER.currentPass == RenderPass.THIRD && VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY && renderLevel && VRPassHelper.MC.level != null && OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.copyOptifineShaderDepth(VRPassHelper.DATA_HOLDER.vrRenderer.framebufferMR);
        }
    }

    public static void renderAndSubmit(boolean renderLevel, long nanoTime, float actualPartialTick) {
        Object guiProjection;
        MC.getProfiler().push("gameRenderer");
        MC.getProfiler().push("VR guis");
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        GuiGraphics guiGraphics = new GuiGraphics(MC, MC.renderBuffers().bufferSource());
        MC.getProfiler().push("gui cursor");
        if (VRPassHelper.MC.screen != null || !VRPassHelper.MC.mouseHandler.isMouseGrabbed()) {
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.pushPose();
            poseStack.setIdentity();
            poseStack.translate(0.0f, 0.0f, -11000.0f);
            RenderSystem.applyModelViewMatrix();
            guiProjection = new Matrix4f().setOrtho(0.0f, (float)MC.getWindow().getGuiScaledWidth(), (float)MC.getWindow().getGuiScaledHeight(), 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)guiProjection, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            int x = (int)(VRPassHelper.MC.mouseHandler.xpos() * (double)MC.getWindow().getGuiScaledWidth() / (double)MC.getWindow().getScreenWidth());
            int y = (int)(VRPassHelper.MC.mouseHandler.ypos() * (double)MC.getWindow().getGuiScaledHeight() / (double)MC.getWindow().getScreenHeight());
            RenderHelper.drawMouseMenuQuad(guiGraphics, x, y);
            guiGraphics.flush();
            poseStack.popPose();
            RenderSystem.applyModelViewMatrix();
        }
        MC.getProfiler().popPush("fps pie");
        ((MinecraftExtension)MC).vivecraft$drawProfiler();
        if (!RenderSystem.getModelViewStack().clear()) {
            RenderSystem.getModelViewStack().popPose();
        }
        RenderSystem.applyModelViewMatrix();
        if (VRPassHelper.DATA_HOLDER.vrSettings.guiMipmaps) {
            OpenGLHelper.genMipmaps(VRPassHelper.MC.mainRenderTarget);
        }
        MC.getProfiler().popPush("2D Keyboard");
        if (KeyboardHandler.SHOWING && !VRPassHelper.DATA_HOLDER.vrSettings.physicalKeyboard) {
            VRPassHelper.MC.mainRenderTarget = KeyboardHandler.FRAMEBUFFER;
            VRPassHelper.MC.mainRenderTarget.clear(Minecraft.ON_OSX);
            VRPassHelper.MC.mainRenderTarget.bindWrite(true);
            RenderHelper.drawScreen(guiGraphics, actualPartialTick, KeyboardHandler.UI, true);
        }
        MC.getProfiler().popPush("Radial Menu");
        if (RadialHandler.isShowing()) {
            VRPassHelper.MC.mainRenderTarget = RadialHandler.FRAMEBUFFER;
            VRPassHelper.MC.mainRenderTarget.clear(Minecraft.ON_OSX);
            VRPassHelper.MC.mainRenderTarget.bindWrite(true);
            RenderHelper.drawScreen(guiGraphics, actualPartialTick, RadialHandler.UI, true);
        }
        MC.getProfiler().pop();
        RenderHelper.checkGLError("post 2d ");
        MC.getProfiler().pop();
        List<RenderPass> list = VRPassHelper.DATA_HOLDER.vrRenderer.getRenderPasses(false);
        VRPassHelper.DATA_HOLDER.isFirstPass = true;
        guiProjection = list.iterator();
        while (guiProjection.hasNext()) {
            RenderPass renderpass;
            VRPassHelper.DATA_HOLDER.currentPass = renderpass = (RenderPass)((Object)guiProjection.next());
            if (VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && VRPassHelper.DATA_HOLDER.cameraTracker.isVisible() && (renderpass == RenderPass.CENTER || renderpass == RenderPass.THIRD && VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.MIXED_REALITY)) continue;
            switch (renderpass) {
                case LEFT: 
                case RIGHT: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.STEREO_XR);
                    break;
                }
                case CENTER: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.CENTER);
                    break;
                }
                case THIRD: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.MIXED_REALITY);
                    break;
                }
                case SCOPEL: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.LEFT_TELESCOPE);
                    break;
                }
                case SCOPER: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.RIGHT_TELESCOPE);
                    break;
                }
                case CAMERA: {
                    RenderPassManager.setWorldRenderPass(WorldRenderPass.CAMERA);
                }
            }
            MC.getProfiler().push("Eye:" + VRPassHelper.DATA_HOLDER.currentPass);
            MC.getProfiler().push("setup");
            VRPassHelper.MC.mainRenderTarget.bindWrite(true);
            MC.getProfiler().pop();
            VRPassHelper.renderSingleView(renderpass, actualPartialTick, nanoTime, renderLevel);
            MC.getProfiler().pop();
            if (VRPassHelper.DATA_HOLDER.grabScreenShot) {
                boolean flag;
                if (list.contains((Object)RenderPass.CAMERA)) {
                    flag = renderpass == RenderPass.CAMERA;
                } else if (list.contains((Object)RenderPass.CENTER)) {
                    flag = renderpass == RenderPass.CENTER;
                } else {
                    boolean bl = VRPassHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? renderpass == RenderPass.LEFT : (flag = renderpass == RenderPass.RIGHT);
                }
                if (flag) {
                    RenderTarget rendertarget = VRPassHelper.MC.mainRenderTarget;
                    if (renderpass == RenderPass.CAMERA) {
                        rendertarget = VRPassHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                    }
                    VRPassHelper.MC.mainRenderTarget.unbindWrite();
                    ClientUtils.takeScreenshot(rendertarget);
                    MC.getWindow().updateDisplay();
                    VRPassHelper.DATA_HOLDER.grabScreenShot = false;
                }
            }
            VRPassHelper.DATA_HOLDER.isFirstPass = false;
        }
        MC.getProfiler().pop();
        VRPassHelper.DATA_HOLDER.vrPlayer.postRender(actualPartialTick);
        MC.getProfiler().push("Display/Reproject");
        try {
            VRPassHelper.DATA_HOLDER.vrRenderer.endFrame();
        }
        catch (RenderConfigException exception) {
            VRSettings.LOGGER.error("Vivecraft: error ending frame: {}", (Object)exception.error.getString());
        }
        MC.getProfiler().pop();
        RenderHelper.checkGLError("post submit");
    }
}

