/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server.config;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import org.vivecraft.client.gui.framework.screens.GuiStringListEditorScreen;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.config.ConfigBuilder;

public class WidgetBuilder {
    public static Supplier<AbstractWidget> getBaseWidget(ConfigBuilder.ConfigValue<?> value, int width, int height) {
        return () -> Button.builder((Component)Component.literal((String)("" + value.get())), button -> {}).bounds(0, 0, width, height).build();
    }

    public static Supplier<AbstractWidget> getOnOffWidget(ConfigBuilder.BooleanValue booleanValue, int width, int height) {
        return () -> CycleButton.onOffBuilder((boolean)((Boolean)booleanValue.get())).displayOnlyValue().create(0, 0, width, height, (Component)Component.empty(), (button, bool) -> {
            booleanValue.set(bool);
            WidgetBuilder.updateSettingsSinglePlayer(booleanValue);
        });
    }

    public static Supplier<AbstractWidget> getEditBoxWidget(final ConfigBuilder.StringValue stringValue, int width, int height) {
        return () -> {
            EditBox box = new EditBox(Minecraft.getInstance().font, 0, 0, width - 1, height, (Component)Component.literal((String)((String)stringValue.get()))){

                public boolean charTyped(char character, int modifiers) {
                    boolean ret = super.charTyped(character, modifiers);
                    stringValue.set(this.getValue());
                    return ret;
                }

                public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                    boolean ret = super.keyPressed(keyCode, scanCode, modifiers);
                    stringValue.set(this.getValue());
                    return ret;
                }
            };
            box.setMaxLength(1000);
            box.setValue((String)stringValue.get());
            return box;
        };
    }

    public static <T> Supplier<AbstractWidget> getCycleWidget(ConfigBuilder.ConfigValue<T> configValue, Collection<? extends T> values, int width, int height) {
        return () -> CycleButton.builder(newValue -> Component.translatable((String)("vivecraft.serverSettings." + configValue.getPath() + "." + newValue))).withValues(values.toArray()).withInitialValue(configValue.get()).displayOnlyValue().create(0, 0, width, height, (Component)Component.empty(), (button, newValue) -> {
            configValue.set(newValue);
            WidgetBuilder.updateSettingsSinglePlayer(configValue);
        });
    }

    public static <E extends Number> Supplier<AbstractWidget> getSliderWidget(final ConfigBuilder.NumberValue<E> numberValue, int width, int height) {
        return () -> new AbstractSliderButton(0, 0, width, height, (Component)Component.literal((String)("" + numberValue.get())), numberValue.normalize()){

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("" + numberValue.get())));
            }

            protected void applyValue() {
                numberValue.fromNormalized(this.value);
                WidgetBuilder.updateSettingsSinglePlayer(numberValue);
            }
        };
    }

    public static <T> Supplier<AbstractWidget> getEditListWidget(ConfigBuilder.ListValue<T> listValue, int width, int height) {
        Object first;
        Object object = first = ((List)listValue.get()).isEmpty() ? null : (Object)((List)listValue.get()).get(0);
        if (first == null || first instanceof String) {
            ConfigBuilder.ListValue stringValue = listValue;
            return () -> Button.builder((Component)Component.translatable((String)"vivecraft.options.editlist"), button -> Minecraft.getInstance().setScreen((Screen)new GuiStringListEditorScreen((Component)Component.translatable((String)("vivecraft.serverSettings." + listValue.getPath())), Minecraft.getInstance().screen, false, stringValue::get, stringValue::reset, list -> {
                stringValue.set(list);
                WidgetBuilder.updateSettingsSinglePlayer(stringValue);
            }))).size(width, height).build();
        }
        throw new RuntimeException("Unsupported listvalue type: " + first.getClass().getName());
    }

    private static void updateSettingsSinglePlayer(ConfigBuilder.ConfigValue<?> configValue) {
        if (Minecraft.getInstance().hasSingleplayerServer()) {
            configValue.onUpdate((MinecraftServer)Minecraft.getInstance().getSingleplayerServer());
            ServerNetworking.sendUpdatePacketToAll((MinecraftServer)Minecraft.getInstance().getSingleplayerServer(), configValue);
        }
    }
}

