/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MultilineComponent
extends AbstractWidget {
    private final Font font;
    private final boolean centered;
    private final List<FormattedCharSequence> text;
    private boolean renderBackground = false;

    public MultilineComponent(int x, int y, int width, Component message, boolean centered, Font font) {
        super(centered ? x - width / 2 : x, y, width, 0, message);
        this.text = Minecraft.getInstance().font.split((FormattedText)message, width);
        int n = this.text.size();
        Objects.requireNonNull(font);
        this.height = n * 9;
        this.centered = centered;
        this.font = font;
    }

    public MultilineComponent withBackground() {
        this.renderBackground = true;
        return this;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderBackground) {
            guiGraphics.fill(RenderType.guiOverlay(), this.getX() - 5, this.getY() - 5, this.getX() + this.getWidth() + 5, this.getY() + this.getHeight() + 5, Integer.MIN_VALUE);
        }
        int yPos = 0;
        for (FormattedCharSequence text : this.text) {
            if (this.centered) {
                guiGraphics.drawCenteredString(this.font, text, this.getX() + this.width / 2, this.getY() + yPos, -1);
            } else {
                guiGraphics.drawString(this.font, text, this.getX(), this.getY() + yPos, -1);
            }
            Objects.requireNonNull(this.font);
            yPos += 9;
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

