/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.BlockModelWrapperExtension;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class VivecraftItemRendering {
    private static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();

    public static VivecraftItemTransformType getTransformType(ItemStack itemStack, AbstractClientPlayer player) {
        VivecraftItemTransformType itemTransformType = VivecraftItemTransformType.ITEM;
        Item item = itemStack.getItem();
        if (itemStack.getUseAnimation() == ItemUseAnimation.EAT || itemStack.getUseAnimation() == ItemUseAnimation.DRINK) {
            itemTransformType = VivecraftItemTransformType.NOMS;
        } else if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            if (block instanceof BaseTorchBlock) {
                itemTransformType = VivecraftItemTransformType.BLOCK_STICK;
            } else {
                BlockModelWrapperExtension blockModel;
                ItemModel model;
                ResourceLocation modelName = (ResourceLocation)itemStack.get(DataComponents.ITEM_MODEL);
                if (modelName != null && (model = Minecraft.getInstance().getModelManager().getItemModel(modelName)) instanceof BlockModelWrapperExtension && (blockModel = (BlockModelWrapperExtension)model).vivecraft$isGenerated()) {
                    return VivecraftItemTransformType.BLOCK_ITEM;
                }
                itemTransformType = VivecraftItemTransformType.BLOCK_3D;
            }
        } else if (item instanceof MapItem || itemStack.is(ViveItemTags.VIVECRAFT_MAPS)) {
            itemTransformType = VivecraftItemTransformType.MAP;
        } else if (itemStack.getUseAnimation() == ItemUseAnimation.BOW && !itemStack.is(ViveItemTags.VIVECRAFT_BOW_EXCLUSION)) {
            itemTransformType = VivecraftItemTransformType.BOW_SEATED;
            if (VivecraftItemRendering.DH.bowTracker.isActive((LocalPlayer)player)) {
                itemTransformType = VivecraftItemRendering.DH.bowTracker.isDrawing() ? VivecraftItemTransformType.BOW_ROOMSCALE_DRAWING : VivecraftItemTransformType.BOW_ROOMSCALE;
            }
        } else if (itemStack.getUseAnimation() == ItemUseAnimation.TOOT_HORN) {
            itemTransformType = VivecraftItemTransformType.HORN;
        } else if (itemStack.is(ViveItemTags.VIVECRAFT_ROTATED_TOOLS)) {
            itemTransformType = VivecraftItemTransformType.ROTATED_TOOL;
        } else if (item instanceof MaceItem || itemStack.is(ViveItemTags.VIVECRAFT_MACES)) {
            itemTransformType = VivecraftItemTransformType.MACE;
        } else if (itemStack.is(ItemTags.SWORDS) || itemStack.is(ViveItemTags.VIVECRAFT_SWORDS)) {
            itemTransformType = VivecraftItemTransformType.SWORD;
        } else if (item instanceof ShieldItem || itemStack.is(ViveItemTags.VIVECRAFT_SHIELDS)) {
            itemTransformType = VivecraftItemTransformType.SHIELD;
        } else if (item instanceof TridentItem || itemStack.is(ViveItemTags.VIVECRAFT_SPEARS)) {
            itemTransformType = VivecraftItemTransformType.SPEAR;
        } else if (item instanceof CrossbowItem || itemStack.is(ViveItemTags.VIVECRAFT_CROSSBOWS)) {
            itemTransformType = VivecraftItemTransformType.CROSSBOW;
        } else if (item instanceof CompassItem || item == Items.CLOCK || itemStack.is(ViveItemTags.VIVECRAFT_COMPASSES)) {
            itemTransformType = VivecraftItemTransformType.COMPASS;
        } else if (SwingTracker.isTool(itemStack)) {
            itemTransformType = VivecraftItemTransformType.TOOL;
            if (item instanceof FoodOnAStickItem || item instanceof FishingRodItem || itemStack.is(ViveItemTags.VIVECRAFT_FISHING_RODS)) {
                itemTransformType = VivecraftItemTransformType.TOOL_ROD;
            }
        } else if (TelescopeTracker.isTelescope(itemStack)) {
            itemTransformType = VivecraftItemTransformType.TELESCOPE;
        }
        return itemTransformType;
    }

    public static void applyThirdPersonItemTransforms(PoseStack poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, AbstractClientPlayer player, float equippedProgress, float partialTick, ItemStack itemStack, InteractionHand hand) {
        int k = mainHand ? 1 : -1;
        float scale = 0.525f;
        float translateX = 0.0f;
        float translateY = 0.05f;
        float translateZ = 0.0f;
        boolean useLeftHandModelinLeftHand = false;
        if (ClimbTracker.isClaws(itemStack)) {
            scale = 0.4f;
        }
        poseStack.translate(translateX, translateY, translateZ);
        poseStack.scale(scale, scale, scale);
    }

    public static void applyFirstPersonItemTransforms(PoseStack poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, AbstractClientPlayer player, float equippedProgress, float partialTick, ItemStack itemStack, InteractionHand hand) {
        float gunAngle = VivecraftItemRendering.DH.vr.getGunAngle();
        float scale = 0.7f;
        float translateX = -0.05f;
        float translateY = 0.005f;
        float translateZ = 0.0f;
        Quaternionf rotation = new Quaternionf();
        Quaternionf preRotation = new Quaternionf();
        rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-110.0f + gunAngle));
        switch (itemTransformType.ordinal()) {
            case 8: {
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f - gunAngle));
                translateY += -0.1f;
                translateZ += 0.1f;
                break;
            }
            case 9: {
                preRotation.set((Quaternionfc)rotation);
                rotation.identity();
                translateX -= 0.0225f;
                translateY -= 0.25f;
                translateZ += 0.025f + 0.03f * gunAngle / 40.0f;
                scale = 1.0f;
                break;
            }
            case 10: {
                rotation.identity();
                scale = 1.0f;
                int bowHand = 1;
                if (VivecraftItemRendering.DH.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
                    bowHand = 0;
                }
                Vector3fc aim = VivecraftItemRendering.DH.bowTracker.getAimVector();
                Vector3f forward = VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getHand(bowHand).getCustomVector(MathUtils.FORWARD);
                if (VivecraftItemRendering.DH.bowTracker.isCharged()) {
                    long j = Util.getMillis() - VivecraftItemRendering.DH.bowTracker.startDrawTime;
                    translateX += 0.003f * Mth.sin((float)j);
                }
                poseStack.translate(0.0f, 0.0f, 0.1f);
                poseStack.last().pose().mul((Matrix4fc)VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getController(bowHand).getMatrix().transpose());
                preRotation = new Quaternionf().lookAlong(aim, (Vector3fc)forward).conjugate();
                rotation = Axis.YP.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(160.0f));
                translateX += 0.125f;
                translateY += 0.1225f;
                translateZ += 0.16f;
                break;
            }
            case 14: {
                rotation = Axis.YP.rotationDegrees(10.0f);
                translateX += 0.01f;
                translateZ -= 0.02f;
                translateY -= 0.02f;
                scale = 0.5f;
                break;
            }
            case 12: {
                rotation = Axis.XP.rotationDegrees(-45.0f);
                translateX = 0.0f;
                translateY = 0.16f;
                translateZ = -0.075f;
                scale = 0.75f;
                break;
            }
            case 13: {
                rotation = Axis.ZP.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-135.0f));
                translateX += 0.08f;
                translateZ += 0.02f + 0.006f * Mth.sin((float)player.getUseItemRemainingTicks());
                scale = 0.4f;
                break;
            }
            case 0: 
            case 3: {
                rotation = Axis.ZP.rotationDegrees(180.0f);
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-135.0f));
                translateX += 0.08f;
                translateZ += -0.08f;
                scale = 0.4f;
                break;
            }
            case 16: {
                rotation = Axis.YP.rotationDegrees(90.0f);
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(25.0f));
                scale = 0.4f;
                break;
            }
            case 1: {
                translateX += 0.05f;
                translateZ -= 0.1f;
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f - gunAngle));
                scale = 0.3f;
                break;
            }
            case 2: {
                rotation = Axis.XP.rotationDegrees(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                break;
            }
            case 17: {
                rotation = Axis.XP.rotationDegrees(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                scale = 0.3f;
                break;
            }
            case 4: {
                int side;
                int n = side = mainHand ? 1 : -1;
                if (VivecraftItemRendering.DH.vrSettings.reverseHands) {
                    side *= -1;
                }
                scale = 0.4f;
                translateY += 0.18f;
                if (side == 1) {
                    rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(105.0f - gunAngle));
                    translateX += 0.11f;
                } else {
                    rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(115.0f - gunAngle));
                    translateX -= 0.015f;
                }
                translateZ += 0.1f;
                if (player.isUsingItem() && player.getUseItemRemainingTicks() > 0 && player.getUsedItemHand() == hand) {
                    rotation.mul((Quaternionfc)Axis.XP.rotationDegrees((float)side * 5.0f));
                    rotation.mul((Quaternionfc)Axis.ZP.rotationDegrees(-5.0f));
                    if (side == 1) {
                        translateX += 0.04f;
                        translateY -= 0.12f;
                        translateZ -= 0.1f;
                    } else {
                        translateX += 0.19f;
                        translateY -= 0.12f;
                        translateZ -= 0.11f;
                    }
                    if (player.isBlocking()) {
                        rotation.mul((Quaternionfc)Axis.YP.rotationDegrees((float)side * 90.0f));
                    } else {
                        rotation.mul((Quaternionfc)Axis.YP.rotationDegrees((1.0f - equippedProgress) * (float)side * 90.0f));
                    }
                }
                rotation.mul((Quaternionfc)Axis.YP.rotationDegrees((float)side * -90.0f));
                break;
            }
            case 11: {
                rotation.identity();
                translateX -= 0.135f;
                translateZ += 0.575f;
                scale = 0.6f;
                float progress = 0.0f;
                boolean charging = false;
                float riptideLevel = 0.0f;
                if (player.isUsingItem() && player.getUseItemRemainingTicks() > 0 && player.getUsedItemHand() == hand) {
                    charging = true;
                    riptideLevel = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemStack, (LivingEntity)player);
                    if ((riptideLevel <= 0.0f || player.isInWaterOrRain()) && (progress = (float)itemStack.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 1.0f)) > 10.0f) {
                        float rotationProgress = progress - 10.0f;
                        progress = 10.0f;
                        if (riptideLevel > 0.0f && player.isInWaterOrRain()) {
                            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-rotationProgress * 10.0f * riptideLevel));
                        }
                        if (VivecraftItemRendering.DH.frameIndex % 4L == 0L) {
                            VivecraftItemRendering.DH.vr.triggerHapticPulse(mainHand ? 0 : 1, 200);
                        }
                        translateX += 0.003f * (float)Math.sin(Util.getMillis());
                    }
                }
                if (player.isAutoSpinAttack()) {
                    riptideLevel = 5.0f;
                    translateZ -= 0.15f;
                    poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(-VivecraftItemRendering.DH.tickCounter * 10) * riptideLevel % 360.0f - partialTick * 10.0f * riptideLevel));
                    charging = true;
                }
                if (!charging) {
                    translateY += 0.2f * gunAngle / 40.0f;
                    rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(gunAngle));
                }
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-65.0f));
                translateZ += -0.75f + progress / 10.0f * 0.25f;
                break;
            }
            case 7: {
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(40.0f));
                translateY += -0.02f + gunAngle / 40.0f * 0.1f;
                translateX += 0.05f;
                translateZ -= 0.15f;
                scale = 0.8f;
                break;
            }
            case 19: {
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                translateY += -0.125f + gunAngle / 40.0f * 0.1f;
                translateZ -= 0.1f;
                break;
            }
            case 6: {
                if (!(itemStack.getItem() instanceof ArrowItem) && !itemStack.is(ViveItemTags.VIVECRAFT_ARROWS)) break;
                preRotation = Axis.ZP.rotationDegrees(-180.0f);
                rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-gunAngle));
                break;
            }
            case 15: {
                preRotation.identity();
                rotation.identity();
                translateX = (mainHand ? -0.03f : 0.03f) * (scale *= 0.625f);
                translateY = 0.0f;
                translateZ = -0.1f * scale;
                break;
            }
            case 18: {
                preRotation = Axis.XP.rotationDegrees(gunAngle);
                rotation = rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-gunAngle));
                translateX = 0.0f;
                translateY = 0.0125f;
                translateZ = -0.06f;
                scale = 0.56f;
                break;
            }
        }
        poseStack.mulPose((Quaternionfc)preRotation);
        poseStack.translate(translateX, translateY, translateZ);
        poseStack.mulPose((Quaternionfc)rotation);
        poseStack.scale(scale, scale, scale);
    }

    public static enum VivecraftItemTransformType {
        ITEM,
        BLOCK_3D,
        BLOCK_STICK,
        BLOCK_ITEM,
        SHIELD,
        SWORD,
        TOOL,
        TOOL_ROD,
        BOW_SEATED,
        BOW_ROOMSCALE,
        BOW_ROOMSCALE_DRAWING,
        SPEAR,
        MAP,
        NOMS,
        CROSSBOW,
        TELESCOPE,
        COMPASS,
        HORN,
        MACE,
        ROTATED_TOOL;

    }
}

