/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct PropertyWrite_t")
public class PropertyWrite
extends Struct<PropertyWrite>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROP;
    public static final int WRITETYPE;
    public static final int ESETERROR;
    public static final int PVBUFFER;
    public static final int UNBUFFERSIZE;
    public static final int UNTAG;
    public static final int EERROR;

    protected PropertyWrite(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected PropertyWrite create(long address, @Nullable ByteBuffer container) {
        return new PropertyWrite(address, container);
    }

    public PropertyWrite(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), PropertyWrite.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ETrackedDeviceProperty")
    public int prop() {
        return PropertyWrite.nprop(this.address());
    }

    @NativeType(value="EPropertyWriteType")
    public int writeType() {
        return PropertyWrite.nwriteType(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eSetError() {
        return PropertyWrite.neSetError(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pvBuffer() {
        return PropertyWrite.npvBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int unBufferSize() {
        return PropertyWrite.nunBufferSize(this.address());
    }

    @NativeType(value="PropertyTypeTag_t")
    public int unTag() {
        return PropertyWrite.nunTag(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eError() {
        return PropertyWrite.neError(this.address());
    }

    public PropertyWrite prop(@NativeType(value="ETrackedDeviceProperty") int value) {
        PropertyWrite.nprop(this.address(), value);
        return this;
    }

    public PropertyWrite writeType(@NativeType(value="EPropertyWriteType") int value) {
        PropertyWrite.nwriteType(this.address(), value);
        return this;
    }

    public PropertyWrite eSetError(@NativeType(value="ETrackedPropertyError") int value) {
        PropertyWrite.neSetError(this.address(), value);
        return this;
    }

    public PropertyWrite pvBuffer(@NativeType(value="void *") ByteBuffer value) {
        PropertyWrite.npvBuffer(this.address(), value);
        return this;
    }

    public PropertyWrite unTag(@NativeType(value="PropertyTypeTag_t") int value) {
        PropertyWrite.nunTag(this.address(), value);
        return this;
    }

    public PropertyWrite eError(@NativeType(value="ETrackedPropertyError") int value) {
        PropertyWrite.neError(this.address(), value);
        return this;
    }

    public PropertyWrite set(int prop, int writeType, int eSetError, ByteBuffer pvBuffer, int unTag, int eError) {
        this.prop(prop);
        this.writeType(writeType);
        this.eSetError(eSetError);
        this.pvBuffer(pvBuffer);
        this.unTag(unTag);
        this.eError(eError);
        return this;
    }

    public PropertyWrite set(PropertyWrite src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static PropertyWrite malloc() {
        return new PropertyWrite(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static PropertyWrite calloc() {
        return new PropertyWrite(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static PropertyWrite create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new PropertyWrite(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static PropertyWrite create(long address) {
        return new PropertyWrite(address, null);
    }

    @Nullable
    public static PropertyWrite createSafe(long address) {
        return address == 0L ? null : new PropertyWrite(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)PropertyWrite.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = PropertyWrite.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static PropertyWrite malloc(MemoryStack stack) {
        return new PropertyWrite(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static PropertyWrite calloc(MemoryStack stack) {
        return new PropertyWrite(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nprop(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROP);
    }

    public static int nwriteType(long struct) {
        return UNSAFE.getInt(null, struct + (long)WRITETYPE);
    }

    public static int neSetError(long struct) {
        return UNSAFE.getInt(null, struct + (long)ESETERROR);
    }

    public static ByteBuffer npvBuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)), (int)PropertyWrite.nunBufferSize(struct));
    }

    public static int nunBufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNBUFFERSIZE);
    }

    public static int nunTag(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNTAG);
    }

    public static int neError(long struct) {
        return UNSAFE.getInt(null, struct + (long)EERROR);
    }

    public static void nprop(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PROP, value);
    }

    public static void nwriteType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WRITETYPE, value);
    }

    public static void neSetError(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ESETERROR, value);
    }

    public static void npvBuffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVBUFFER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        PropertyWrite.nunBufferSize(struct, value.remaining());
    }

    public static void nunBufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNBUFFERSIZE, value);
    }

    public static void nunTag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNTAG, value);
    }

    public static void neError(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EERROR, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)));
    }

    static {
        Struct.Layout layout = PropertyWrite.__struct((Struct.Member[])new Struct.Member[]{PropertyWrite.__member((int)4), PropertyWrite.__member((int)4), PropertyWrite.__member((int)4), PropertyWrite.__member((int)POINTER_SIZE), PropertyWrite.__member((int)4), PropertyWrite.__member((int)4), PropertyWrite.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROP = layout.offsetof(0);
        WRITETYPE = layout.offsetof(1);
        ESETERROR = layout.offsetof(2);
        PVBUFFER = layout.offsetof(3);
        UNBUFFERSIZE = layout.offsetof(4);
        UNTAG = layout.offsetof(5);
        EERROR = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<PropertyWrite, Buffer>
    implements NativeResource {
        private static final PropertyWrite ELEMENT_FACTORY = PropertyWrite.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected PropertyWrite getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ETrackedDeviceProperty")
        public int prop() {
            return PropertyWrite.nprop(this.address());
        }

        @NativeType(value="EPropertyWriteType")
        public int writeType() {
            return PropertyWrite.nwriteType(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eSetError() {
            return PropertyWrite.neSetError(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pvBuffer() {
            return PropertyWrite.npvBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int unBufferSize() {
            return PropertyWrite.nunBufferSize(this.address());
        }

        @NativeType(value="PropertyTypeTag_t")
        public int unTag() {
            return PropertyWrite.nunTag(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eError() {
            return PropertyWrite.neError(this.address());
        }

        public Buffer prop(@NativeType(value="ETrackedDeviceProperty") int value) {
            PropertyWrite.nprop(this.address(), value);
            return this;
        }

        public Buffer writeType(@NativeType(value="EPropertyWriteType") int value) {
            PropertyWrite.nwriteType(this.address(), value);
            return this;
        }

        public Buffer eSetError(@NativeType(value="ETrackedPropertyError") int value) {
            PropertyWrite.neSetError(this.address(), value);
            return this;
        }

        public Buffer pvBuffer(@NativeType(value="void *") ByteBuffer value) {
            PropertyWrite.npvBuffer(this.address(), value);
            return this;
        }

        public Buffer unTag(@NativeType(value="PropertyTypeTag_t") int value) {
            PropertyWrite.nunTag(this.address(), value);
            return this;
        }

        public Buffer eError(@NativeType(value="ETrackedPropertyError") int value) {
            PropertyWrite.neError(this.address(), value);
            return this;
        }
    }
}

