/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.vivecraft.Xloader;
import org.vivecraft.client_vr.extensions.ClassDependentMixin;
import org.vivecraft.client_vr.extensions.MethodDependentMixin;
import org.vivecraft.mod_compat_vr.sodium.SodiumHelper;

public class MixinConfig
implements IMixinConfigPlugin {
    private static final Set<String> APPLIED_MOD_FIXES = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VivecraftMixin");
    private static final String CLASS_DEPENDENT_MIXIN = "L" + ClassDependentMixin.class.getName().replace(".", "/") + ";";
    private static final String METHOD_DEPENDENT_MIXIN = "L" + MethodDependentMixin.class.getName().replace(".", "/") + ";";

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void onLoad(String mixinPackage) {
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!Xloader.isModLoadedSuccess()) {
            LOGGER.info("Vivecraft: not loading '{}' because mod failed to load completely", (Object)mixinClassName);
            return false;
        }
        if (mixinClassName.startsWith("org.vivecraft.mod_compat_vr")) {
            try {
                MixinService.getService().getBytecodeProvider().getClassNode(targetClassName);
            }
            catch (IOException | ClassNotFoundException e) {
                return false;
            }
            String mod = mixinClassName.split("\\.")[3];
            if (APPLIED_MOD_FIXES.add(mod)) {
                LOGGER.info("Vivecraft: applying '{}' fixes", (Object)mod);
            }
        }
        try {
            ClassNode mixinClass = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
            if (mixinClass.visibleAnnotations != null) {
                for (AnnotationNode annotation : mixinClass.visibleAnnotations) {
                    if (annotation.desc.equals(CLASS_DEPENDENT_MIXIN)) {
                        String neededClass = (String)annotation.values.get(1);
                        MixinService.getService().getBytecodeProvider().getClassNode(neededClass);
                        continue;
                    }
                    if (!annotation.desc.equals(METHOD_DEPENDENT_MIXIN)) continue;
                    String neededMethod = (String)annotation.values.get(1);
                    if (!MixinService.getService().getBytecodeProvider().getClassNode((String)targetClassName).methods.stream().noneMatch(m -> neededMethod.equals(m.name))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.info("Vivecraft: skipping mixin '{}'", (Object)mixinClassName);
            return false;
        }
        return !mixinClassName.contains("NoSodium") || !SodiumHelper.isLoaded();
    }
}

