/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerModel_WithArmsLegs;
import org.vivecraft.client.render.VRPlayerRenderData;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.mca.MCAHelper;

public class VRPlayerModel
extends PlayerModel {
    protected final Vector3f tempV = new Vector3f();
    protected final Vector3f tempV2 = new Vector3f();
    protected final Matrix3f tempM = new Matrix3f();

    public VRPlayerModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        MeshDefinition meshDefinition = PlayerModel.createMesh((CubeDeformation)cubeDeformation, (boolean)slim);
        return meshDefinition;
    }

    public void setupAnim(AvatarRenderState renderState) {
        renderState.isCrouching = renderState.isCrouching & !renderState.isVisuallySwimming;
        super.setupAnim(renderState);
    }

    public static void animateVRModel(PlayerModel model, AvatarRenderState renderState, Vector3f tempV, Vector3f tempV2, Matrix3f tempM) {
        if (model instanceof VRPlayerModel_WithArms) {
            VRPlayerModel_WithArms armsModel = (VRPlayerModel_WithArms)model;
            armsModel.leftHand.visible = model.leftArm.visible;
            armsModel.rightHand.visible = model.rightArm.visible;
        }
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)renderState).vivecraft$getRotInfo();
        VRPlayerRenderData data = ((EntityRenderStateExtension)renderState).vivecraft$getVRRenderData();
        if (rotInfo == null || data == null) {
            return;
        }
        if (data.isMainPlayer()) {
            if (ClientDataHolderVR.getInstance().currentPass == RenderPass.CAMERA && ClientDataHolderVR.getInstance().cameraTracker.isQuickMode() && ClientDataHolderVR.getInstance().grabScreenShot) {
                VRPlayerModel.hideHand(model, HumanoidArm.LEFT, true);
                VRPlayerModel.hideHand(model, HumanoidArm.RIGHT, true);
            }
            if (VREffectsHelper.isFirstPersonEntityPass()) {
                model.head.visible = false;
                model.hat.visible = false;
                if (ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.COMPLETE) {
                    VRPlayerModel.hideHand(model, HumanoidArm.LEFT, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                    VRPlayerModel.hideHand(model, HumanoidArm.RIGHT, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                } else {
                    boolean leftHanded = ClientDataHolderVR.getInstance().vrSettings.reverseHands;
                    if (ClientDataHolderVR.getInstance().menuHandOff) {
                        VRPlayerModel.hideHand(model, leftHanded ? HumanoidArm.RIGHT : HumanoidArm.LEFT, false);
                    }
                    if (ClientDataHolderVR.getInstance().menuHandMain) {
                        VRPlayerModel.hideHand(model, leftHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT, false);
                    }
                }
            }
        }
        float sideOffset = 4.0f * data.bodyScale() + data.armScale();
        if (!data.swimming()) {
            rotInfo.headQuat.transform(0.0f, -0.2f, 0.1f, tempV2);
            tempV2.mul(rotInfo.heightScale * rotInfo.worldScale);
        } else {
            tempV2.zero();
        }
        tempV2.add(rotInfo.headPos);
        float progress = ModelUtils.getBendProgress(renderState.isAutoSpinAttack, renderState.isCrouching, renderState.isPassenger, rotInfo, (Vector3fc)tempV2);
        float heightOffset = 22.0f * progress;
        tempM.set(rotInfo.headQuat).rotateLocalY(data.bodyYaw() + (float)Math.PI).rotateLocalX(-data.xRot());
        ModelUtils.setRotation(model.head, (Matrix3fc)tempM, tempV);
        ModelUtils.worldToModel((HumanoidRenderState)renderState, (Vector3fc)tempV2, rotInfo, data.bodyYaw(), true, tempV);
        if (data.swimming()) {
            tempV.z += 3.0f;
        }
        model.head.setPos(tempV.x, tempV.y, tempV.z);
        model.body.setPos(model.head.x, model.head.y, model.head.z);
        if (renderState.isPassenger) {
            ModelUtils.pointModelAtModelForward(model.body, 0.0f, 14.0f, 2.0f + heightOffset, tempV, tempV2, tempM);
            tempM.rotateLocalX(-data.xRot());
            ModelUtils.setRotation(model.body, (Matrix3fc)tempM, tempV);
        } else if (data.noLowerBodyAnimation()) {
            model.body.setRotation((float)Math.PI * Math.max(0.0f, model.body.y / 22.0f) * (model instanceof VRPlayerModel_WithArmsLegs ? 0.5f : 1.0f), 0.0f, 0.0f);
            if (data.laying()) {
                float bodyXRot;
                if (data.swimming()) {
                    bodyXRot = -data.xRot();
                } else {
                    float aboveGround = (heightOffset - 11.0f) / 11.0f;
                    bodyXRot = progress * ((float)Math.PI - 1.5707964f * (1.0f + 0.3f * (1.0f - aboveGround)));
                }
                model.body.xRot = Mth.lerp((float)data.layAmount(), (float)model.body.xRot, (float)bodyXRot);
                model.head.y -= 2.0f * data.layAmount();
                model.body.y -= 2.0f * data.layAmount();
            }
        } else {
            ModelUtils.pointModelAtLocal((HumanoidRenderState)renderState, model.body, rotInfo.waistPos, rotInfo.waistQuat, rotInfo, data.bodyYaw(), true, tempV, tempV2, tempM);
            tempM.transform(sideOffset, 2.0f, 0.0f, tempV2);
            model.leftArm.x = model.body.x + tempV2.x;
            model.leftArm.y = model.body.y + tempV2.y;
            model.leftArm.z = model.body.z - tempV2.z;
            tempM.transform(-sideOffset, 2.0f, 0.0f, tempV2);
            model.rightArm.x = model.body.x + tempV2.x;
            model.rightArm.y = model.body.y + tempV2.y;
            model.rightArm.z = model.body.z - tempV2.z;
            tempM.rotateLocalX(-data.xRot());
            ModelUtils.setRotation(model.body, (Matrix3fc)tempM, tempV);
        }
        float cosBodyRot = Mth.cos((float)model.body.xRot);
        if (renderState.isPassenger || data.noLowerBodyAnimation()) {
            model.leftArm.x = model.body.x + sideOffset;
            model.rightArm.x = model.body.x - sideOffset;
            model.leftArm.y = 2.0f * cosBodyRot + model.body.y;
            model.leftArm.z = model.body.z;
            model.rightArm.y = model.leftArm.y;
            model.rightArm.z = model.leftArm.z;
        }
        model.leftLeg.x = 1.9f;
        model.rightLeg.x = -1.9f;
        if (renderState.isPassenger) {
            model.rightLeg.z = model.leftLeg.z = heightOffset;
        } else if (data.laying() && data.noLowerBodyAnimation()) {
            if (data.swimming()) {
                tempV.set(0.0f, 12.0f, 0.0f);
                tempV.rotateX(-data.xRot());
                model.leftLeg.y = model.body.y + tempV.y;
                model.leftLeg.z = model.body.z + tempV.z;
            } else {
                float cosBodyRot2 = cosBodyRot * cosBodyRot;
                model.leftLeg.y += 10.25f - 2.0f * cosBodyRot2;
                model.leftLeg.z = model.body.z + 13.0f - cosBodyRot2 * 8.0f;
            }
            model.leftLeg.x += model.body.x;
            model.rightLeg.x += model.body.x;
            model.rightLeg.y = model.leftLeg.y;
            model.rightLeg.z = model.leftLeg.z;
        } else if (rotInfo.fbtMode != FBTMode.ARMS_ONLY) {
            ModelUtils.worldToModel((HumanoidRenderState)renderState, rotInfo.waistPos, rotInfo, data.bodyYaw(), true, tempV);
            tempV2.set(-1.9f, -2.0f, 0.0f);
            rotInfo.waistQuat.transform(tempV2);
            ModelUtils.worldToModelDirection((Vector3fc)tempV2, data.bodyYaw(), tempV2);
            model.leftLeg.setPos(tempV.x + tempV2.x, tempV.y + tempV2.y, tempV.z + tempV2.z);
            tempV2.set(1.9f, -2.0f, 0.0f);
            rotInfo.waistQuat.transform(tempV2);
            ModelUtils.worldToModelDirection((Vector3fc)tempV2, data.bodyYaw(), tempV2);
            model.rightLeg.setPos(tempV.x + tempV2.x, tempV.y + tempV2.y, tempV.z + tempV2.z);
        } else {
            model.leftLeg.x += model.body.x;
            model.rightLeg.x += model.body.x;
        }
        if (!renderState.isPassenger && data.layAmount() < 1.0f && rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
            float newLegY = 12.0f + Math.min(model.body.y, 0.0f);
            float newLegZ = model.body.z + 10.0f * Mth.sin((float)model.body.xRot);
            if (model instanceof VRPlayerModel_WithArmsLegs) {
                newLegY += 10.0f * Mth.sin((float)model.body.xRot);
            }
            model.leftLeg.y = Mth.lerp((float)data.layAmount(), (float)newLegY, (float)model.leftLeg.y);
            model.leftLeg.z = Mth.lerp((float)data.layAmount(), (float)newLegZ, (float)model.leftLeg.z);
            model.rightLeg.y = model.leftLeg.y;
            model.rightLeg.z = model.leftLeg.z;
        }
        if (!rotInfo.seated || data.isMainPlayer()) {
            if (!(model instanceof VRPlayerModel_WithArms) && rotInfo.offHandPos.distanceSquared(rotInfo.mainHandPos) > 0.0f) {
                ModelPart offHand = rotInfo.leftHanded ? model.rightArm : model.leftArm;
                ModelPart mainHand = rotInfo.leftHanded ? model.leftArm : model.rightArm;
                float offset = (rotInfo.leftHanded ? -1.0f : 1.0f) * (model.slim ? 0.016f : 0.032f) * (float)Math.PI * data.armScale();
                ModelUtils.worldToModel((HumanoidRenderState)renderState, rotInfo.mainHandPos, rotInfo, data.bodyYaw(), data.isMainPlayer() || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale, tempV);
                tempV.sub(mainHand.x, mainHand.y, mainHand.z);
                mainHand.y -= 2.0f * Math.max(0.0f, -tempV.y / tempV.length());
                ModelUtils.pointAtModelWithLocal(rotInfo.mainHandQuat, data.bodyYaw(), (Vector3fc)tempV, tempV2, tempM);
                float controllerDist = tempV.length();
                if (!ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && controllerDist > 10.0f) {
                    tempV.normalize().mul(controllerDist - 10.0f);
                    mainHand.x += tempV.x;
                    mainHand.y += tempV.y;
                    mainHand.z += tempV.z;
                    tempM.rotateZ(-offset);
                } else {
                    tempM.rotateZ(-offset * Math.min(10.0f / controllerDist, 1.0f));
                }
                if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && data.attackArm() == data.mainArm()) {
                    ModelUtils.swingAnimation(data.attackArm(), renderState.attackTime, data.isMainPlayer(), tempM, tempV);
                    mainHand.x -= tempV.x;
                    mainHand.y -= tempV.y;
                    mainHand.z += tempV.z;
                }
                tempM.rotateLocalX(-data.xRot());
                ModelUtils.setRotation(mainHand, (Matrix3fc)tempM, tempV);
                ModelUtils.worldToModel((HumanoidRenderState)renderState, rotInfo.offHandPos, rotInfo, data.bodyYaw(), data.isMainPlayer() || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale, tempV);
                tempV.sub(offHand.x, offHand.y, offHand.z);
                offHand.y -= 2.0f * Math.max(0.0f, -tempV.y / tempV.length());
                ModelUtils.pointAtModelWithLocal(rotInfo.offHandQuat, data.bodyYaw(), (Vector3fc)tempV, tempV2, tempM);
                controllerDist = tempV.length();
                if (!ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && controllerDist > 10.0f) {
                    tempV.normalize().mul(controllerDist - 10.0f);
                    offHand.x += tempV.x;
                    offHand.y += tempV.y;
                    offHand.z += tempV.z;
                    tempM.rotateZ(offset);
                } else {
                    tempM.rotateZ(offset * Math.min(10.0f / controllerDist, 1.0f));
                }
                if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && data.attackArm() != data.mainArm()) {
                    ModelUtils.swingAnimation(data.attackArm(), renderState.attackTime, data.isMainPlayer(), tempM, tempV);
                    offHand.x -= tempV.x;
                    offHand.y -= tempV.y;
                    offHand.z += tempV.z;
                }
                if (data.isMainPlayer() && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.set3x3((Matrix3fc)tempM);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateX(-1.5707964f);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateLocalY(-data.bodyYaw() - (float)Math.PI);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.transformDirection(MathUtils.BACK, tempV).mul(0.584f * rotInfo.worldScale);
                    ModelUtils.modelToWorld((HumanoidRenderState)renderState, offHand.x, offHand.y, offHand.z, rotInfo, data.bodyYaw(), true, true, tempV2);
                    if (MCAHelper.isLoaded()) {
                        // empty if block
                    }
                    tempV2.add((Vector3fc)tempV);
                    GuiHandler.GUI_POS_PLAYER_MODEL = new Vec3(renderState.x, renderState.y, renderState.z).add((double)tempV2.x, (double)tempV2.y, (double)tempV2.z);
                }
                tempM.rotateLocalX(-data.xRot());
                ModelUtils.setRotation(offHand, (Matrix3fc)tempM, tempV);
            }
            if (!(renderState.isPassenger || data.noLowerBodyAnimation() || model instanceof VRPlayerModel_WithArmsLegs)) {
                float limbRotation = 0.0f;
                if (ClientDataHolderVR.getInstance().vrSettings.playerWalkAnim) {
                    limbRotation = Mth.cos((float)(renderState.walkAnimationPos * 0.6662f)) * 1.4f * renderState.walkAnimationSpeed;
                }
                ModelUtils.pointModelAtLocal((HumanoidRenderState)renderState, model.rightLeg, rotInfo.rightFootPos, rotInfo.rightFootQuat, rotInfo, data.bodyYaw(), true, tempV, tempV2, tempM);
                tempM.rotateLocalX(limbRotation - data.xRot());
                ModelUtils.setRotation(model.rightLeg, (Matrix3fc)tempM, tempV);
                ModelUtils.pointModelAtLocal((HumanoidRenderState)renderState, model.leftLeg, rotInfo.leftFootPos, rotInfo.leftFootQuat, rotInfo, data.bodyYaw(), true, tempV, tempV2, tempM);
                tempM.rotateLocalX(-limbRotation - data.xRot());
                ModelUtils.setRotation(model.leftLeg, (Matrix3fc)tempM, tempV);
            }
        }
        if (data.layAmount() > 0.0f) {
            if (data.noLowerBodyAnimation()) {
                model.body.xRot += data.xRot();
            }
            if (model instanceof VRPlayerModel_WithArmsLegs) {
                ModelUtils.applySwimRotationOffset((HumanoidRenderState)renderState, data.xRot(), tempV, tempV2, model.head, model.body);
            } else if (model instanceof VRPlayerModel_WithArms) {
                ModelUtils.applySwimRotationOffset((HumanoidRenderState)renderState, data.xRot(), tempV, tempV2, model.head, model.body, model.leftLeg, model.rightLeg);
            } else {
                ModelUtils.applySwimRotationOffset((HumanoidRenderState)renderState, data.xRot(), tempV, tempV2, model.head, model.body, model.leftArm, model.rightArm, model.leftLeg, model.rightLeg);
            }
        }
        model.rightArm.xScale = model.rightArm.zScale = data.armScale();
        model.leftArm.zScale = model.rightArm.zScale;
        model.leftArm.xScale = model.rightArm.zScale;
        model.body.xScale = model.body.zScale = data.bodyScale();
        model.rightLeg.xScale = model.rightLeg.zScale = data.legScale();
        model.leftLeg.zScale = model.rightLeg.zScale;
        model.leftLeg.xScale = model.rightLeg.zScale;
        if (renderState.isAutoSpinAttack) {
            VRPlayerModel.spinOffset(model.head, model.body);
            if (!(model instanceof VRPlayerModel_WithArms)) {
                VRPlayerModel.spinOffset(model.leftArm, model.rightArm);
            }
            if (!(model instanceof VRPlayerModel_WithArmsLegs)) {
                VRPlayerModel.spinOffset(model.leftLeg, model.rightLeg);
            }
        }
    }

    private static void hideHand(PlayerModel model, HumanoidArm arm, boolean completeArm) {
        if (model instanceof VRPlayerModel) {
            VRPlayerModel vrModel = (VRPlayerModel)model;
            if (arm == HumanoidArm.LEFT) {
                vrModel.hideLeftArm(completeArm);
            } else {
                vrModel.hideRightArm(completeArm);
            }
        } else if (arm == HumanoidArm.LEFT) {
            model.leftArm.visible = false;
        } else {
            model.rightArm.visible = false;
        }
    }

    public void hideLeftArm(boolean completeArm) {
        this.leftArm.visible = false;
    }

    public void hideRightArm(boolean onlyHand) {
        this.rightArm.visible = false;
    }

    protected static void spinOffset(ModelPart ... parts) {
        for (ModelPart part : parts) {
            part.y += 24.0f;
        }
    }

    public void translateToHand(AvatarRenderState avatarRenderState, HumanoidArm side, PoseStack poseStack) {
        this.getArm(side).translateAndRotate(poseStack);
        if (this.slim) {
            poseStack.translate(side == HumanoidArm.RIGHT ? 0.03125f : -0.03125f, 0.0f, 0.0f);
        }
        this.doAttackAnim(avatarRenderState, side, poseStack);
    }

    protected void doAttackAnim(AvatarRenderState avatarRenderState, HumanoidArm side, PoseStack poseStack) {
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)avatarRenderState).vivecraft$getRotInfo();
        if (rotInfo != null && avatarRenderState.attackTime > 0.0f && side == (rotInfo.leftHanded ? avatarRenderState.attackArm.getOpposite() : avatarRenderState.attackArm)) {
            poseStack.translate(0.0f, 0.5f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotation(Mth.sin((float)(avatarRenderState.attackTime * (float)Math.PI))));
            poseStack.translate(0.0f, -0.5f, 0.0f);
        }
    }
}

