/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import com.bhaptics.haptic.models.PositionType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.bodylink.Haptics;
import org.vivecraft.client_vr.bodylink.RiggedBody;
import org.vivecraft.common.network.packet.c2s.DamageDirectionPayloadC2S;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;

public class HapticTracker
implements Tracker {
    private static final int HUNGER_THRESHOLD = 15;
    private static final double MAX_EXPLOSION_DIST = 5.0;
    private final Random random = new Random();
    private final ArrayList<HapticsModule> modules = new ArrayList();
    private float lastHealth;
    private Vector3fc lastHitDirection = null;
    private float lastVanillaHurtYaw = 0.0f;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public HapticTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
        this.modules.add(new RainModule());
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        return player != null && Haptics.isConnected();
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        RiggedBody.getInstance().updatePose(this.dh.vrPlayer.getVRDataWorld());
        if (ClientNetworking.USED_NETWORK_VERSION >= 6 && !ClientNetworking.REQUESTED_DAMAGE_DIRECTION) {
            ClientNetworking.sendServerPacket(new DamageDirectionPayloadC2S());
            ClientNetworking.REQUESTED_DAMAGE_DIRECTION = true;
        }
        float thresholdLowHealth = 5.0f;
        float thresholdCriticalHealth = 2.0f;
        Haptics.setLoopState(Haptics.Animations.FIRE, player.isOnFire());
        Haptics.setLoopState(Haptics.Animations.POTION_POSITIVE, this.hasPotionPositive(player));
        Haptics.setLoopState(Haptics.Animations.POTION_NEGATIVE, this.hasPotionNegative(player));
        Haptics.setLoopState(Haptics.Animations.LOW_HEALTH, player.getHealth() < thresholdLowHealth && !(player.getHealth() < thresholdCriticalHealth));
        Haptics.setLoopState(Haptics.Animations.CRITICAL_HEALTH, player.getHealth() < thresholdCriticalHealth);
        Haptics.setLoopState(Haptics.Animations.RAIN, this.isInRain(player));
        for (HapticsModule module : this.modules) {
            if (!module.enabled) continue;
            module.tick(player);
        }
        if (player.getHealth() != this.lastHealth) {
            float damage = this.lastHealth - player.getHealth();
            if (damage > 0.0f) {
                this.handleHit(player.getLastDamageSource(), damage);
            }
            this.lastHealth = player.getHealth();
        }
        this.doHunger(player);
        Haptics.tick();
    }

    private void doHunger(LocalPlayer player) {
        float foodPerc;
        int food = player.getFoodData().getFoodLevel();
        if (food < 15 && this.random.nextInt(60 + (int)((foodPerc = (float)food / 20.0f) * 30.0f * 20.0f)) == 0) {
            Haptics.getAnimation(Haptics.Animations.HUNGER).playSingle(false, null);
        }
    }

    private boolean hasPotionPositive(LocalPlayer player) {
        for (MobEffectInstance effect : player.getActiveEffects()) {
            if (!((MobEffect)effect.getEffect().value()).isBeneficial() || effect.isAmbient()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPotionNegative(LocalPlayer player) {
        return player.getActiveEffects().stream().anyMatch(effect -> ((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && !effect.isAmbient());
    }

    private boolean isInRain(LocalPlayer player) {
        BlockPos blockpos = player.blockPosition();
        return player.level().isRainingAt(blockpos) || player.level().isRainingAt(new BlockPos(blockpos.getX(), (int)player.getBoundingBox().maxY, blockpos.getZ()));
    }

    private void handleHit(DamageSource damageSrc, float damageAmount) {
        Vector3fc dmgVec = null;
        if (damageSrc != null) {
            dmgVec = Utils.getDirFromDamageSource(damageSrc, (Entity)this.mc.player);
        }
        if (dmgVec == null || MathUtils.isZero(dmgVec)) {
            if (this.lastHitDirection != null) {
                dmgVec = this.lastHitDirection;
            } else if (this.lastVanillaHurtYaw != this.mc.player.getHurtDir()) {
                this.lastVanillaHurtYaw = this.mc.player.getHurtDir();
                dmgVec = new Vector3f(1.0f, 0.0f, 0.0f).rotateY((-this.lastVanillaHurtYaw - this.mc.player.getYRot()) * ((float)Math.PI / 180));
            }
        }
        this.lastHitDirection = null;
        if (dmgVec != null && !MathUtils.isZero(dmgVec)) {
            if (dmgVec.y() == 1.0f) {
                Haptics.getAnimation(Haptics.Animations.TOP_HIT).playSingle(true, null);
            } else if (dmgVec.y() == -1.0f) {
                Haptics.getAnimation(Haptics.Animations.BOTTOM_HIT).playSingle(true, null);
            } else {
                dmgVec = dmgVec.rotateY(this.dh.vrPlayer.getVRDataWorld().getBodyYawRad() + (float)Math.PI, new Vector3f());
                Haptics.getAnimation(Haptics.Animations.GENERIC_HIT).playSingle(true, dmgVec);
            }
        } else {
            Haptics.getAnimation(Haptics.Animations.ALL_AROUND_HIT).playSingle(true, null);
        }
    }

    public void handleExplode(Vec3 explosionPos) {
        double explosionDist;
        if (this.isActive(this.mc.player) && (explosionDist = explosionPos.subtract(this.mc.player.position()).length()) < 5.0) {
            double distFactor = 1.0 - explosionDist / 5.0;
            Haptics.getAnimation(Haptics.Animations.EXPLOSION).playSingle(true, null, distFactor);
        }
    }

    public void handleEat(ItemStack itemStack) {
        if (this.isActive(this.mc.player) && itemStack.get(DataComponents.FOOD) != null && itemStack.get(DataComponents.CONSUMABLE) != null) {
            if (((Consumable)itemStack.get(DataComponents.CONSUMABLE)).onConsumeEffects().isEmpty()) {
                Haptics.getAnimation(Haptics.Animations.CONSUME).playSingle(true, null);
            } else {
                Haptics.getAnimation(Haptics.Animations.CONSUME_EFFECT).playSingle(true, null);
            }
        }
    }

    public void setLastHitDirection(Vector3fc lastHitDirection) {
        this.lastHitDirection = lastHitDirection;
    }

    private static class RainModule
    extends HapticsModule {
        private static final double MIN_ANGLE = 0.0;
        private static final double DROP_CHANCE_THRESHOLD = 0.2;
        Random random = new Random();

        public RainModule() {
            this.enabled = false;
        }

        @Override
        void tick(LocalPlayer player) {
            if (!player.level().isRaining()) {
                return;
            }
            boolean isSnow = ((Biome)player.level().getBiome(player.blockPosition()).value()).coldEnoughToSnow(player.blockPosition(), player.level().getSeaLevel());
            Vec3 rainFall = new Vec3(0.0, -9.0, 0.0);
            Vector3f rainDir = MathUtils.subtractToVector3f(rainFall, player.getDeltaMovement()).normalize().mul(-1.0f);
            ArrayList<RiggedBody.HapticPoint> points = RiggedBody.getInstance().getHapticPoints(PositionType.All);
            for (RiggedBody.HapticPoint p : points) {
                double snowFactor;
                if (!player.level().isRainingAt(player.blockPosition())) continue;
                Vector3f normal = p.getNormal(true);
                double exposure = normal.dot((Vector3fc)rainDir);
                if (exposure < 0.0) {
                    exposure = 0.0;
                }
                double d = snowFactor = isSnow ? 2.0 : 1.0;
                if (!(Math.abs(this.random.nextGaussian()) * exposure > 0.2 * snowFactor)) continue;
                int intensity = 10;
                int duration = 10;
                p.motor.dot(intensity, duration);
            }
        }
    }

    private static abstract class HapticsModule {
        boolean enabled = false;

        private HapticsModule() {
        }

        abstract void tick(LocalPlayer var1);
    }
}

