/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.rendertypes;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import org.vivecraft.client_vr.render.VRShaders;

public class VRRenderTypes {
    private static final BiFunction<GpuTextureView, Boolean, RenderType> ENTITY_TRANSLUCENT_NO_CARDINAL_LIGHT = Util.memoize((gpuTexture, depthAlways) -> RenderType.create((String)"entity_translucent_vr", (int)1536, (boolean)true, (boolean)true, (RenderPipeline)(depthAlways != false ? VRShaders.ENTITY_TRANSLUCENT_ALWAYS_NO_CARDINAL_LIGHT : VRShaders.ENTITY_TRANSLUCENT_NO_CARDINAL_LIGHT), (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(gpuTexture)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false)));
    private static final Function<GpuTextureView, RenderType> ENTITY_SOLID_NO_CARDINAL_LIGHT = Util.memoize(gpuTexture -> RenderType.create((String)"entity_solid_vr", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)VRShaders.ENTITY_SOLID_NO_CARDINAL_LIGHT, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(gpuTexture)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false)));
    private static final BiFunction<GpuTextureView, Boolean, RenderType> ENTITY_CUTOUT_NO_CARDINAL_LIGHT = Util.memoize((gpuTexture, depthAlways) -> RenderType.create((String)"entity_cutout_vr", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)(depthAlways != false ? VRShaders.ENTITY_CUTOUT_NO_CULL_ALWAYS_NO_CARDINAL_LIGHT : VRShaders.ENTITY_CUTOUT_NO_CULL_NO_CARDINAL_LIGHT), (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(gpuTexture)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false)));
    private static final Function<GpuTextureView, RenderType> GUI_TEXTURED_ALWAYS = Util.memoize(gpuTexture -> RenderType.create((String)"gui_textured_always_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.GUI_TEXTURED_ALWAYS, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(gpuTexture)).createCompositeState(false)));
    private static final Function<ResourceLocation, RenderType> GUI_TEXTURED = Util.memoize(resourceLocation -> RenderType.create((String)"gui_textured_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.GUI_TEXTURED, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(resourceLocation)).createCompositeState(false)));
    private static final RenderType END_PORTAL_VR = RenderType.create((String)"end_portal_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.END_PORTAL_VR_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(TheEndPortalRenderer.END_SKY_LOCATION, false).add(TheEndPortalRenderer.END_PORTAL_LOCATION, false).build()).createCompositeState(false));
    private static final RenderType END_GATEWAY_VR = RenderType.create((String)"end_gateway_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.END_GATEWAY_VR_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(TheEndPortalRenderer.END_SKY_LOCATION, false).add(TheEndPortalRenderer.END_PORTAL_LOCATION, false).build()).createCompositeState(false));
    private static final BiFunction<ResourceLocation, Boolean, RenderType> CROSSHAIR_WORLD = Util.memoize((resourceLocation, depthAlways) -> RenderType.create((String)"crosshair_world_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)(depthAlways != false ? VRShaders.CROSSHAIR_WORLD_ALWAYS : VRShaders.CROSSHAIR_WORLD), (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(resourceLocation)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false)));
    private static final RenderType QUADS = RenderType.create((String)"quads_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.QUADS, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    private static final RenderType QUADS_ALWAYS = RenderType.create((String)"quads_always_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.QUADS_ALWAYS, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    private static final RenderType TRIANGLES_ALWAYS = RenderType.create((String)"triangles_always_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.TRIANGLES_ALWAYS, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    private static final RenderType TRIANGLE_FAN_ALWAYS = RenderType.create((String)"triangle_fan_always_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.TRIANGLE_FAN_ALWAYS, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    private static final Function<ResourceLocation, RenderType> TEXT_NO_CULL = Util.memoize(resourceLocation -> RenderType.create((String)"text_no_cull_vr", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)VRShaders.TEXT_NO_CULL, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(resourceLocation)).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false)));
    private static final Function<ResourceLocation, RenderType> WEATHER_NO_LIGHTMAP_CHANGE = Util.memoize(resourceLocation -> RenderType.create((String)"weather_menuworld", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.WEATHER_NO_DEPTH_WRITE, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(VRRenderTypes.getTextureState(resourceLocation)).createCompositeState(false)));

    private static RenderStateShard.EmptyTextureStateShard getTextureState(GpuTextureView texture) {
        return new RenderStateShard.EmptyTextureStateShard(() -> RenderSystem.setShaderTexture((int)0, (GpuTextureView)texture), () -> {});
    }

    private static RenderStateShard.EmptyTextureStateShard getTextureState(ResourceLocation resourceLocation) {
        return new RenderStateShard.TextureStateShard(resourceLocation, false);
    }

    public static RenderType crosshairWorld(ResourceLocation resourceLocation, boolean depthAlways) {
        return CROSSHAIR_WORLD.apply(resourceLocation, depthAlways);
    }

    public static RenderType quads(boolean depthAlways) {
        return depthAlways ? QUADS_ALWAYS : QUADS;
    }

    public static RenderType trianglesAlways() {
        return TRIANGLES_ALWAYS;
    }

    public static RenderType triangleFanAlways() {
        return TRIANGLE_FAN_ALWAYS;
    }

    public static RenderType endGateWayVR() {
        return END_GATEWAY_VR;
    }

    public static RenderType endPortalVR() {
        return END_PORTAL_VR;
    }

    public static RenderType entitySolidNoCardinalLight(GpuTextureView texture) {
        return ENTITY_SOLID_NO_CARDINAL_LIGHT.apply(texture);
    }

    public static RenderType entityCutoutNoCardinalLight(GpuTextureView texture, boolean depthAlways) {
        return ENTITY_CUTOUT_NO_CARDINAL_LIGHT.apply(texture, depthAlways);
    }

    public static RenderType entityTranslucentNoCardinalLight(GpuTextureView texture, boolean depthAlways) {
        return ENTITY_TRANSLUCENT_NO_CARDINAL_LIGHT.apply(texture, depthAlways);
    }

    public static RenderType guiTextured(ResourceLocation resourceLocation) {
        return GUI_TEXTURED.apply(resourceLocation);
    }

    public static RenderType guiTextureAlways(GpuTextureView texture) {
        return GUI_TEXTURED_ALWAYS.apply(texture);
    }

    public static RenderType textNoCull(ResourceLocation resourceLocation) {
        return TEXT_NO_CULL.apply(resourceLocation);
    }

    public static RenderType weatherNoLightmapChange(ResourceLocation resourceLocation) {
        return WEATHER_NO_LIGHTMAP_CHANGE.apply(resourceLocation);
    }
}

