/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.api_impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.vivecraft.api.VRAPI;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.api_impl.VRClientAPIImpl;
import org.vivecraft.common.api_impl.data.VRPoseHistoryImpl;
import org.vivecraft.server.ServerVRPlayers;

public final class VRAPIImpl
implements VRAPI {
    public static final VRAPIImpl INSTANCE = new VRAPIImpl();
    public static final int MAX_HISTORY_TICKS = 200;
    private final Map<UUID, VRPoseHistoryImpl> clientPoseHistories = new HashMap<UUID, VRPoseHistoryImpl>();
    private final Map<UUID, VRPoseHistoryImpl> serverPoseHistories = new HashMap<UUID, VRPoseHistoryImpl>();

    private VRAPIImpl() {
    }

    public void clearPoseHistory(UUID player, boolean isClientSide) {
        this.getMap(isClientSide).remove(player);
    }

    public void addPoseToHistory(UUID player, VRPose pose, boolean isClientSide) {
        Map<UUID, VRPoseHistoryImpl> poseHistories = this.getMap(isClientSide);
        VRPoseHistoryImpl poseHistory = poseHistories.get(player);
        if (poseHistory == null) {
            poseHistory = new VRPoseHistoryImpl();
            poseHistories.put(player, poseHistory);
        }
        poseHistory.addPose(pose);
    }

    public void clearAllPoseHistories() {
        this.clientPoseHistories.clear();
        this.serverPoseHistories.clear();
        VRClientAPIImpl.INSTANCE.clearPoseHistory();
    }

    @Override
    public boolean isVRPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return ServerVRPlayers.isVRPlayer(serverPlayer);
        }
        return ClientVRPlayers.getInstance().isVRPlayer((Entity)player);
    }

    @Override
    @Nullable
    public VRPose getVRPose(Player player) {
        if (!this.isVRPlayer(player)) {
            return null;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return ServerVRPlayers.getVivePlayer(serverPlayer).asVRPose();
        }
        return ClientVRPlayers.getInstance().getRotationsForPlayer(player.getUUID()).asVRPose(player.position());
    }

    @Override
    @Nullable
    public VRPoseHistory getHistoricalVRPoses(Player player) {
        if (player.isLocalPlayer()) {
            return VRClientAPIImpl.INSTANCE.getHistoricalVRPoses();
        }
        if (this.isVRPlayer(player)) {
            return this.getMap(player.level().isClientSide()).get(player.getUUID());
        }
        return null;
    }

    private Map<UUID, VRPoseHistoryImpl> getMap(boolean isClientSide) {
        return isClientSide ? this.clientPoseHistories : this.serverPoseHistories;
    }
}

