/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.api_impl.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;

public class VRPoseHistoryImpl
implements VRPoseHistory {
    private final LinkedList<VRPose> dataQueue = new LinkedList();

    public void addPose(VRPose pose) {
        this.dataQueue.addFirst(pose);
        if (this.dataQueue.size() > 201) {
            this.dataQueue.removeLast();
        }
    }

    public void clear() {
        this.dataQueue.clear();
    }

    public boolean isEmpty() {
        return this.dataQueue.isEmpty();
    }

    @Override
    public int ticksOfHistory() {
        return this.dataQueue.size() - 1;
    }

    @Override
    public List<VRPose> getAllHistoricalData() {
        return List.copyOf(this.dataQueue);
    }

    @Override
    public VRPose getHistoricalData(int ticksBack) throws IllegalArgumentException {
        this.checkTicksBack(ticksBack);
        if (this.dataQueue.size() <= ticksBack) {
            return null;
        }
        return this.dataQueue.get(ticksBack);
    }

    @Override
    public Vec3 netMovement(VRBodyPart bodyPart, int maxTicksBack) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return Vec3.ZERO;
        }
        VRBodyPartData currentData = this.dataQueue.getFirst().getBodyPartData(bodyPart);
        if (currentData == null) {
            return null;
        }
        Vec3 current = currentData.getPos();
        VRBodyPartData oldData = this.dataQueue.get(maxTicksBack).getBodyPartData(bodyPart);
        if (oldData == null) {
            return null;
        }
        Vec3 old = oldData.getPos();
        return current.subtract(old);
    }

    @Override
    public Vec3 averageVelocity(VRBodyPart bodyPart, int maxTicksBack) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return Vec3.ZERO;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Vec3> diffs = new ArrayList<Vec3>(maxTicksBack);
        for (int i = 0; i <= maxTicksBack; ++i) {
            VRBodyPartData newer = this.dataQueue.get(i).getBodyPartData(bodyPart);
            VRBodyPartData older = this.dataQueue.get(i + 1).getBodyPartData(bodyPart);
            if (newer == null || older == null) break;
            diffs.add(newer.getPos().subtract(older.getPos()));
        }
        if (diffs.isEmpty()) {
            return this.dataQueue.getFirst().getBodyPartData(bodyPart) != null ? Vec3.ZERO : null;
        }
        return new Vec3(diffs.stream().mapToDouble(vec -> vec.x).average().orElse(0.0), diffs.stream().mapToDouble(vec -> vec.y).average().orElse(0.0), diffs.stream().mapToDouble(vec -> vec.z).average().orElse(0.0));
    }

    @Override
    public double averageSpeed(VRBodyPart bodyPart, int maxTicksBack) throws IllegalArgumentException {
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.size() <= 1) {
            return 0.0;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Double> speeds = new ArrayList<Double>(maxTicksBack);
        for (int i = 0; i <= maxTicksBack; ++i) {
            VRBodyPartData newer = this.dataQueue.get(i).getBodyPartData(bodyPart);
            VRBodyPartData older = this.dataQueue.get(i + 1).getBodyPartData(bodyPart);
            if (newer == null || older == null) break;
            speeds.add(newer.getPos().distanceTo(older.getPos()));
        }
        return speeds.stream().mapToDouble(Double::valueOf).average().orElse(0.0);
    }

    @Override
    public Vec3 averagePosition(VRBodyPart bodyPart, int maxTicksBack) throws IllegalArgumentException {
        VRPose pose;
        VRBodyPartData data;
        this.checkPartNonNull(bodyPart);
        this.checkTicksBack(maxTicksBack);
        if (this.dataQueue.isEmpty()) {
            return null;
        }
        maxTicksBack = this.getNumTicksBack(maxTicksBack);
        ArrayList<Vec3> positions = new ArrayList<Vec3>(maxTicksBack);
        int i = 0;
        Iterator iterator = this.dataQueue.iterator();
        while (iterator.hasNext() && (data = (pose = (VRPose)iterator.next()).getBodyPartData(bodyPart)) != null) {
            positions.add(data.getPos());
            if (++i < maxTicksBack) continue;
            break;
        }
        if (positions.isEmpty()) {
            return null;
        }
        return new Vec3(positions.stream().mapToDouble(vec -> vec.x).average().orElse(0.0), positions.stream().mapToDouble(vec -> vec.y).average().orElse(0.0), positions.stream().mapToDouble(vec -> vec.z).average().orElse(0.0));
    }

    private void checkTicksBack(int ticksBack) {
        if (ticksBack < 0 || ticksBack > 200) {
            throw new IllegalArgumentException("Value must be between 0 and 200.");
        }
    }

    private void checkPartNonNull(VRBodyPart bodyPart) {
        if (bodyPart == null) {
            throw new IllegalArgumentException("Cannot get data for a null body part!");
        }
    }

    private int getNumTicksBack(int maxTicksBack) {
        if (this.dataQueue.size() <= maxTicksBack) {
            return this.dataQueue.size() - 1;
        }
        return maxTicksBack;
    }
}

