/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer.entity;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.PlayerModelType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client_vr.extensions.EntityRenderDispatcherVRExtension;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.render.VRArmRenderer;
import org.vivecraft.client_xr.render_pass.RenderPassType;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherVRMixin
implements EntityRenderDispatcherVRExtension {
    @Unique
    private final Map<PlayerModelType, VRArmRenderer> vivecraft$armSkinMap = new HashMap<PlayerModelType, VRArmRenderer>();
    @Shadow
    public Camera camera;

    @Inject(method={"distanceToSqr*"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$checkCameraNull(CallbackInfoReturnable<Double> cir) {
        if (this.camera == null) {
            cir.setReturnValue((Object)0.0);
        }
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderers;createAvatarRenderers(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)Ljava/util/Map;", ordinal=0)})
    private void vivecraft$reload(ResourceManager resourceManager, CallbackInfo ci, @Local EntityRendererProvider.Context context) {
        this.vivecraft$armSkinMap.put(PlayerModelType.WIDE, new VRArmRenderer(context, false));
        this.vivecraft$armSkinMap.put(PlayerModelType.SLIM, new VRArmRenderer(context, true));
    }

    @Inject(method={"extractEntity(Lnet/minecraft/world/entity/Entity;F)Lnet/minecraft/client/renderer/entity/state/EntityRenderState;"}, at={@At(value="HEAD")})
    private void vivecraft$storeEntityAndRestorePos(CallbackInfoReturnable<EntityRenderState> cir, @Local(argsOnly=true) Entity entity, @Share(value="capturedEntity") LocalRef<Entity> capturedEntity) {
        if (!RenderPassType.isVanilla() && this.camera != null && entity == this.camera.getEntity()) {
            capturedEntity.set((Object)entity);
            ((GameRendererExtension)Minecraft.getInstance().gameRenderer).vivecraft$restoreRVEPos((Entity)capturedEntity.get());
        }
    }

    @Inject(method={"extractEntity(Lnet/minecraft/world/entity/Entity;F)Lnet/minecraft/client/renderer/entity/state/EntityRenderState;"}, at={@At(value="TAIL")})
    private void vivecraft$clearEntityAndSetupPos(CallbackInfoReturnable<EntityRenderState> cir, @Local(argsOnly=true) Entity entity, @Share(value="capturedEntity") LocalRef<Entity> capturedEntity) {
        if (capturedEntity.get() != null) {
            ((GameRendererExtension)Minecraft.getInstance().gameRenderer).vivecraft$cacheRVEPos((Entity)capturedEntity.get());
            ((GameRendererExtension)Minecraft.getInstance().gameRenderer).vivecraft$setupRVE();
        }
    }

    @Override
    @Unique
    public Map<PlayerModelType, VRArmRenderer> vivecraft$getArmSkinMap() {
        return this.vivecraft$armSkinMap;
    }
}

