/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.gui.framework.widgets.MultilineComponent;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.common.utils.MathUtils;

public class FBTCalibrationScreen
extends Screen {
    private static final Vec3i COLOR_INACTIVE = new Vec3i(128, 64, 64);
    private static final Vec3i COLOR_ACTIVE = new Vec3i(64, 128, 64);
    private static final byte ALPHA = -56;
    private final Screen parent;
    private final boolean wasFbtCalibrated;
    private final boolean wasFbtExtendedCalibrated;
    private final Vector3fc[] oldFbtOffsets;
    private final Quaternionfc[] oldFbtRotations;
    private boolean calibrated = false;
    private boolean usingUnlabeledTrackers = false;
    private boolean rightHandAtPosition = false;
    private boolean leftHandAtPosition = false;
    private Vector3f rightHand = new Vector3f();
    private Vector3f leftHand = new Vector3f();
    private float yaw;
    private MultilineComponent calibrationText;
    private MultilineComponent unlabeledTrackersWarningText;
    private MultilineComponent unlabeledTrackersConfirmationText;
    private Button resetButton;
    private Button cancelButton;

    public FBTCalibrationScreen(Screen parent) {
        super((Component)Component.translatable((String)"vivecraft.options.screen.fbtcalibration"));
        this.parent = parent;
        this.wasFbtCalibrated = ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated;
        this.wasFbtExtendedCalibrated = ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated;
        this.oldFbtOffsets = new Vector3fc[ClientDataHolderVR.getInstance().vrSettings.fbtOffsets.length];
        this.oldFbtRotations = new Quaternionfc[ClientDataHolderVR.getInstance().vrSettings.fbtRotations.length];
        for (int i = 0; i < this.oldFbtOffsets.length; ++i) {
            this.oldFbtOffsets[i] = new Vector3f((Vector3fc)ClientDataHolderVR.getInstance().vrSettings.fbtOffsets[i]);
            this.oldFbtRotations[i] = new Quaternionf((Quaternionfc)ClientDataHolderVR.getInstance().vrSettings.fbtRotations[i]);
        }
        ClientDataHolderVR.getInstance().showedFbtCalibrationNotification = true;
        ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = false;
        if (VRState.VR_INITIALIZED) {
            boolean fbt = ClientDataHolderVR.getInstance().vr.hasFBT();
            boolean extended = ClientDataHolderVR.getInstance().vr.hasExtendedFBT();
            int trackers = ClientDataHolderVR.getInstance().vr.getTrackers().size();
            this.usingUnlabeledTrackers = ClientDataHolderVR.getInstance().vrSettings.unlabeledTrackersUsed || !extended && trackers >= 7 || !fbt && trackers >= 3;
        }
    }

    private void reset() {
        this.calibrated = false;
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vr.resetFBT();
        }
        ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.unlabeledTrackersUsed = this.usingUnlabeledTrackers;
        ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        this.cancelButton.setMessage((Component)Component.translatable((String)"gui.cancel"));
        this.resetButton.visible = false;
    }

    public boolean isCalibrated() {
        return this.calibrated;
    }

    protected void init() {
        this.calibrationText = new MultilineComponent(this.width / 2, 30, 400, (Component)Component.translatable((String)"vivecraft.messages.fbtcalibration"), true, this.font);
        this.unlabeledTrackersWarningText = new MultilineComponent(this.width / 2, this.calibrationText.getY() + this.calibrationText.getHeight(), 400, (Component)Component.translatable((String)"vivecraft.messages.fbtcalibration.unlabeledTrackers"), true, this.font);
        this.unlabeledTrackersWarningText.visible = this.usingUnlabeledTrackers;
        this.unlabeledTrackersConfirmationText = new MultilineComponent(this.width / 2, 30, 400, (Component)Component.translatable((String)"vivecraft.messages.fbtcalibration.unlabeledTrackersConfirm"), true, this.font);
        this.unlabeledTrackersConfirmationText.visible = false;
        this.resetButton = Button.builder((Component)Component.translatable((String)"controls.reset"), p -> this.reset()).pos(this.width / 2 - 75, this.height - 54).width(150).build();
        this.resetButton.visible = this.calibrated;
        this.cancelButton = Button.builder((Component)Component.translatable((String)(this.calibrated ? "vivecraft.gui.ok" : "gui.cancel")), p -> this.minecraft.setScreen(this.parent)).pos(this.width / 2 - 75, this.height - 32).width(150).build();
        this.addRenderableWidget((GuiEventListener)this.calibrationText);
        this.addRenderableWidget((GuiEventListener)this.unlabeledTrackersWarningText);
        this.addRenderableWidget((GuiEventListener)this.unlabeledTrackersConfirmationText);
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        if (VRState.VR_RUNNING) {
            this.yaw = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getYawRad();
        }
    }

    public void removed() {
        if (!this.calibrated) {
            ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = this.wasFbtCalibrated;
            ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = this.wasFbtExtendedCalibrated;
            for (int i = 0; i < this.oldFbtOffsets.length; ++i) {
                ClientDataHolderVR.getInstance().vrSettings.fbtOffsets[i].set(this.oldFbtOffsets[i]);
                ClientDataHolderVR.getInstance().vrSettings.fbtRotations[i].set(this.oldFbtRotations[i]);
            }
            ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.calibrationText.visible = !this.calibrated;
        this.unlabeledTrackersWarningText.visible = !this.calibrated && this.usingUnlabeledTrackers;
        this.unlabeledTrackersConfirmationText.visible = this.calibrated && this.usingUnlabeledTrackers;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.calibrated || !this.usingUnlabeledTrackers) {
            guiGraphics.renderOutline(guiGraphics.guiWidth() / 2 - 64, guiGraphics.guiHeight() - 32 - 96, 48, 16, -1);
            guiGraphics.renderOutline(guiGraphics.guiWidth() / 2 + 16, guiGraphics.guiHeight() - 32 - 96, 48, 16, -1);
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)guiGraphics.guiWidth() / 2.0f, (float)guiGraphics.guiHeight() - 32.0f, 0.0f);
            poseStack.scale(4.0f, -4.0f, 4.0f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
            if (VRState.VR_RUNNING) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotation(this.yaw - ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getYawRad()));
            }
            Vec3i color = this.leftHandAtPosition && this.rightHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE;
            RenderType renderType = VRRenderTypes.quads(true);
            VertexConsumer builder = this.minecraft.renderBuffers().bufferSource().getBuffer(renderType);
            RenderHelper.renderBox(builder, new Vec3(2.0, 0.0, 0.0), new Vec3(2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack.last().pose());
            RenderHelper.renderBox(builder, new Vec3(-2.0, 0.0, 0.0), new Vec3(-2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack.last().pose());
            RenderHelper.renderBox(builder, new Vec3(0.0, 12.0, 0.0), new Vec3(0.0, 24.0, 0.0), 8.0f, 4.0f, color, (byte)-56, poseStack.last().pose());
            RenderHelper.renderBox(builder, new Vec3(0.0, 24.0, 0.0), new Vec3(0.0, 32.0, 0.0), 8.0f, 8.0f, color, (byte)-56, poseStack.last().pose());
            RenderHelper.renderBox(builder, new Vec3(6.0, 22.0, 0.0).subtract((double)(this.leftHand.x * 2.0f), (double)(this.leftHand.y * 2.0f), (double)(this.leftHand.z * 2.0f)), new Vec3(6.0, 22.0, 0.0).add((double)(this.leftHand.x * 10.0f), (double)(this.leftHand.y * 10.0f), (double)(this.leftHand.z * 10.0f)), 4.0f, 4.0f, this.leftHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack.last().pose());
            RenderHelper.renderBox(builder, new Vec3(-6.0, 22.0, 0.0).subtract((double)(this.rightHand.x * 2.0f), (double)(this.rightHand.y * 2.0f), (double)(this.rightHand.z * 2.0f)), new Vec3(-6.0, 22.0, 0.0).add((double)(this.rightHand.x * 10.0f), (double)(this.rightHand.y * 10.0f), (double)(this.rightHand.z * 10.0f)), 4.0f, 4.0f, this.rightHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack.last().pose());
            this.minecraft.renderBuffers().bufferSource().endBatch(renderType);
            poseStack.popPose();
        }
    }

    public void tick() {
        boolean leftHandNew;
        if (!VRState.VR_RUNNING) {
            this.rightHand.set(MathUtils.DOWN);
            this.leftHand.set(MathUtils.DOWN);
            return;
        }
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        Vector3f hmdPosAvg = dataHolder.vr.hmdPivotHistory.averagePosition(0.5);
        float height = hmdPosAvg.y / 1.52f;
        float scale = height * 0.9375f;
        int main = dataHolder.vrSettings.reverseHands ? 1 : 0;
        this.rightHand = dataHolder.vrPlayer.vrdata_room_post.getController(main).getPositionF().sub(hmdPosAvg.x, 1.375f * scale, hmdPosAvg.z).rotateY(this.yaw).add(scale * 0.375f, 0.0f, 0.0f).normalize();
        this.leftHand = dataHolder.vrPlayer.vrdata_room_post.getController(1 - main).getPositionF().sub(hmdPosAvg.x, 1.375f * scale, hmdPosAvg.z).rotateY(this.yaw).add(-scale * 0.375f, 0.0f, 0.0f).normalize();
        boolean rightHandNew = this.rightHand.dot(MathUtils.RIGHT) > 0.9f;
        boolean bl = leftHandNew = this.leftHand.dot(MathUtils.LEFT) > 0.9f;
        if (!this.rightHandAtPosition && rightHandNew) {
            dataHolder.vr.triggerHapticPulse(ControllerType.RIGHT, 0.01f, 100.0f, 1.0f);
        }
        if (!this.leftHandAtPosition && leftHandNew) {
            dataHolder.vr.triggerHapticPulse(ControllerType.LEFT, 0.01f, 100.0f, 1.0f);
        }
        this.rightHandAtPosition = rightHandNew;
        this.leftHandAtPosition = leftHandNew;
        if (VRState.VR_RUNNING) {
            if (this.calibrated && this.usingUnlabeledTrackers) {
                dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(false);
            } else {
                dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(this.leftHandAtPosition && this.rightHandAtPosition);
                if (VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.LEFT) && VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.RIGHT) && VivecraftVRMod.INSTANCE.keyVRInteract.consumeClick()) {
                    AutoCalibration.calibrateManual();
                    dataHolder.vr.calibrateFBT(this.yaw + (float)Math.PI);
                    dataHolder.vrSettings.unlabeledTrackersUsed = this.usingUnlabeledTrackers;
                    dataHolder.vrSettings.saveOptions();
                    ClientUtils.addChatMessage((Component)Component.translatable((String)"vivecraft.messages.fbtcalibrationsuccess"));
                    this.calibrated = true;
                    if (!this.usingUnlabeledTrackers) {
                        this.minecraft.setScreen(this.parent);
                    } else {
                        this.cancelButton.setMessage((Component)Component.translatable((String)"vivecraft.gui.ok"));
                        this.resetButton.visible = true;
                    }
                }
            }
        }
    }
}

