/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.renderer.entity.layers;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import org.joml.Matrix3f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.common.utils.MathUtils;

@Mixin(value={WingsLayer.class})
public abstract class WingsLayerMixin<S extends HumanoidRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    @Unique
    private final Vector3f vivecraft$tempV = new Vector3f();
    @Unique
    private final Matrix3f vivecraft$bodyRot = new Matrix3f();

    public WingsLayerMixin(RenderLayerParent<S, M> renderer) {
        super(renderer);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WrapOperation(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/HumanoidRenderState;FF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private void vivecraft$elytraPosition(PoseStack instance, float x, float y, float z, Operation<Void> original, @Local(argsOnly=true) HumanoidRenderState renderState) {
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)renderState).vivecraft$getRotInfo();
        EntityModel entityModel = this.getParentModel();
        if (entityModel instanceof PlayerModel) {
            PlayerModel model = (PlayerModel)entityModel;
            if (rotInfo != null) {
                this.vivecraft$bodyRot.rotationZYX(model.body.zRot, -model.body.yRot, -model.body.xRot);
                this.vivecraft$bodyRot.transform(MathUtils.UP, this.vivecraft$tempV);
                float xRotation = (float)Math.atan2(this.vivecraft$tempV.y, this.vivecraft$tempV.z) - 1.5707964f;
                this.vivecraft$bodyRot.transform(MathUtils.LEFT, this.vivecraft$tempV);
                float yRotation = (float)(-Math.atan2(this.vivecraft$tempV.x, this.vivecraft$tempV.y)) + 1.5707964f;
                float yOffset = 0.0f;
                if (renderState.isFallFlying) {
                    yOffset = 2.0f;
                } else if (renderState.isCrouching) {
                    yOffset = -3.0f;
                }
                this.vivecraft$tempV.set(0.0f, yOffset, 2.0f - 0.5f * (model.body.xRot / 1.5707964f));
                this.vivecraft$tempV.rotateX(xRotation);
                this.vivecraft$tempV.rotateZ(yRotation);
                this.vivecraft$tempV.add(model.body.x, model.body.y + 24.0f, model.body.z);
                ModelUtils.modelToWorld(renderState, (Vector3fc)this.vivecraft$tempV, rotInfo, 0.0f, false, false, this.vivecraft$tempV);
                original.call(new Object[]{instance, Float.valueOf(this.vivecraft$tempV.x), Float.valueOf(-this.vivecraft$tempV.y), Float.valueOf(-this.vivecraft$tempV.z)});
                instance.mulPose((Quaternionfc)Axis.XP.rotation(xRotation));
                instance.mulPose((Quaternionfc)Axis.YP.rotation(yRotation));
                return;
            }
        }
        original.call(new Object[]{instance, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)});
    }
}

